/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.machinelearning.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteBatchPredictionRequest extends MachineLearningRequest implements
        ToCopyableBuilder<DeleteBatchPredictionRequest.Builder, DeleteBatchPredictionRequest> {
    private static final SdkField<String> BATCH_PREDICTION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DeleteBatchPredictionRequest::batchPredictionId)).setter(setter(Builder::batchPredictionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BatchPredictionId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BATCH_PREDICTION_ID_FIELD));

    private final String batchPredictionId;

    private DeleteBatchPredictionRequest(BuilderImpl builder) {
        super(builder);
        this.batchPredictionId = builder.batchPredictionId;
    }

    /**
     * <p>
     * A user-supplied ID that uniquely identifies the <code>BatchPrediction</code>.
     * </p>
     * 
     * @return A user-supplied ID that uniquely identifies the <code>BatchPrediction</code>.
     */
    public String batchPredictionId() {
        return batchPredictionId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(batchPredictionId());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteBatchPredictionRequest)) {
            return false;
        }
        DeleteBatchPredictionRequest other = (DeleteBatchPredictionRequest) obj;
        return Objects.equals(batchPredictionId(), other.batchPredictionId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DeleteBatchPredictionRequest").add("BatchPredictionId", batchPredictionId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "BatchPredictionId":
            return Optional.ofNullable(clazz.cast(batchPredictionId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeleteBatchPredictionRequest, T> g) {
        return obj -> g.apply((DeleteBatchPredictionRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends MachineLearningRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, DeleteBatchPredictionRequest> {
        /**
         * <p>
         * A user-supplied ID that uniquely identifies the <code>BatchPrediction</code>.
         * </p>
         * 
         * @param batchPredictionId
         *        A user-supplied ID that uniquely identifies the <code>BatchPrediction</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder batchPredictionId(String batchPredictionId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends MachineLearningRequest.BuilderImpl implements Builder {
        private String batchPredictionId;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteBatchPredictionRequest model) {
            super(model);
            batchPredictionId(model.batchPredictionId);
        }

        public final String getBatchPredictionId() {
            return batchPredictionId;
        }

        @Override
        public final Builder batchPredictionId(String batchPredictionId) {
            this.batchPredictionId = batchPredictionId;
            return this;
        }

        public final void setBatchPredictionId(String batchPredictionId) {
            this.batchPredictionId = batchPredictionId;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteBatchPredictionRequest build() {
            return new DeleteBatchPredictionRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
