/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.macie.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.macie.model.S3Resource;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class FailedS3Resource
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, FailedS3Resource> {
    private static final SdkField<S3Resource> FAILED_ITEM_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(FailedS3Resource.getter(FailedS3Resource::failedItem)).setter(FailedS3Resource.setter(Builder::failedItem)).constructor(S3Resource::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failedItem").build()}).build();
    private static final SdkField<String> ERROR_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(FailedS3Resource.getter(FailedS3Resource::errorCode)).setter(FailedS3Resource.setter(Builder::errorCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("errorCode").build()}).build();
    private static final SdkField<String> ERROR_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(FailedS3Resource.getter(FailedS3Resource::errorMessage)).setter(FailedS3Resource.setter(Builder::errorMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("errorMessage").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FAILED_ITEM_FIELD, ERROR_CODE_FIELD, ERROR_MESSAGE_FIELD));
    private static final long serialVersionUID = 1L;
    private final S3Resource failedItem;
    private final String errorCode;
    private final String errorMessage;

    private FailedS3Resource(BuilderImpl builder) {
        this.failedItem = builder.failedItem;
        this.errorCode = builder.errorCode;
        this.errorMessage = builder.errorMessage;
    }

    public S3Resource failedItem() {
        return this.failedItem;
    }

    public String errorCode() {
        return this.errorCode;
    }

    public String errorMessage() {
        return this.errorMessage;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.failedItem());
        hashCode = 31 * hashCode + Objects.hashCode(this.errorCode());
        hashCode = 31 * hashCode + Objects.hashCode(this.errorMessage());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FailedS3Resource)) {
            return false;
        }
        FailedS3Resource other = (FailedS3Resource)obj;
        return Objects.equals(this.failedItem(), other.failedItem()) && Objects.equals(this.errorCode(), other.errorCode()) && Objects.equals(this.errorMessage(), other.errorMessage());
    }

    public String toString() {
        return ToString.builder((String)"FailedS3Resource").add("FailedItem", (Object)this.failedItem()).add("ErrorCode", (Object)this.errorCode()).add("ErrorMessage", (Object)this.errorMessage()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "failedItem": {
                return Optional.ofNullable(clazz.cast(this.failedItem()));
            }
            case "errorCode": {
                return Optional.ofNullable(clazz.cast(this.errorCode()));
            }
            case "errorMessage": {
                return Optional.ofNullable(clazz.cast(this.errorMessage()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<FailedS3Resource, T> g) {
        return obj -> g.apply((FailedS3Resource)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private S3Resource failedItem;
        private String errorCode;
        private String errorMessage;

        private BuilderImpl() {
        }

        private BuilderImpl(FailedS3Resource model) {
            this.failedItem(model.failedItem);
            this.errorCode(model.errorCode);
            this.errorMessage(model.errorMessage);
        }

        public final S3Resource.Builder getFailedItem() {
            return this.failedItem != null ? this.failedItem.toBuilder() : null;
        }

        @Override
        public final Builder failedItem(S3Resource failedItem) {
            this.failedItem = failedItem;
            return this;
        }

        public final void setFailedItem(S3Resource.BuilderImpl failedItem) {
            this.failedItem = failedItem != null ? failedItem.build() : null;
        }

        public final String getErrorCode() {
            return this.errorCode;
        }

        @Override
        public final Builder errorCode(String errorCode) {
            this.errorCode = errorCode;
            return this;
        }

        public final void setErrorCode(String errorCode) {
            this.errorCode = errorCode;
        }

        public final String getErrorMessage() {
            return this.errorMessage;
        }

        @Override
        public final Builder errorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
            return this;
        }

        public final void setErrorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
        }

        public FailedS3Resource build() {
            return new FailedS3Resource(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, FailedS3Resource> {
        public Builder failedItem(S3Resource var1);

        default public Builder failedItem(Consumer<S3Resource.Builder> failedItem) {
            return this.failedItem((S3Resource)((S3Resource.Builder)S3Resource.builder().applyMutation(failedItem)).build());
        }

        public Builder errorCode(String var1);

        public Builder errorMessage(String var1);
    }
}

