/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.macie.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListS3ResourcesResponse extends MacieResponse implements
        ToCopyableBuilder<ListS3ResourcesResponse.Builder, ListS3ResourcesResponse> {
    private static final SdkField<List<S3ResourceClassification>> S3_RESOURCES_FIELD = SdkField
            .<List<S3ResourceClassification>> builder(MarshallingType.LIST)
            .getter(getter(ListS3ResourcesResponse::s3Resources))
            .setter(setter(Builder::s3Resources))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("s3Resources").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<S3ResourceClassification> builder(MarshallingType.SDK_POJO)
                                            .constructor(S3ResourceClassification::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListS3ResourcesResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(S3_RESOURCES_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<S3ResourceClassification> s3Resources;

    private final String nextToken;

    private ListS3ResourcesResponse(BuilderImpl builder) {
        super(builder);
        this.s3Resources = builder.s3Resources;
        this.nextToken = builder.nextToken;
    }

    /**
     * Returns true if the S3Resources property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasS3Resources() {
        return s3Resources != null && !(s3Resources instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of the associated S3 resources returned by the action.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasS3Resources()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of the associated S3 resources returned by the action.
     */
    public List<S3ResourceClassification> s3Resources() {
        return s3Resources;
    }

    /**
     * <p>
     * When a response is generated, if there is more data to be listed, this parameter is present in the response and
     * contains the value to use for the nextToken parameter in a subsequent pagination request. If there is no more
     * data to be listed, this parameter is set to null.
     * </p>
     * 
     * @return When a response is generated, if there is more data to be listed, this parameter is present in the
     *         response and contains the value to use for the nextToken parameter in a subsequent pagination request. If
     *         there is no more data to be listed, this parameter is set to null.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(s3Resources());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListS3ResourcesResponse)) {
            return false;
        }
        ListS3ResourcesResponse other = (ListS3ResourcesResponse) obj;
        return Objects.equals(s3Resources(), other.s3Resources()) && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ListS3ResourcesResponse").add("S3Resources", s3Resources()).add("NextToken", nextToken())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "s3Resources":
            return Optional.ofNullable(clazz.cast(s3Resources()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListS3ResourcesResponse, T> g) {
        return obj -> g.apply((ListS3ResourcesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends MacieResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListS3ResourcesResponse> {
        /**
         * <p>
         * A list of the associated S3 resources returned by the action.
         * </p>
         * 
         * @param s3Resources
         *        A list of the associated S3 resources returned by the action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3Resources(Collection<S3ResourceClassification> s3Resources);

        /**
         * <p>
         * A list of the associated S3 resources returned by the action.
         * </p>
         * 
         * @param s3Resources
         *        A list of the associated S3 resources returned by the action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3Resources(S3ResourceClassification... s3Resources);

        /**
         * <p>
         * A list of the associated S3 resources returned by the action.
         * </p>
         * This is a convenience that creates an instance of the {@link List<S3ResourceClassification>.Builder} avoiding
         * the need to create one manually via {@link List<S3ResourceClassification>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<S3ResourceClassification>.Builder#build()} is called
         * immediately and its result is passed to {@link #s3Resources(List<S3ResourceClassification>)}.
         * 
         * @param s3Resources
         *        a consumer that will call methods on {@link List<S3ResourceClassification>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #s3Resources(List<S3ResourceClassification>)
         */
        Builder s3Resources(Consumer<S3ResourceClassification.Builder>... s3Resources);

        /**
         * <p>
         * When a response is generated, if there is more data to be listed, this parameter is present in the response
         * and contains the value to use for the nextToken parameter in a subsequent pagination request. If there is no
         * more data to be listed, this parameter is set to null.
         * </p>
         * 
         * @param nextToken
         *        When a response is generated, if there is more data to be listed, this parameter is present in the
         *        response and contains the value to use for the nextToken parameter in a subsequent pagination request.
         *        If there is no more data to be listed, this parameter is set to null.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends MacieResponse.BuilderImpl implements Builder {
        private List<S3ResourceClassification> s3Resources = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListS3ResourcesResponse model) {
            super(model);
            s3Resources(model.s3Resources);
            nextToken(model.nextToken);
        }

        public final Collection<S3ResourceClassification.Builder> getS3Resources() {
            return s3Resources != null ? s3Resources.stream().map(S3ResourceClassification::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder s3Resources(Collection<S3ResourceClassification> s3Resources) {
            this.s3Resources = S3ResourcesClassificationCopier.copy(s3Resources);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder s3Resources(S3ResourceClassification... s3Resources) {
            s3Resources(Arrays.asList(s3Resources));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder s3Resources(Consumer<S3ResourceClassification.Builder>... s3Resources) {
            s3Resources(Stream.of(s3Resources).map(c -> S3ResourceClassification.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setS3Resources(Collection<S3ResourceClassification.BuilderImpl> s3Resources) {
            this.s3Resources = S3ResourcesClassificationCopier.copyFromBuilder(s3Resources);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListS3ResourcesResponse build() {
            return new ListS3ResourcesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
