/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.macie.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.macie.model.ClassificationType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class S3ResourceClassification
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, S3ResourceClassification> {
    private static final SdkField<String> BUCKET_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("bucketName").getter(S3ResourceClassification.getter(S3ResourceClassification::bucketName)).setter(S3ResourceClassification.setter(Builder::bucketName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("bucketName").build()}).build();
    private static final SdkField<String> PREFIX_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("prefix").getter(S3ResourceClassification.getter(S3ResourceClassification::prefix)).setter(S3ResourceClassification.setter(Builder::prefix)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("prefix").build()}).build();
    private static final SdkField<ClassificationType> CLASSIFICATION_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("classificationType").getter(S3ResourceClassification.getter(S3ResourceClassification::classificationType)).setter(S3ResourceClassification.setter(Builder::classificationType)).constructor(ClassificationType::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("classificationType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BUCKET_NAME_FIELD, PREFIX_FIELD, CLASSIFICATION_TYPE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String bucketName;
    private final String prefix;
    private final ClassificationType classificationType;

    private S3ResourceClassification(BuilderImpl builder) {
        this.bucketName = builder.bucketName;
        this.prefix = builder.prefix;
        this.classificationType = builder.classificationType;
    }

    public final String bucketName() {
        return this.bucketName;
    }

    public final String prefix() {
        return this.prefix;
    }

    public final ClassificationType classificationType() {
        return this.classificationType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.bucketName());
        hashCode = 31 * hashCode + Objects.hashCode(this.prefix());
        hashCode = 31 * hashCode + Objects.hashCode(this.classificationType());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof S3ResourceClassification)) {
            return false;
        }
        S3ResourceClassification other = (S3ResourceClassification)obj;
        return Objects.equals(this.bucketName(), other.bucketName()) && Objects.equals(this.prefix(), other.prefix()) && Objects.equals(this.classificationType(), other.classificationType());
    }

    public final String toString() {
        return ToString.builder((String)"S3ResourceClassification").add("BucketName", (Object)this.bucketName()).add("Prefix", (Object)this.prefix()).add("ClassificationType", (Object)this.classificationType()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "bucketName": {
                return Optional.ofNullable(clazz.cast(this.bucketName()));
            }
            case "prefix": {
                return Optional.ofNullable(clazz.cast(this.prefix()));
            }
            case "classificationType": {
                return Optional.ofNullable(clazz.cast(this.classificationType()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<S3ResourceClassification, T> g) {
        return obj -> g.apply((S3ResourceClassification)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String bucketName;
        private String prefix;
        private ClassificationType classificationType;

        private BuilderImpl() {
        }

        private BuilderImpl(S3ResourceClassification model) {
            this.bucketName(model.bucketName);
            this.prefix(model.prefix);
            this.classificationType(model.classificationType);
        }

        public final String getBucketName() {
            return this.bucketName;
        }

        @Override
        public final Builder bucketName(String bucketName) {
            this.bucketName = bucketName;
            return this;
        }

        public final void setBucketName(String bucketName) {
            this.bucketName = bucketName;
        }

        public final String getPrefix() {
            return this.prefix;
        }

        @Override
        public final Builder prefix(String prefix) {
            this.prefix = prefix;
            return this;
        }

        public final void setPrefix(String prefix) {
            this.prefix = prefix;
        }

        public final ClassificationType.Builder getClassificationType() {
            return this.classificationType != null ? this.classificationType.toBuilder() : null;
        }

        @Override
        public final Builder classificationType(ClassificationType classificationType) {
            this.classificationType = classificationType;
            return this;
        }

        public final void setClassificationType(ClassificationType.BuilderImpl classificationType) {
            this.classificationType = classificationType != null ? classificationType.build() : null;
        }

        public S3ResourceClassification build() {
            return new S3ResourceClassification(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, S3ResourceClassification> {
        public Builder bucketName(String var1);

        public Builder prefix(String var1);

        public Builder classificationType(ClassificationType var1);

        default public Builder classificationType(Consumer<ClassificationType.Builder> classificationType) {
            return this.classificationType((ClassificationType)((ClassificationType.Builder)ClassificationType.builder().applyMutation(classificationType)).build());
        }
    }
}

