/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.macie.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class AssociateS3ResourcesRequest extends MacieRequest implements
        ToCopyableBuilder<AssociateS3ResourcesRequest.Builder, AssociateS3ResourcesRequest> {
    private static final SdkField<String> MEMBER_ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("memberAccountId").getter(getter(AssociateS3ResourcesRequest::memberAccountId))
            .setter(setter(Builder::memberAccountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("memberAccountId").build()).build();

    private static final SdkField<List<S3ResourceClassification>> S3_RESOURCES_FIELD = SdkField
            .<List<S3ResourceClassification>> builder(MarshallingType.LIST)
            .memberName("s3Resources")
            .getter(getter(AssociateS3ResourcesRequest::s3Resources))
            .setter(setter(Builder::s3Resources))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("s3Resources").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<S3ResourceClassification> builder(MarshallingType.SDK_POJO)
                                            .constructor(S3ResourceClassification::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MEMBER_ACCOUNT_ID_FIELD,
            S3_RESOURCES_FIELD));

    private final String memberAccountId;

    private final List<S3ResourceClassification> s3Resources;

    private AssociateS3ResourcesRequest(BuilderImpl builder) {
        super(builder);
        this.memberAccountId = builder.memberAccountId;
        this.s3Resources = builder.s3Resources;
    }

    /**
     * <p>
     * The ID of the Amazon Macie Classic member account whose resources you want to associate with Macie Classic.
     * </p>
     * 
     * @return The ID of the Amazon Macie Classic member account whose resources you want to associate with Macie
     *         Classic.
     */
    public final String memberAccountId() {
        return memberAccountId;
    }

    /**
     * Returns true if the S3Resources property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasS3Resources() {
        return s3Resources != null && !(s3Resources instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The S3 resources that you want to associate with Amazon Macie Classic for monitoring and data classification.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasS3Resources()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The S3 resources that you want to associate with Amazon Macie Classic for monitoring and data
     *         classification.
     */
    public final List<S3ResourceClassification> s3Resources() {
        return s3Resources;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(memberAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(hasS3Resources() ? s3Resources() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssociateS3ResourcesRequest)) {
            return false;
        }
        AssociateS3ResourcesRequest other = (AssociateS3ResourcesRequest) obj;
        return Objects.equals(memberAccountId(), other.memberAccountId()) && hasS3Resources() == other.hasS3Resources()
                && Objects.equals(s3Resources(), other.s3Resources());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AssociateS3ResourcesRequest").add("MemberAccountId", memberAccountId())
                .add("S3Resources", hasS3Resources() ? s3Resources() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "memberAccountId":
            return Optional.ofNullable(clazz.cast(memberAccountId()));
        case "s3Resources":
            return Optional.ofNullable(clazz.cast(s3Resources()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AssociateS3ResourcesRequest, T> g) {
        return obj -> g.apply((AssociateS3ResourcesRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends MacieRequest.Builder, SdkPojo, CopyableBuilder<Builder, AssociateS3ResourcesRequest> {
        /**
         * <p>
         * The ID of the Amazon Macie Classic member account whose resources you want to associate with Macie Classic.
         * </p>
         * 
         * @param memberAccountId
         *        The ID of the Amazon Macie Classic member account whose resources you want to associate with Macie
         *        Classic.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder memberAccountId(String memberAccountId);

        /**
         * <p>
         * The S3 resources that you want to associate with Amazon Macie Classic for monitoring and data classification.
         * </p>
         * 
         * @param s3Resources
         *        The S3 resources that you want to associate with Amazon Macie Classic for monitoring and data
         *        classification.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3Resources(Collection<S3ResourceClassification> s3Resources);

        /**
         * <p>
         * The S3 resources that you want to associate with Amazon Macie Classic for monitoring and data classification.
         * </p>
         * 
         * @param s3Resources
         *        The S3 resources that you want to associate with Amazon Macie Classic for monitoring and data
         *        classification.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3Resources(S3ResourceClassification... s3Resources);

        /**
         * <p>
         * The S3 resources that you want to associate with Amazon Macie Classic for monitoring and data classification.
         * </p>
         * This is a convenience that creates an instance of the {@link List<S3ResourceClassification>.Builder} avoiding
         * the need to create one manually via {@link List<S3ResourceClassification>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<S3ResourceClassification>.Builder#build()} is called
         * immediately and its result is passed to {@link #s3Resources(List<S3ResourceClassification>)}.
         * 
         * @param s3Resources
         *        a consumer that will call methods on {@link List<S3ResourceClassification>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #s3Resources(List<S3ResourceClassification>)
         */
        Builder s3Resources(Consumer<S3ResourceClassification.Builder>... s3Resources);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends MacieRequest.BuilderImpl implements Builder {
        private String memberAccountId;

        private List<S3ResourceClassification> s3Resources = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AssociateS3ResourcesRequest model) {
            super(model);
            memberAccountId(model.memberAccountId);
            s3Resources(model.s3Resources);
        }

        public final String getMemberAccountId() {
            return memberAccountId;
        }

        @Override
        public final Builder memberAccountId(String memberAccountId) {
            this.memberAccountId = memberAccountId;
            return this;
        }

        public final void setMemberAccountId(String memberAccountId) {
            this.memberAccountId = memberAccountId;
        }

        public final Collection<S3ResourceClassification.Builder> getS3Resources() {
            if (s3Resources instanceof SdkAutoConstructList) {
                return null;
            }
            return s3Resources != null ? s3Resources.stream().map(S3ResourceClassification::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder s3Resources(Collection<S3ResourceClassification> s3Resources) {
            this.s3Resources = S3ResourcesClassificationCopier.copy(s3Resources);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder s3Resources(S3ResourceClassification... s3Resources) {
            s3Resources(Arrays.asList(s3Resources));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder s3Resources(Consumer<S3ResourceClassification.Builder>... s3Resources) {
            s3Resources(Stream.of(s3Resources).map(c -> S3ResourceClassification.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setS3Resources(Collection<S3ResourceClassification.BuilderImpl> s3Resources) {
            this.s3Resources = S3ResourcesClassificationCopier.copyFromBuilder(s3Resources);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public AssociateS3ResourcesRequest build() {
            return new AssociateS3ResourcesRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
