/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.macie.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The S3 resources whose classification types you want to update. This data type is used as a request parameter in the
 * UpdateS3Resources action.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class S3ResourceClassificationUpdate implements SdkPojo, Serializable,
        ToCopyableBuilder<S3ResourceClassificationUpdate.Builder, S3ResourceClassificationUpdate> {
    private static final SdkField<String> BUCKET_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("bucketName").getter(getter(S3ResourceClassificationUpdate::bucketName))
            .setter(setter(Builder::bucketName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("bucketName").build()).build();

    private static final SdkField<String> PREFIX_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("prefix")
            .getter(getter(S3ResourceClassificationUpdate::prefix)).setter(setter(Builder::prefix))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("prefix").build()).build();

    private static final SdkField<ClassificationTypeUpdate> CLASSIFICATION_TYPE_UPDATE_FIELD = SdkField
            .<ClassificationTypeUpdate> builder(MarshallingType.SDK_POJO).memberName("classificationTypeUpdate")
            .getter(getter(S3ResourceClassificationUpdate::classificationTypeUpdate))
            .setter(setter(Builder::classificationTypeUpdate)).constructor(ClassificationTypeUpdate::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("classificationTypeUpdate").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BUCKET_NAME_FIELD,
            PREFIX_FIELD, CLASSIFICATION_TYPE_UPDATE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String bucketName;

    private final String prefix;

    private final ClassificationTypeUpdate classificationTypeUpdate;

    private S3ResourceClassificationUpdate(BuilderImpl builder) {
        this.bucketName = builder.bucketName;
        this.prefix = builder.prefix;
        this.classificationTypeUpdate = builder.classificationTypeUpdate;
    }

    /**
     * <p>
     * The name of the S3 bucket whose classification types you want to update.
     * </p>
     * 
     * @return The name of the S3 bucket whose classification types you want to update.
     */
    public final String bucketName() {
        return bucketName;
    }

    /**
     * <p>
     * The prefix of the S3 bucket whose classification types you want to update.
     * </p>
     * 
     * @return The prefix of the S3 bucket whose classification types you want to update.
     */
    public final String prefix() {
        return prefix;
    }

    /**
     * <p>
     * The classification type that you want to update for the resource associated with Amazon Macie Classic.
     * </p>
     * 
     * @return The classification type that you want to update for the resource associated with Amazon Macie Classic.
     */
    public final ClassificationTypeUpdate classificationTypeUpdate() {
        return classificationTypeUpdate;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(bucketName());
        hashCode = 31 * hashCode + Objects.hashCode(prefix());
        hashCode = 31 * hashCode + Objects.hashCode(classificationTypeUpdate());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof S3ResourceClassificationUpdate)) {
            return false;
        }
        S3ResourceClassificationUpdate other = (S3ResourceClassificationUpdate) obj;
        return Objects.equals(bucketName(), other.bucketName()) && Objects.equals(prefix(), other.prefix())
                && Objects.equals(classificationTypeUpdate(), other.classificationTypeUpdate());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("S3ResourceClassificationUpdate").add("BucketName", bucketName()).add("Prefix", prefix())
                .add("ClassificationTypeUpdate", classificationTypeUpdate()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "bucketName":
            return Optional.ofNullable(clazz.cast(bucketName()));
        case "prefix":
            return Optional.ofNullable(clazz.cast(prefix()));
        case "classificationTypeUpdate":
            return Optional.ofNullable(clazz.cast(classificationTypeUpdate()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<S3ResourceClassificationUpdate, T> g) {
        return obj -> g.apply((S3ResourceClassificationUpdate) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, S3ResourceClassificationUpdate> {
        /**
         * <p>
         * The name of the S3 bucket whose classification types you want to update.
         * </p>
         * 
         * @param bucketName
         *        The name of the S3 bucket whose classification types you want to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bucketName(String bucketName);

        /**
         * <p>
         * The prefix of the S3 bucket whose classification types you want to update.
         * </p>
         * 
         * @param prefix
         *        The prefix of the S3 bucket whose classification types you want to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder prefix(String prefix);

        /**
         * <p>
         * The classification type that you want to update for the resource associated with Amazon Macie Classic.
         * </p>
         * 
         * @param classificationTypeUpdate
         *        The classification type that you want to update for the resource associated with Amazon Macie Classic.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder classificationTypeUpdate(ClassificationTypeUpdate classificationTypeUpdate);

        /**
         * <p>
         * The classification type that you want to update for the resource associated with Amazon Macie Classic.
         * </p>
         * This is a convenience that creates an instance of the {@link ClassificationTypeUpdate.Builder} avoiding the
         * need to create one manually via {@link ClassificationTypeUpdate#builder()}.
         *
         * When the {@link Consumer} completes, {@link ClassificationTypeUpdate.Builder#build()} is called immediately
         * and its result is passed to {@link #classificationTypeUpdate(ClassificationTypeUpdate)}.
         * 
         * @param classificationTypeUpdate
         *        a consumer that will call methods on {@link ClassificationTypeUpdate.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #classificationTypeUpdate(ClassificationTypeUpdate)
         */
        default Builder classificationTypeUpdate(Consumer<ClassificationTypeUpdate.Builder> classificationTypeUpdate) {
            return classificationTypeUpdate(ClassificationTypeUpdate.builder().applyMutation(classificationTypeUpdate).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String bucketName;

        private String prefix;

        private ClassificationTypeUpdate classificationTypeUpdate;

        private BuilderImpl() {
        }

        private BuilderImpl(S3ResourceClassificationUpdate model) {
            bucketName(model.bucketName);
            prefix(model.prefix);
            classificationTypeUpdate(model.classificationTypeUpdate);
        }

        public final String getBucketName() {
            return bucketName;
        }

        @Override
        public final Builder bucketName(String bucketName) {
            this.bucketName = bucketName;
            return this;
        }

        public final void setBucketName(String bucketName) {
            this.bucketName = bucketName;
        }

        public final String getPrefix() {
            return prefix;
        }

        @Override
        public final Builder prefix(String prefix) {
            this.prefix = prefix;
            return this;
        }

        public final void setPrefix(String prefix) {
            this.prefix = prefix;
        }

        public final ClassificationTypeUpdate.Builder getClassificationTypeUpdate() {
            return classificationTypeUpdate != null ? classificationTypeUpdate.toBuilder() : null;
        }

        @Override
        public final Builder classificationTypeUpdate(ClassificationTypeUpdate classificationTypeUpdate) {
            this.classificationTypeUpdate = classificationTypeUpdate;
            return this;
        }

        public final void setClassificationTypeUpdate(ClassificationTypeUpdate.BuilderImpl classificationTypeUpdate) {
            this.classificationTypeUpdate = classificationTypeUpdate != null ? classificationTypeUpdate.build() : null;
        }

        @Override
        public S3ResourceClassificationUpdate build() {
            return new S3ResourceClassificationUpdate(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
