/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.macie.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.macie.model.MacieRequest;
import software.amazon.awssdk.services.macie.model.S3Resource;
import software.amazon.awssdk.services.macie.model.S3ResourcesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DisassociateS3ResourcesRequest
extends MacieRequest
implements ToCopyableBuilder<Builder, DisassociateS3ResourcesRequest> {
    private static final SdkField<String> MEMBER_ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("memberAccountId").getter(DisassociateS3ResourcesRequest.getter(DisassociateS3ResourcesRequest::memberAccountId)).setter(DisassociateS3ResourcesRequest.setter(Builder::memberAccountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("memberAccountId").build()}).build();
    private static final SdkField<List<S3Resource>> ASSOCIATED_S3_RESOURCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("associatedS3Resources").getter(DisassociateS3ResourcesRequest.getter(DisassociateS3ResourcesRequest::associatedS3Resources)).setter(DisassociateS3ResourcesRequest.setter(Builder::associatedS3Resources)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("associatedS3Resources").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(S3Resource::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MEMBER_ACCOUNT_ID_FIELD, ASSOCIATED_S3_RESOURCES_FIELD));
    private final String memberAccountId;
    private final List<S3Resource> associatedS3Resources;

    private DisassociateS3ResourcesRequest(BuilderImpl builder) {
        super(builder);
        this.memberAccountId = builder.memberAccountId;
        this.associatedS3Resources = builder.associatedS3Resources;
    }

    public final String memberAccountId() {
        return this.memberAccountId;
    }

    public final boolean hasAssociatedS3Resources() {
        return this.associatedS3Resources != null && !(this.associatedS3Resources instanceof SdkAutoConstructList);
    }

    public final List<S3Resource> associatedS3Resources() {
        return this.associatedS3Resources;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.memberAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAssociatedS3Resources() ? this.associatedS3Resources() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DisassociateS3ResourcesRequest)) {
            return false;
        }
        DisassociateS3ResourcesRequest other = (DisassociateS3ResourcesRequest)((Object)obj);
        return Objects.equals(this.memberAccountId(), other.memberAccountId()) && this.hasAssociatedS3Resources() == other.hasAssociatedS3Resources() && Objects.equals(this.associatedS3Resources(), other.associatedS3Resources());
    }

    public final String toString() {
        return ToString.builder((String)"DisassociateS3ResourcesRequest").add("MemberAccountId", (Object)this.memberAccountId()).add("AssociatedS3Resources", this.hasAssociatedS3Resources() ? this.associatedS3Resources() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "memberAccountId": {
                return Optional.ofNullable(clazz.cast(this.memberAccountId()));
            }
            case "associatedS3Resources": {
                return Optional.ofNullable(clazz.cast(this.associatedS3Resources()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DisassociateS3ResourcesRequest, T> g) {
        return obj -> g.apply((DisassociateS3ResourcesRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends MacieRequest.BuilderImpl
    implements Builder {
        private String memberAccountId;
        private List<S3Resource> associatedS3Resources = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DisassociateS3ResourcesRequest model) {
            super(model);
            this.memberAccountId(model.memberAccountId);
            this.associatedS3Resources(model.associatedS3Resources);
        }

        public final String getMemberAccountId() {
            return this.memberAccountId;
        }

        public final void setMemberAccountId(String memberAccountId) {
            this.memberAccountId = memberAccountId;
        }

        @Override
        @Transient
        public final Builder memberAccountId(String memberAccountId) {
            this.memberAccountId = memberAccountId;
            return this;
        }

        public final List<S3Resource.Builder> getAssociatedS3Resources() {
            List<S3Resource.Builder> result = S3ResourcesCopier.copyToBuilder(this.associatedS3Resources);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAssociatedS3Resources(Collection<S3Resource.BuilderImpl> associatedS3Resources) {
            this.associatedS3Resources = S3ResourcesCopier.copyFromBuilder(associatedS3Resources);
        }

        @Override
        @Transient
        public final Builder associatedS3Resources(Collection<S3Resource> associatedS3Resources) {
            this.associatedS3Resources = S3ResourcesCopier.copy(associatedS3Resources);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder associatedS3Resources(S3Resource ... associatedS3Resources) {
            this.associatedS3Resources(Arrays.asList(associatedS3Resources));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder associatedS3Resources(Consumer<S3Resource.Builder> ... associatedS3Resources) {
            this.associatedS3Resources(Stream.of(associatedS3Resources).map(c -> (S3Resource)((S3Resource.Builder)S3Resource.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DisassociateS3ResourcesRequest build() {
            return new DisassociateS3ResourcesRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends MacieRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DisassociateS3ResourcesRequest> {
        public Builder memberAccountId(String var1);

        public Builder associatedS3Resources(Collection<S3Resource> var1);

        public Builder associatedS3Resources(S3Resource ... var1);

        public Builder associatedS3Resources(Consumer<S3Resource.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

