/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.macie.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class AssociateMemberAccountRequest extends MacieRequest implements
        ToCopyableBuilder<AssociateMemberAccountRequest.Builder, AssociateMemberAccountRequest> {
    private static final SdkField<String> MEMBER_ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("memberAccountId").getter(getter(AssociateMemberAccountRequest::memberAccountId))
            .setter(setter(Builder::memberAccountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("memberAccountId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MEMBER_ACCOUNT_ID_FIELD));

    private final String memberAccountId;

    private AssociateMemberAccountRequest(BuilderImpl builder) {
        super(builder);
        this.memberAccountId = builder.memberAccountId;
    }

    /**
     * <p>
     * (Discontinued) The ID of the Amazon Web Services account that you want to associate with Amazon Macie Classic as
     * a member account.
     * </p>
     * 
     * @return (Discontinued) The ID of the Amazon Web Services account that you want to associate with Amazon Macie
     *         Classic as a member account.
     */
    public final String memberAccountId() {
        return memberAccountId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(memberAccountId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssociateMemberAccountRequest)) {
            return false;
        }
        AssociateMemberAccountRequest other = (AssociateMemberAccountRequest) obj;
        return Objects.equals(memberAccountId(), other.memberAccountId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AssociateMemberAccountRequest").add("MemberAccountId", memberAccountId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "memberAccountId":
            return Optional.ofNullable(clazz.cast(memberAccountId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AssociateMemberAccountRequest, T> g) {
        return obj -> g.apply((AssociateMemberAccountRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends MacieRequest.Builder, SdkPojo, CopyableBuilder<Builder, AssociateMemberAccountRequest> {
        /**
         * <p>
         * (Discontinued) The ID of the Amazon Web Services account that you want to associate with Amazon Macie Classic
         * as a member account.
         * </p>
         * 
         * @param memberAccountId
         *        (Discontinued) The ID of the Amazon Web Services account that you want to associate with Amazon Macie
         *        Classic as a member account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder memberAccountId(String memberAccountId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends MacieRequest.BuilderImpl implements Builder {
        private String memberAccountId;

        private BuilderImpl() {
        }

        private BuilderImpl(AssociateMemberAccountRequest model) {
            super(model);
            memberAccountId(model.memberAccountId);
        }

        public final String getMemberAccountId() {
            return memberAccountId;
        }

        public final void setMemberAccountId(String memberAccountId) {
            this.memberAccountId = memberAccountId;
        }

        @Override
        @Transient
        public final Builder memberAccountId(String memberAccountId) {
            this.memberAccountId = memberAccountId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public AssociateMemberAccountRequest build() {
            return new AssociateMemberAccountRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
