/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.macie;

import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.awscore.client.handler.AwsSyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.ApiName;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.client.handler.SyncClientHandler;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.services.macie.MacieClient;
import software.amazon.awssdk.services.macie.model.AccessDeniedException;
import software.amazon.awssdk.services.macie.model.AssociateMemberAccountRequest;
import software.amazon.awssdk.services.macie.model.AssociateMemberAccountResponse;
import software.amazon.awssdk.services.macie.model.AssociateS3ResourcesRequest;
import software.amazon.awssdk.services.macie.model.AssociateS3ResourcesResponse;
import software.amazon.awssdk.services.macie.model.DisassociateMemberAccountRequest;
import software.amazon.awssdk.services.macie.model.DisassociateMemberAccountResponse;
import software.amazon.awssdk.services.macie.model.DisassociateS3ResourcesRequest;
import software.amazon.awssdk.services.macie.model.DisassociateS3ResourcesResponse;
import software.amazon.awssdk.services.macie.model.InternalException;
import software.amazon.awssdk.services.macie.model.InvalidInputException;
import software.amazon.awssdk.services.macie.model.LimitExceededException;
import software.amazon.awssdk.services.macie.model.ListMemberAccountsRequest;
import software.amazon.awssdk.services.macie.model.ListMemberAccountsResponse;
import software.amazon.awssdk.services.macie.model.ListS3ResourcesRequest;
import software.amazon.awssdk.services.macie.model.ListS3ResourcesResponse;
import software.amazon.awssdk.services.macie.model.MacieException;
import software.amazon.awssdk.services.macie.model.MacieRequest;
import software.amazon.awssdk.services.macie.model.UpdateS3ResourcesRequest;
import software.amazon.awssdk.services.macie.model.UpdateS3ResourcesResponse;
import software.amazon.awssdk.services.macie.paginators.ListMemberAccountsIterable;
import software.amazon.awssdk.services.macie.paginators.ListS3ResourcesIterable;
import software.amazon.awssdk.services.macie.transform.AssociateMemberAccountRequestMarshaller;
import software.amazon.awssdk.services.macie.transform.AssociateS3ResourcesRequestMarshaller;
import software.amazon.awssdk.services.macie.transform.DisassociateMemberAccountRequestMarshaller;
import software.amazon.awssdk.services.macie.transform.DisassociateS3ResourcesRequestMarshaller;
import software.amazon.awssdk.services.macie.transform.ListMemberAccountsRequestMarshaller;
import software.amazon.awssdk.services.macie.transform.ListS3ResourcesRequestMarshaller;
import software.amazon.awssdk.services.macie.transform.UpdateS3ResourcesRequestMarshaller;
import software.amazon.awssdk.utils.Logger;

@SdkInternalApi
final class DefaultMacieClient
implements MacieClient {
    private static final Logger log = Logger.loggerFor(DefaultMacieClient.class);
    private final SyncClientHandler clientHandler;
    private final AwsJsonProtocolFactory protocolFactory;
    private final SdkClientConfiguration clientConfiguration;

    protected DefaultMacieClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsSyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration;
        this.protocolFactory = this.init(AwsJsonProtocolFactory.builder()).build();
    }

    public final String serviceName() {
        return "macie";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AssociateMemberAccountResponse associateMemberAccount(AssociateMemberAccountRequest associateMemberAccountRequest) throws InvalidInputException, LimitExceededException, InternalException, AwsServiceException, SdkClientException, MacieException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, AssociateMemberAccountResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultMacieClient.resolveMetricPublishers(this.clientConfiguration, associateMemberAccountRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Macie");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"AssociateMemberAccount");
            AssociateMemberAccountResponse associateMemberAccountResponse = (AssociateMemberAccountResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("AssociateMemberAccount").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)associateMemberAccountRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new AssociateMemberAccountRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return associateMemberAccountResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultMacieClient.lambda$associateMemberAccount$0((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AssociateS3ResourcesResponse associateS3Resources(AssociateS3ResourcesRequest associateS3ResourcesRequest) throws InvalidInputException, AccessDeniedException, LimitExceededException, InternalException, AwsServiceException, SdkClientException, MacieException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, AssociateS3ResourcesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultMacieClient.resolveMetricPublishers(this.clientConfiguration, associateS3ResourcesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Macie");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"AssociateS3Resources");
            AssociateS3ResourcesResponse associateS3ResourcesResponse = (AssociateS3ResourcesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("AssociateS3Resources").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)associateS3ResourcesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new AssociateS3ResourcesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return associateS3ResourcesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultMacieClient.lambda$associateS3Resources$1((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DisassociateMemberAccountResponse disassociateMemberAccount(DisassociateMemberAccountRequest disassociateMemberAccountRequest) throws InvalidInputException, InternalException, AwsServiceException, SdkClientException, MacieException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DisassociateMemberAccountResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultMacieClient.resolveMetricPublishers(this.clientConfiguration, disassociateMemberAccountRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Macie");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DisassociateMemberAccount");
            DisassociateMemberAccountResponse disassociateMemberAccountResponse = (DisassociateMemberAccountResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DisassociateMemberAccount").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)disassociateMemberAccountRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DisassociateMemberAccountRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return disassociateMemberAccountResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultMacieClient.lambda$disassociateMemberAccount$2((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DisassociateS3ResourcesResponse disassociateS3Resources(DisassociateS3ResourcesRequest disassociateS3ResourcesRequest) throws InvalidInputException, AccessDeniedException, InternalException, AwsServiceException, SdkClientException, MacieException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DisassociateS3ResourcesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultMacieClient.resolveMetricPublishers(this.clientConfiguration, disassociateS3ResourcesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Macie");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DisassociateS3Resources");
            DisassociateS3ResourcesResponse disassociateS3ResourcesResponse = (DisassociateS3ResourcesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DisassociateS3Resources").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)disassociateS3ResourcesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DisassociateS3ResourcesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return disassociateS3ResourcesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultMacieClient.lambda$disassociateS3Resources$3((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListMemberAccountsResponse listMemberAccounts(ListMemberAccountsRequest listMemberAccountsRequest) throws InternalException, InvalidInputException, AwsServiceException, SdkClientException, MacieException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListMemberAccountsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultMacieClient.resolveMetricPublishers(this.clientConfiguration, listMemberAccountsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Macie");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListMemberAccounts");
            ListMemberAccountsResponse listMemberAccountsResponse = (ListMemberAccountsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListMemberAccounts").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listMemberAccountsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListMemberAccountsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listMemberAccountsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultMacieClient.lambda$listMemberAccounts$4((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public ListMemberAccountsIterable listMemberAccountsPaginator(ListMemberAccountsRequest listMemberAccountsRequest) throws InternalException, InvalidInputException, AwsServiceException, SdkClientException, MacieException {
        return new ListMemberAccountsIterable(this, this.applyPaginatorUserAgent(listMemberAccountsRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListS3ResourcesResponse listS3Resources(ListS3ResourcesRequest listS3ResourcesRequest) throws InvalidInputException, AccessDeniedException, InternalException, AwsServiceException, SdkClientException, MacieException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListS3ResourcesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultMacieClient.resolveMetricPublishers(this.clientConfiguration, listS3ResourcesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Macie");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListS3Resources");
            ListS3ResourcesResponse listS3ResourcesResponse = (ListS3ResourcesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListS3Resources").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listS3ResourcesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListS3ResourcesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listS3ResourcesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultMacieClient.lambda$listS3Resources$5((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public ListS3ResourcesIterable listS3ResourcesPaginator(ListS3ResourcesRequest listS3ResourcesRequest) throws InvalidInputException, AccessDeniedException, InternalException, AwsServiceException, SdkClientException, MacieException {
        return new ListS3ResourcesIterable(this, this.applyPaginatorUserAgent(listS3ResourcesRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateS3ResourcesResponse updateS3Resources(UpdateS3ResourcesRequest updateS3ResourcesRequest) throws InvalidInputException, AccessDeniedException, InternalException, AwsServiceException, SdkClientException, MacieException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateS3ResourcesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultMacieClient.resolveMetricPublishers(this.clientConfiguration, updateS3ResourcesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Macie");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateS3Resources");
            UpdateS3ResourcesResponse updateS3ResourcesResponse = (UpdateS3ResourcesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateS3Resources").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateS3ResourcesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateS3ResourcesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateS3ResourcesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultMacieClient.lambda$updateS3Resources$6((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration, RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = (List)clientConfiguration.option((ClientOption)SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory, JsonOperationMetadata operationMetadata) {
        return protocolFactory.createErrorResponseHandler(operationMetadata);
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return (T)builder.clientConfiguration(this.clientConfiguration).defaultServiceExceptionSupplier(MacieException::builder).protocol(AwsJsonProtocol.AWS_JSON).protocolVersion("1.1").registerModeledException(ExceptionMetadata.builder().errorCode("AccessDeniedException").exceptionBuilderSupplier(AccessDeniedException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidInputException").exceptionBuilderSupplier(InvalidInputException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InternalException").exceptionBuilderSupplier(InternalException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("LimitExceededException").exceptionBuilderSupplier(LimitExceededException::builder).build());
    }

    public void close() {
        this.clientHandler.close();
    }

    private <T extends MacieRequest> T applyPaginatorUserAgent(T request) {
        Consumer<AwsRequestOverrideConfiguration.Builder> userAgentApplier = b -> {
            AwsRequestOverrideConfiguration.Builder cfr_ignored_0 = (AwsRequestOverrideConfiguration.Builder)b.addApiName(ApiName.builder().version("2.17.182").name("PAGINATED").build());
        };
        AwsRequestOverrideConfiguration overrideConfiguration = request.overrideConfiguration().map(c -> ((AwsRequestOverrideConfiguration.Builder)c.toBuilder().applyMutation(userAgentApplier)).build()).orElse(((AwsRequestOverrideConfiguration.Builder)AwsRequestOverrideConfiguration.builder().applyMutation(userAgentApplier)).build());
        return (T)((Object)((MacieRequest)request.toBuilder().overrideConfiguration(overrideConfiguration).build()));
    }

    private static /* synthetic */ void lambda$updateS3Resources$6(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listS3Resources$5(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listMemberAccounts$4(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$disassociateS3Resources$3(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$disassociateMemberAccount$2(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$associateS3Resources$1(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$associateMemberAccount$0(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }
}

