/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.macie.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;

@Generated("software.amazon.awssdk:codegen")
final class S3ResourcesClassificationUpdateCopier {
    static List<S3ResourceClassificationUpdate> copy(
            Collection<? extends S3ResourceClassificationUpdate> s3ResourcesClassificationUpdateParam) {
        List<S3ResourceClassificationUpdate> list;
        if (s3ResourcesClassificationUpdateParam == null || s3ResourcesClassificationUpdateParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<S3ResourceClassificationUpdate> modifiableList = new ArrayList<>();
            s3ResourcesClassificationUpdateParam.forEach(entry -> {
                modifiableList.add(entry);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<S3ResourceClassificationUpdate> copyFromBuilder(
            Collection<? extends S3ResourceClassificationUpdate.Builder> s3ResourcesClassificationUpdateParam) {
        List<S3ResourceClassificationUpdate> list;
        if (s3ResourcesClassificationUpdateParam == null || s3ResourcesClassificationUpdateParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<S3ResourceClassificationUpdate> modifiableList = new ArrayList<>();
            s3ResourcesClassificationUpdateParam.forEach(entry -> {
                S3ResourceClassificationUpdate member = entry.build();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<S3ResourceClassificationUpdate.Builder> copyToBuilder(
            Collection<? extends S3ResourceClassificationUpdate> s3ResourcesClassificationUpdateParam) {
        List<S3ResourceClassificationUpdate.Builder> list;
        if (s3ResourcesClassificationUpdateParam == null || s3ResourcesClassificationUpdateParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<S3ResourceClassificationUpdate.Builder> modifiableList = new ArrayList<>();
            s3ResourcesClassificationUpdateParam.forEach(entry -> {
                S3ResourceClassificationUpdate.Builder member = entry.toBuilder();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }
}
