/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.macie.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateS3ResourcesRequest extends MacieRequest implements
        ToCopyableBuilder<UpdateS3ResourcesRequest.Builder, UpdateS3ResourcesRequest> {
    private static final SdkField<String> MEMBER_ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("memberAccountId").getter(getter(UpdateS3ResourcesRequest::memberAccountId))
            .setter(setter(Builder::memberAccountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("memberAccountId").build()).build();

    private static final SdkField<List<S3ResourceClassificationUpdate>> S3_RESOURCES_UPDATE_FIELD = SdkField
            .<List<S3ResourceClassificationUpdate>> builder(MarshallingType.LIST)
            .memberName("s3ResourcesUpdate")
            .getter(getter(UpdateS3ResourcesRequest::s3ResourcesUpdate))
            .setter(setter(Builder::s3ResourcesUpdate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("s3ResourcesUpdate").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<S3ResourceClassificationUpdate> builder(MarshallingType.SDK_POJO)
                                            .constructor(S3ResourceClassificationUpdate::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MEMBER_ACCOUNT_ID_FIELD,
            S3_RESOURCES_UPDATE_FIELD));

    private final String memberAccountId;

    private final List<S3ResourceClassificationUpdate> s3ResourcesUpdate;

    private UpdateS3ResourcesRequest(BuilderImpl builder) {
        super(builder);
        this.memberAccountId = builder.memberAccountId;
        this.s3ResourcesUpdate = builder.s3ResourcesUpdate;
    }

    /**
     * <p>
     * The AWS ID of the Amazon Macie Classic member account whose S3 resources' classification types you want to
     * update.
     * </p>
     * 
     * @return The AWS ID of the Amazon Macie Classic member account whose S3 resources' classification types you want
     *         to update.
     */
    public final String memberAccountId() {
        return memberAccountId;
    }

    /**
     * For responses, this returns true if the service returned a value for the S3ResourcesUpdate property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasS3ResourcesUpdate() {
        return s3ResourcesUpdate != null && !(s3ResourcesUpdate instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The S3 resources whose classification types you want to update.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasS3ResourcesUpdate} method.
     * </p>
     * 
     * @return The S3 resources whose classification types you want to update.
     */
    public final List<S3ResourceClassificationUpdate> s3ResourcesUpdate() {
        return s3ResourcesUpdate;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(memberAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(hasS3ResourcesUpdate() ? s3ResourcesUpdate() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateS3ResourcesRequest)) {
            return false;
        }
        UpdateS3ResourcesRequest other = (UpdateS3ResourcesRequest) obj;
        return Objects.equals(memberAccountId(), other.memberAccountId())
                && hasS3ResourcesUpdate() == other.hasS3ResourcesUpdate()
                && Objects.equals(s3ResourcesUpdate(), other.s3ResourcesUpdate());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateS3ResourcesRequest").add("MemberAccountId", memberAccountId())
                .add("S3ResourcesUpdate", hasS3ResourcesUpdate() ? s3ResourcesUpdate() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "memberAccountId":
            return Optional.ofNullable(clazz.cast(memberAccountId()));
        case "s3ResourcesUpdate":
            return Optional.ofNullable(clazz.cast(s3ResourcesUpdate()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateS3ResourcesRequest, T> g) {
        return obj -> g.apply((UpdateS3ResourcesRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends MacieRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateS3ResourcesRequest> {
        /**
         * <p>
         * The AWS ID of the Amazon Macie Classic member account whose S3 resources' classification types you want to
         * update.
         * </p>
         * 
         * @param memberAccountId
         *        The AWS ID of the Amazon Macie Classic member account whose S3 resources' classification types you
         *        want to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder memberAccountId(String memberAccountId);

        /**
         * <p>
         * The S3 resources whose classification types you want to update.
         * </p>
         * 
         * @param s3ResourcesUpdate
         *        The S3 resources whose classification types you want to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3ResourcesUpdate(Collection<S3ResourceClassificationUpdate> s3ResourcesUpdate);

        /**
         * <p>
         * The S3 resources whose classification types you want to update.
         * </p>
         * 
         * @param s3ResourcesUpdate
         *        The S3 resources whose classification types you want to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3ResourcesUpdate(S3ResourceClassificationUpdate... s3ResourcesUpdate);

        /**
         * <p>
         * The S3 resources whose classification types you want to update.
         * </p>
         * This is a convenience that creates an instance of the {@link List<S3ResourceClassificationUpdate>.Builder}
         * avoiding the need to create one manually via {@link List<S3ResourceClassificationUpdate>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<S3ResourceClassificationUpdate>.Builder#build()} is called
         * immediately and its result is passed to {@link #s3ResourcesUpdate(List<S3ResourceClassificationUpdate>)}.
         * 
         * @param s3ResourcesUpdate
         *        a consumer that will call methods on {@link List<S3ResourceClassificationUpdate>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #s3ResourcesUpdate(List<S3ResourceClassificationUpdate>)
         */
        Builder s3ResourcesUpdate(Consumer<S3ResourceClassificationUpdate.Builder>... s3ResourcesUpdate);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends MacieRequest.BuilderImpl implements Builder {
        private String memberAccountId;

        private List<S3ResourceClassificationUpdate> s3ResourcesUpdate = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateS3ResourcesRequest model) {
            super(model);
            memberAccountId(model.memberAccountId);
            s3ResourcesUpdate(model.s3ResourcesUpdate);
        }

        public final String getMemberAccountId() {
            return memberAccountId;
        }

        public final void setMemberAccountId(String memberAccountId) {
            this.memberAccountId = memberAccountId;
        }

        @Override
        @Transient
        public final Builder memberAccountId(String memberAccountId) {
            this.memberAccountId = memberAccountId;
            return this;
        }

        public final List<S3ResourceClassificationUpdate.Builder> getS3ResourcesUpdate() {
            List<S3ResourceClassificationUpdate.Builder> result = S3ResourcesClassificationUpdateCopier
                    .copyToBuilder(this.s3ResourcesUpdate);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setS3ResourcesUpdate(Collection<S3ResourceClassificationUpdate.BuilderImpl> s3ResourcesUpdate) {
            this.s3ResourcesUpdate = S3ResourcesClassificationUpdateCopier.copyFromBuilder(s3ResourcesUpdate);
        }

        @Override
        @Transient
        public final Builder s3ResourcesUpdate(Collection<S3ResourceClassificationUpdate> s3ResourcesUpdate) {
            this.s3ResourcesUpdate = S3ResourcesClassificationUpdateCopier.copy(s3ResourcesUpdate);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder s3ResourcesUpdate(S3ResourceClassificationUpdate... s3ResourcesUpdate) {
            s3ResourcesUpdate(Arrays.asList(s3ResourcesUpdate));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder s3ResourcesUpdate(Consumer<S3ResourceClassificationUpdate.Builder>... s3ResourcesUpdate) {
            s3ResourcesUpdate(Stream.of(s3ResourcesUpdate)
                    .map(c -> S3ResourceClassificationUpdate.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateS3ResourcesRequest build() {
            return new UpdateS3ResourcesRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
