/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.macie.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The classification type that Amazon Macie Classic applies to the associated S3 resources.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ClassificationType implements SdkPojo, Serializable,
        ToCopyableBuilder<ClassificationType.Builder, ClassificationType> {
    private static final SdkField<String> ONE_TIME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("oneTime").getter(getter(ClassificationType::oneTimeAsString)).setter(setter(Builder::oneTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("oneTime").build()).build();

    private static final SdkField<String> CONTINUOUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("continuous").getter(getter(ClassificationType::continuousAsString)).setter(setter(Builder::continuous))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("continuous").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ONE_TIME_FIELD,
            CONTINUOUS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String oneTime;

    private final String continuous;

    private ClassificationType(BuilderImpl builder) {
        this.oneTime = builder.oneTime;
        this.continuous = builder.continuous;
    }

    /**
     * <p>
     * A one-time classification of all of the existing objects in a specified S3 bucket.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #oneTime} will
     * return {@link S3OneTimeClassificationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #oneTimeAsString}.
     * </p>
     * 
     * @return A one-time classification of all of the existing objects in a specified S3 bucket.
     * @see S3OneTimeClassificationType
     */
    public final S3OneTimeClassificationType oneTime() {
        return S3OneTimeClassificationType.fromValue(oneTime);
    }

    /**
     * <p>
     * A one-time classification of all of the existing objects in a specified S3 bucket.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #oneTime} will
     * return {@link S3OneTimeClassificationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #oneTimeAsString}.
     * </p>
     * 
     * @return A one-time classification of all of the existing objects in a specified S3 bucket.
     * @see S3OneTimeClassificationType
     */
    public final String oneTimeAsString() {
        return oneTime;
    }

    /**
     * <p>
     * A continuous classification of the objects that are added to a specified S3 bucket. Amazon Macie Classic begins
     * performing continuous classification after a bucket is successfully associated with Macie Classic.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #continuous} will
     * return {@link S3ContinuousClassificationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #continuousAsString}.
     * </p>
     * 
     * @return A continuous classification of the objects that are added to a specified S3 bucket. Amazon Macie Classic
     *         begins performing continuous classification after a bucket is successfully associated with Macie Classic.
     * @see S3ContinuousClassificationType
     */
    public final S3ContinuousClassificationType continuous() {
        return S3ContinuousClassificationType.fromValue(continuous);
    }

    /**
     * <p>
     * A continuous classification of the objects that are added to a specified S3 bucket. Amazon Macie Classic begins
     * performing continuous classification after a bucket is successfully associated with Macie Classic.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #continuous} will
     * return {@link S3ContinuousClassificationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #continuousAsString}.
     * </p>
     * 
     * @return A continuous classification of the objects that are added to a specified S3 bucket. Amazon Macie Classic
     *         begins performing continuous classification after a bucket is successfully associated with Macie Classic.
     * @see S3ContinuousClassificationType
     */
    public final String continuousAsString() {
        return continuous;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(oneTimeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(continuousAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ClassificationType)) {
            return false;
        }
        ClassificationType other = (ClassificationType) obj;
        return Objects.equals(oneTimeAsString(), other.oneTimeAsString())
                && Objects.equals(continuousAsString(), other.continuousAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ClassificationType").add("OneTime", oneTimeAsString()).add("Continuous", continuousAsString())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "oneTime":
            return Optional.ofNullable(clazz.cast(oneTimeAsString()));
        case "continuous":
            return Optional.ofNullable(clazz.cast(continuousAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ClassificationType, T> g) {
        return obj -> g.apply((ClassificationType) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ClassificationType> {
        /**
         * <p>
         * A one-time classification of all of the existing objects in a specified S3 bucket.
         * </p>
         * 
         * @param oneTime
         *        A one-time classification of all of the existing objects in a specified S3 bucket.
         * @see S3OneTimeClassificationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see S3OneTimeClassificationType
         */
        Builder oneTime(String oneTime);

        /**
         * <p>
         * A one-time classification of all of the existing objects in a specified S3 bucket.
         * </p>
         * 
         * @param oneTime
         *        A one-time classification of all of the existing objects in a specified S3 bucket.
         * @see S3OneTimeClassificationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see S3OneTimeClassificationType
         */
        Builder oneTime(S3OneTimeClassificationType oneTime);

        /**
         * <p>
         * A continuous classification of the objects that are added to a specified S3 bucket. Amazon Macie Classic
         * begins performing continuous classification after a bucket is successfully associated with Macie Classic.
         * </p>
         * 
         * @param continuous
         *        A continuous classification of the objects that are added to a specified S3 bucket. Amazon Macie
         *        Classic begins performing continuous classification after a bucket is successfully associated with
         *        Macie Classic.
         * @see S3ContinuousClassificationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see S3ContinuousClassificationType
         */
        Builder continuous(String continuous);

        /**
         * <p>
         * A continuous classification of the objects that are added to a specified S3 bucket. Amazon Macie Classic
         * begins performing continuous classification after a bucket is successfully associated with Macie Classic.
         * </p>
         * 
         * @param continuous
         *        A continuous classification of the objects that are added to a specified S3 bucket. Amazon Macie
         *        Classic begins performing continuous classification after a bucket is successfully associated with
         *        Macie Classic.
         * @see S3ContinuousClassificationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see S3ContinuousClassificationType
         */
        Builder continuous(S3ContinuousClassificationType continuous);
    }

    static final class BuilderImpl implements Builder {
        private String oneTime;

        private String continuous;

        private BuilderImpl() {
        }

        private BuilderImpl(ClassificationType model) {
            oneTime(model.oneTime);
            continuous(model.continuous);
        }

        public final String getOneTime() {
            return oneTime;
        }

        public final void setOneTime(String oneTime) {
            this.oneTime = oneTime;
        }

        @Override
        @Transient
        public final Builder oneTime(String oneTime) {
            this.oneTime = oneTime;
            return this;
        }

        @Override
        @Transient
        public final Builder oneTime(S3OneTimeClassificationType oneTime) {
            this.oneTime(oneTime == null ? null : oneTime.toString());
            return this;
        }

        public final String getContinuous() {
            return continuous;
        }

        public final void setContinuous(String continuous) {
            this.continuous = continuous;
        }

        @Override
        @Transient
        public final Builder continuous(String continuous) {
            this.continuous = continuous;
            return this;
        }

        @Override
        @Transient
        public final Builder continuous(S3ContinuousClassificationType continuous) {
            this.continuous(continuous == null ? null : continuous.toString());
            return this;
        }

        @Override
        public ClassificationType build() {
            return new ClassificationType(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
