/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.macie.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Includes details about the failed S3 resources.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class FailedS3Resource implements SdkPojo, Serializable,
        ToCopyableBuilder<FailedS3Resource.Builder, FailedS3Resource> {
    private static final SdkField<S3Resource> FAILED_ITEM_FIELD = SdkField.<S3Resource> builder(MarshallingType.SDK_POJO)
            .memberName("failedItem").getter(getter(FailedS3Resource::failedItem)).setter(setter(Builder::failedItem))
            .constructor(S3Resource::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failedItem").build()).build();

    private static final SdkField<String> ERROR_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("errorCode").getter(getter(FailedS3Resource::errorCode)).setter(setter(Builder::errorCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("errorCode").build()).build();

    private static final SdkField<String> ERROR_MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("errorMessage").getter(getter(FailedS3Resource::errorMessage)).setter(setter(Builder::errorMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("errorMessage").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FAILED_ITEM_FIELD,
            ERROR_CODE_FIELD, ERROR_MESSAGE_FIELD));

    private static final long serialVersionUID = 1L;

    private final S3Resource failedItem;

    private final String errorCode;

    private final String errorMessage;

    private FailedS3Resource(BuilderImpl builder) {
        this.failedItem = builder.failedItem;
        this.errorCode = builder.errorCode;
        this.errorMessage = builder.errorMessage;
    }

    /**
     * <p>
     * The failed S3 resources.
     * </p>
     * 
     * @return The failed S3 resources.
     */
    public final S3Resource failedItem() {
        return failedItem;
    }

    /**
     * <p>
     * The status code of a failed item.
     * </p>
     * 
     * @return The status code of a failed item.
     */
    public final String errorCode() {
        return errorCode;
    }

    /**
     * <p>
     * The error message of a failed item.
     * </p>
     * 
     * @return The error message of a failed item.
     */
    public final String errorMessage() {
        return errorMessage;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(failedItem());
        hashCode = 31 * hashCode + Objects.hashCode(errorCode());
        hashCode = 31 * hashCode + Objects.hashCode(errorMessage());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FailedS3Resource)) {
            return false;
        }
        FailedS3Resource other = (FailedS3Resource) obj;
        return Objects.equals(failedItem(), other.failedItem()) && Objects.equals(errorCode(), other.errorCode())
                && Objects.equals(errorMessage(), other.errorMessage());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("FailedS3Resource").add("FailedItem", failedItem()).add("ErrorCode", errorCode())
                .add("ErrorMessage", errorMessage()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "failedItem":
            return Optional.ofNullable(clazz.cast(failedItem()));
        case "errorCode":
            return Optional.ofNullable(clazz.cast(errorCode()));
        case "errorMessage":
            return Optional.ofNullable(clazz.cast(errorMessage()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<FailedS3Resource, T> g) {
        return obj -> g.apply((FailedS3Resource) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, FailedS3Resource> {
        /**
         * <p>
         * The failed S3 resources.
         * </p>
         * 
         * @param failedItem
         *        The failed S3 resources.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failedItem(S3Resource failedItem);

        /**
         * <p>
         * The failed S3 resources.
         * </p>
         * This is a convenience that creates an instance of the {@link S3Resource.Builder} avoiding the need to create
         * one manually via {@link S3Resource#builder()}.
         *
         * When the {@link Consumer} completes, {@link S3Resource.Builder#build()} is called immediately and its result
         * is passed to {@link #failedItem(S3Resource)}.
         * 
         * @param failedItem
         *        a consumer that will call methods on {@link S3Resource.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #failedItem(S3Resource)
         */
        default Builder failedItem(Consumer<S3Resource.Builder> failedItem) {
            return failedItem(S3Resource.builder().applyMutation(failedItem).build());
        }

        /**
         * <p>
         * The status code of a failed item.
         * </p>
         * 
         * @param errorCode
         *        The status code of a failed item.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errorCode(String errorCode);

        /**
         * <p>
         * The error message of a failed item.
         * </p>
         * 
         * @param errorMessage
         *        The error message of a failed item.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errorMessage(String errorMessage);
    }

    static final class BuilderImpl implements Builder {
        private S3Resource failedItem;

        private String errorCode;

        private String errorMessage;

        private BuilderImpl() {
        }

        private BuilderImpl(FailedS3Resource model) {
            failedItem(model.failedItem);
            errorCode(model.errorCode);
            errorMessage(model.errorMessage);
        }

        public final S3Resource.Builder getFailedItem() {
            return failedItem != null ? failedItem.toBuilder() : null;
        }

        public final void setFailedItem(S3Resource.BuilderImpl failedItem) {
            this.failedItem = failedItem != null ? failedItem.build() : null;
        }

        @Override
        @Transient
        public final Builder failedItem(S3Resource failedItem) {
            this.failedItem = failedItem;
            return this;
        }

        public final String getErrorCode() {
            return errorCode;
        }

        public final void setErrorCode(String errorCode) {
            this.errorCode = errorCode;
        }

        @Override
        @Transient
        public final Builder errorCode(String errorCode) {
            this.errorCode = errorCode;
            return this;
        }

        public final String getErrorMessage() {
            return errorMessage;
        }

        public final void setErrorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
        }

        @Override
        @Transient
        public final Builder errorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
            return this;
        }

        @Override
        public FailedS3Resource build() {
            return new FailedS3Resource(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
