/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.macie;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.macie.DefaultMacieAsyncClient;
import software.amazon.awssdk.services.macie.DefaultMacieBaseClientBuilder;
import software.amazon.awssdk.services.macie.MacieAsyncClient;
import software.amazon.awssdk.services.macie.MacieAsyncClientBuilder;
import software.amazon.awssdk.services.macie.MacieServiceClientConfiguration;
import software.amazon.awssdk.services.macie.endpoints.MacieEndpointProvider;

@SdkInternalApi
final class DefaultMacieAsyncClientBuilder
extends DefaultMacieBaseClientBuilder<MacieAsyncClientBuilder, MacieAsyncClient>
implements MacieAsyncClientBuilder {
    DefaultMacieAsyncClientBuilder() {
    }

    @Override
    public DefaultMacieAsyncClientBuilder endpointProvider(MacieEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final MacieAsyncClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.asyncClientConfiguration();
        DefaultMacieAsyncClientBuilder.validateClientOptions(clientConfiguration);
        URI endpointOverride = null;
        if (clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) != null && Boolean.TRUE.equals(clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        MacieServiceClientConfiguration serviceClientConfiguration = MacieServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfiguration.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).build();
        return new DefaultMacieAsyncClient(serviceClientConfiguration, clientConfiguration);
    }
}

