/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.macie.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The S3 resources that you want to associate with Amazon Macie for monitoring and data classification. This data type
 * is used as a request parameter in the AssociateS3Resources action and a response parameter in the ListS3Resources
 * action.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class S3ResourceClassification implements SdkPojo, Serializable,
        ToCopyableBuilder<S3ResourceClassification.Builder, S3ResourceClassification> {
    private static final SdkField<String> BUCKET_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(S3ResourceClassification::bucketName)).setter(setter(Builder::bucketName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("bucketName").build()).build();

    private static final SdkField<String> PREFIX_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(S3ResourceClassification::prefix)).setter(setter(Builder::prefix))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("prefix").build()).build();

    private static final SdkField<ClassificationType> CLASSIFICATION_TYPE_FIELD = SdkField
            .<ClassificationType> builder(MarshallingType.SDK_POJO).getter(getter(S3ResourceClassification::classificationType))
            .setter(setter(Builder::classificationType)).constructor(ClassificationType::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("classificationType").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BUCKET_NAME_FIELD,
            PREFIX_FIELD, CLASSIFICATION_TYPE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String bucketName;

    private final String prefix;

    private final ClassificationType classificationType;

    private S3ResourceClassification(BuilderImpl builder) {
        this.bucketName = builder.bucketName;
        this.prefix = builder.prefix;
        this.classificationType = builder.classificationType;
    }

    /**
     * <p>
     * The name of the S3 bucket that you want to associate with Amazon Macie.
     * </p>
     * 
     * @return The name of the S3 bucket that you want to associate with Amazon Macie.
     */
    public String bucketName() {
        return bucketName;
    }

    /**
     * <p>
     * The prefix of the S3 bucket that you want to associate with Amazon Macie.
     * </p>
     * 
     * @return The prefix of the S3 bucket that you want to associate with Amazon Macie.
     */
    public String prefix() {
        return prefix;
    }

    /**
     * <p>
     * The classification type that you want to specify for the resource associated with Amazon Macie.
     * </p>
     * 
     * @return The classification type that you want to specify for the resource associated with Amazon Macie.
     */
    public ClassificationType classificationType() {
        return classificationType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(bucketName());
        hashCode = 31 * hashCode + Objects.hashCode(prefix());
        hashCode = 31 * hashCode + Objects.hashCode(classificationType());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof S3ResourceClassification)) {
            return false;
        }
        S3ResourceClassification other = (S3ResourceClassification) obj;
        return Objects.equals(bucketName(), other.bucketName()) && Objects.equals(prefix(), other.prefix())
                && Objects.equals(classificationType(), other.classificationType());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("S3ResourceClassification").add("BucketName", bucketName()).add("Prefix", prefix())
                .add("ClassificationType", classificationType()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "bucketName":
            return Optional.ofNullable(clazz.cast(bucketName()));
        case "prefix":
            return Optional.ofNullable(clazz.cast(prefix()));
        case "classificationType":
            return Optional.ofNullable(clazz.cast(classificationType()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<S3ResourceClassification, T> g) {
        return obj -> g.apply((S3ResourceClassification) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, S3ResourceClassification> {
        /**
         * <p>
         * The name of the S3 bucket that you want to associate with Amazon Macie.
         * </p>
         * 
         * @param bucketName
         *        The name of the S3 bucket that you want to associate with Amazon Macie.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bucketName(String bucketName);

        /**
         * <p>
         * The prefix of the S3 bucket that you want to associate with Amazon Macie.
         * </p>
         * 
         * @param prefix
         *        The prefix of the S3 bucket that you want to associate with Amazon Macie.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder prefix(String prefix);

        /**
         * <p>
         * The classification type that you want to specify for the resource associated with Amazon Macie.
         * </p>
         * 
         * @param classificationType
         *        The classification type that you want to specify for the resource associated with Amazon Macie.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder classificationType(ClassificationType classificationType);

        /**
         * <p>
         * The classification type that you want to specify for the resource associated with Amazon Macie.
         * </p>
         * This is a convenience that creates an instance of the {@link ClassificationType.Builder} avoiding the need to
         * create one manually via {@link ClassificationType#builder()}.
         *
         * When the {@link Consumer} completes, {@link ClassificationType.Builder#build()} is called immediately and its
         * result is passed to {@link #classificationType(ClassificationType)}.
         * 
         * @param classificationType
         *        a consumer that will call methods on {@link ClassificationType.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #classificationType(ClassificationType)
         */
        default Builder classificationType(Consumer<ClassificationType.Builder> classificationType) {
            return classificationType(ClassificationType.builder().applyMutation(classificationType).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String bucketName;

        private String prefix;

        private ClassificationType classificationType;

        private BuilderImpl() {
        }

        private BuilderImpl(S3ResourceClassification model) {
            bucketName(model.bucketName);
            prefix(model.prefix);
            classificationType(model.classificationType);
        }

        public final String getBucketName() {
            return bucketName;
        }

        @Override
        public final Builder bucketName(String bucketName) {
            this.bucketName = bucketName;
            return this;
        }

        public final void setBucketName(String bucketName) {
            this.bucketName = bucketName;
        }

        public final String getPrefix() {
            return prefix;
        }

        @Override
        public final Builder prefix(String prefix) {
            this.prefix = prefix;
            return this;
        }

        public final void setPrefix(String prefix) {
            this.prefix = prefix;
        }

        public final ClassificationType.Builder getClassificationType() {
            return classificationType != null ? classificationType.toBuilder() : null;
        }

        @Override
        public final Builder classificationType(ClassificationType classificationType) {
            this.classificationType = classificationType;
            return this;
        }

        public final void setClassificationType(ClassificationType.BuilderImpl classificationType) {
            this.classificationType = classificationType != null ? classificationType.build() : null;
        }

        @Override
        public S3ResourceClassification build() {
            return new S3ResourceClassification(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
