/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.macie.model;

import static java.util.stream.Collectors.toList;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;

@Generated("software.amazon.awssdk:codegen")
final class S3ResourcesClassificationUpdateCopier {
    static List<S3ResourceClassificationUpdate> copy(
            Collection<S3ResourceClassificationUpdate> s3ResourcesClassificationUpdateParam) {
        if (s3ResourcesClassificationUpdateParam == null || s3ResourcesClassificationUpdateParam instanceof SdkAutoConstructList) {
            return DefaultSdkAutoConstructList.getInstance();
        }
        List<S3ResourceClassificationUpdate> s3ResourcesClassificationUpdateParamCopy = new ArrayList<>(
                s3ResourcesClassificationUpdateParam);
        return Collections.unmodifiableList(s3ResourcesClassificationUpdateParamCopy);
    }

    static List<S3ResourceClassificationUpdate> copyFromBuilder(
            Collection<? extends S3ResourceClassificationUpdate.Builder> s3ResourcesClassificationUpdateParam) {
        if (s3ResourcesClassificationUpdateParam == null) {
            return null;
        }
        return copy(s3ResourcesClassificationUpdateParam.stream().map(S3ResourceClassificationUpdate.Builder::build)
                .collect(toList()));
    }
}
