/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.macie2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies where to store data classification results, and the encryption settings to use when storing results in that
 * location. Currently, you can store classification results only in an S3 bucket.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ClassificationExportConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<ClassificationExportConfiguration.Builder, ClassificationExportConfiguration> {
    private static final SdkField<S3Destination> S3_DESTINATION_FIELD = SdkField
            .<S3Destination> builder(MarshallingType.SDK_POJO).getter(getter(ClassificationExportConfiguration::s3Destination))
            .setter(setter(Builder::s3Destination)).constructor(S3Destination::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("s3Destination").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(S3_DESTINATION_FIELD));

    private static final long serialVersionUID = 1L;

    private final S3Destination s3Destination;

    private ClassificationExportConfiguration(BuilderImpl builder) {
        this.s3Destination = builder.s3Destination;
    }

    /**
     * <p>
     * The S3 bucket to store data classification results in, and the encryption settings to use when storing results in
     * that bucket.
     * </p>
     * 
     * @return The S3 bucket to store data classification results in, and the encryption settings to use when storing
     *         results in that bucket.
     */
    public S3Destination s3Destination() {
        return s3Destination;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(s3Destination());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ClassificationExportConfiguration)) {
            return false;
        }
        ClassificationExportConfiguration other = (ClassificationExportConfiguration) obj;
        return Objects.equals(s3Destination(), other.s3Destination());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ClassificationExportConfiguration").add("S3Destination", s3Destination()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "s3Destination":
            return Optional.ofNullable(clazz.cast(s3Destination()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ClassificationExportConfiguration, T> g) {
        return obj -> g.apply((ClassificationExportConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ClassificationExportConfiguration> {
        /**
         * <p>
         * The S3 bucket to store data classification results in, and the encryption settings to use when storing
         * results in that bucket.
         * </p>
         * 
         * @param s3Destination
         *        The S3 bucket to store data classification results in, and the encryption settings to use when storing
         *        results in that bucket.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3Destination(S3Destination s3Destination);

        /**
         * <p>
         * The S3 bucket to store data classification results in, and the encryption settings to use when storing
         * results in that bucket.
         * </p>
         * This is a convenience that creates an instance of the {@link S3Destination.Builder} avoiding the need to
         * create one manually via {@link S3Destination#builder()}.
         *
         * When the {@link Consumer} completes, {@link S3Destination.Builder#build()} is called immediately and its
         * result is passed to {@link #s3Destination(S3Destination)}.
         * 
         * @param s3Destination
         *        a consumer that will call methods on {@link S3Destination.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #s3Destination(S3Destination)
         */
        default Builder s3Destination(Consumer<S3Destination.Builder> s3Destination) {
            return s3Destination(S3Destination.builder().applyMutation(s3Destination).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private S3Destination s3Destination;

        private BuilderImpl() {
        }

        private BuilderImpl(ClassificationExportConfiguration model) {
            s3Destination(model.s3Destination);
        }

        public final S3Destination.Builder getS3Destination() {
            return s3Destination != null ? s3Destination.toBuilder() : null;
        }

        @Override
        public final Builder s3Destination(S3Destination s3Destination) {
            this.s3Destination = s3Destination;
            return this;
        }

        public final void setS3Destination(S3Destination.BuilderImpl s3Destination) {
            this.s3Destination = s3Destination != null ? s3Destination.build() : null;
        }

        @Override
        public ClassificationExportConfiguration build() {
            return new ClassificationExportConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
