/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.macie2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.CollectionUtils;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeBucketsRequest extends Macie2Request implements
        ToCopyableBuilder<DescribeBucketsRequest.Builder, DescribeBucketsRequest> {
    private static final SdkField<Map<String, BucketCriteriaAdditionalProperties>> CRITERIA_FIELD = SdkField
            .<Map<String, BucketCriteriaAdditionalProperties>> builder(MarshallingType.MAP)
            .getter(getter(DescribeBucketsRequest::criteria))
            .setter(setter(Builder::criteria))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("criteria").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<BucketCriteriaAdditionalProperties> builder(MarshallingType.SDK_POJO)
                                            .constructor(BucketCriteriaAdditionalProperties::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(DescribeBucketsRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxResults").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeBucketsRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final SdkField<BucketSortCriteria> SORT_CRITERIA_FIELD = SdkField
            .<BucketSortCriteria> builder(MarshallingType.SDK_POJO).getter(getter(DescribeBucketsRequest::sortCriteria))
            .setter(setter(Builder::sortCriteria)).constructor(BucketSortCriteria::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sortCriteria").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CRITERIA_FIELD,
            MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD, SORT_CRITERIA_FIELD));

    private final Map<String, BucketCriteriaAdditionalProperties> criteria;

    private final Integer maxResults;

    private final String nextToken;

    private final BucketSortCriteria sortCriteria;

    private DescribeBucketsRequest(BuilderImpl builder) {
        super(builder);
        this.criteria = builder.criteria;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
        this.sortCriteria = builder.sortCriteria;
    }

    /**
     * Returns true if the Criteria property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasCriteria() {
        return criteria != null && !(criteria instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The criteria to use to filter the query results.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasCriteria()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The criteria to use to filter the query results.
     */
    public Map<String, BucketCriteriaAdditionalProperties> criteria() {
        return criteria;
    }

    /**
     * <p>
     * The maximum number of items to include in each page of the response. The default value is 50.
     * </p>
     * 
     * @return The maximum number of items to include in each page of the response. The default value is 50.
     */
    public Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * The nextToken string that specifies which page of results to return in a paginated response.
     * </p>
     * 
     * @return The nextToken string that specifies which page of results to return in a paginated response.
     */
    public String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The criteria to use to sort the query results.
     * </p>
     * 
     * @return The criteria to use to sort the query results.
     */
    public BucketSortCriteria sortCriteria() {
        return sortCriteria;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(criteria());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(sortCriteria());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeBucketsRequest)) {
            return false;
        }
        DescribeBucketsRequest other = (DescribeBucketsRequest) obj;
        return Objects.equals(criteria(), other.criteria()) && Objects.equals(maxResults(), other.maxResults())
                && Objects.equals(nextToken(), other.nextToken()) && Objects.equals(sortCriteria(), other.sortCriteria());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DescribeBucketsRequest").add("Criteria", criteria()).add("MaxResults", maxResults())
                .add("NextToken", nextToken()).add("SortCriteria", sortCriteria()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "criteria":
            return Optional.ofNullable(clazz.cast(criteria()));
        case "maxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "sortCriteria":
            return Optional.ofNullable(clazz.cast(sortCriteria()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeBucketsRequest, T> g) {
        return obj -> g.apply((DescribeBucketsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Macie2Request.Builder, SdkPojo, CopyableBuilder<Builder, DescribeBucketsRequest> {
        /**
         * <p>
         * The criteria to use to filter the query results.
         * </p>
         * 
         * @param criteria
         *        The criteria to use to filter the query results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder criteria(Map<String, BucketCriteriaAdditionalProperties> criteria);

        /**
         * <p>
         * The maximum number of items to include in each page of the response. The default value is 50.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of items to include in each page of the response. The default value is 50.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * The nextToken string that specifies which page of results to return in a paginated response.
         * </p>
         * 
         * @param nextToken
         *        The nextToken string that specifies which page of results to return in a paginated response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The criteria to use to sort the query results.
         * </p>
         * 
         * @param sortCriteria
         *        The criteria to use to sort the query results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sortCriteria(BucketSortCriteria sortCriteria);

        /**
         * <p>
         * The criteria to use to sort the query results.
         * </p>
         * This is a convenience that creates an instance of the {@link BucketSortCriteria.Builder} avoiding the need to
         * create one manually via {@link BucketSortCriteria#builder()}.
         *
         * When the {@link Consumer} completes, {@link BucketSortCriteria.Builder#build()} is called immediately and its
         * result is passed to {@link #sortCriteria(BucketSortCriteria)}.
         * 
         * @param sortCriteria
         *        a consumer that will call methods on {@link BucketSortCriteria.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sortCriteria(BucketSortCriteria)
         */
        default Builder sortCriteria(Consumer<BucketSortCriteria.Builder> sortCriteria) {
            return sortCriteria(BucketSortCriteria.builder().applyMutation(sortCriteria).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Macie2Request.BuilderImpl implements Builder {
        private Map<String, BucketCriteriaAdditionalProperties> criteria = DefaultSdkAutoConstructMap.getInstance();

        private Integer maxResults;

        private String nextToken;

        private BucketSortCriteria sortCriteria;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeBucketsRequest model) {
            super(model);
            criteria(model.criteria);
            maxResults(model.maxResults);
            nextToken(model.nextToken);
            sortCriteria(model.sortCriteria);
        }

        public final Map<String, BucketCriteriaAdditionalProperties.Builder> getCriteria() {
            return criteria != null ? CollectionUtils.mapValues(criteria, BucketCriteriaAdditionalProperties::toBuilder) : null;
        }

        @Override
        public final Builder criteria(Map<String, BucketCriteriaAdditionalProperties> criteria) {
            this.criteria = BucketCriteriaCopier.copy(criteria);
            return this;
        }

        public final void setCriteria(Map<String, BucketCriteriaAdditionalProperties.BuilderImpl> criteria) {
            this.criteria = BucketCriteriaCopier.copyFromBuilder(criteria);
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final BucketSortCriteria.Builder getSortCriteria() {
            return sortCriteria != null ? sortCriteria.toBuilder() : null;
        }

        @Override
        public final Builder sortCriteria(BucketSortCriteria sortCriteria) {
            this.sortCriteria = sortCriteria;
            return this;
        }

        public final void setSortCriteria(BucketSortCriteria.BuilderImpl sortCriteria) {
            this.sortCriteria = sortCriteria != null ? sortCriteria.build() : null;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeBucketsRequest build() {
            return new DescribeBucketsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
