/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.macie2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides information about a findings filter.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class FindingsFilterListItem implements SdkPojo, Serializable,
        ToCopyableBuilder<FindingsFilterListItem.Builder, FindingsFilterListItem> {
    private static final SdkField<String> ACTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(FindingsFilterListItem::actionAsString)).setter(setter(Builder::action))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("action").build()).build();

    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(FindingsFilterListItem::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()).build();

    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(FindingsFilterListItem::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(FindingsFilterListItem::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .getter(getter(FindingsFilterListItem::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTION_FIELD, ARN_FIELD,
            ID_FIELD, NAME_FIELD, TAGS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String action;

    private final String arn;

    private final String id;

    private final String name;

    private final Map<String, String> tags;

    private FindingsFilterListItem(BuilderImpl builder) {
        this.action = builder.action;
        this.arn = builder.arn;
        this.id = builder.id;
        this.name = builder.name;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The action that's performed on findings that meet the filter criteria. Possible values are: ARCHIVE, suppress
     * (automatically archive) the findings; and, NOOP, don't perform any action on the findings.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #action} will
     * return {@link FindingsFilterAction#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #actionAsString}.
     * </p>
     * 
     * @return The action that's performed on findings that meet the filter criteria. Possible values are: ARCHIVE,
     *         suppress (automatically archive) the findings; and, NOOP, don't perform any action on the findings.
     * @see FindingsFilterAction
     */
    public FindingsFilterAction action() {
        return FindingsFilterAction.fromValue(action);
    }

    /**
     * <p>
     * The action that's performed on findings that meet the filter criteria. Possible values are: ARCHIVE, suppress
     * (automatically archive) the findings; and, NOOP, don't perform any action on the findings.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #action} will
     * return {@link FindingsFilterAction#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #actionAsString}.
     * </p>
     * 
     * @return The action that's performed on findings that meet the filter criteria. Possible values are: ARCHIVE,
     *         suppress (automatically archive) the findings; and, NOOP, don't perform any action on the findings.
     * @see FindingsFilterAction
     */
    public String actionAsString() {
        return action;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the filter.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the filter.
     */
    public String arn() {
        return arn;
    }

    /**
     * <p>
     * The unique identifier for the filter.
     * </p>
     * 
     * @return The unique identifier for the filter.
     */
    public String id() {
        return id;
    }

    /**
     * <p>
     * The custom name of the filter.
     * </p>
     * 
     * @return The custom name of the filter.
     */
    public String name() {
        return name;
    }

    /**
     * Returns true if the Tags property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * A map of key-value pairs that identifies the tags (keys and values) that are associated with the filter.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTags()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A map of key-value pairs that identifies the tags (keys and values) that are associated with the filter.
     */
    public Map<String, String> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(actionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(tags());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FindingsFilterListItem)) {
            return false;
        }
        FindingsFilterListItem other = (FindingsFilterListItem) obj;
        return Objects.equals(actionAsString(), other.actionAsString()) && Objects.equals(arn(), other.arn())
                && Objects.equals(id(), other.id()) && Objects.equals(name(), other.name())
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("FindingsFilterListItem").add("Action", actionAsString()).add("Arn", arn()).add("Id", id())
                .add("Name", name()).add("Tags", tags()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "action":
            return Optional.ofNullable(clazz.cast(actionAsString()));
        case "arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "id":
            return Optional.ofNullable(clazz.cast(id()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<FindingsFilterListItem, T> g) {
        return obj -> g.apply((FindingsFilterListItem) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, FindingsFilterListItem> {
        /**
         * <p>
         * The action that's performed on findings that meet the filter criteria. Possible values are: ARCHIVE, suppress
         * (automatically archive) the findings; and, NOOP, don't perform any action on the findings.
         * </p>
         * 
         * @param action
         *        The action that's performed on findings that meet the filter criteria. Possible values are: ARCHIVE,
         *        suppress (automatically archive) the findings; and, NOOP, don't perform any action on the findings.
         * @see FindingsFilterAction
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FindingsFilterAction
         */
        Builder action(String action);

        /**
         * <p>
         * The action that's performed on findings that meet the filter criteria. Possible values are: ARCHIVE, suppress
         * (automatically archive) the findings; and, NOOP, don't perform any action on the findings.
         * </p>
         * 
         * @param action
         *        The action that's performed on findings that meet the filter criteria. Possible values are: ARCHIVE,
         *        suppress (automatically archive) the findings; and, NOOP, don't perform any action on the findings.
         * @see FindingsFilterAction
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FindingsFilterAction
         */
        Builder action(FindingsFilterAction action);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the filter.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) of the filter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The unique identifier for the filter.
         * </p>
         * 
         * @param id
         *        The unique identifier for the filter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The custom name of the filter.
         * </p>
         * 
         * @param name
         *        The custom name of the filter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * A map of key-value pairs that identifies the tags (keys and values) that are associated with the filter.
         * </p>
         * 
         * @param tags
         *        A map of key-value pairs that identifies the tags (keys and values) that are associated with the
         *        filter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);
    }

    static final class BuilderImpl implements Builder {
        private String action;

        private String arn;

        private String id;

        private String name;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(FindingsFilterListItem model) {
            action(model.action);
            arn(model.arn);
            id(model.id);
            name(model.name);
            tags(model.tags);
        }

        public final String getAction() {
            return action;
        }

        @Override
        public final Builder action(String action) {
            this.action = action;
            return this;
        }

        @Override
        public final Builder action(FindingsFilterAction action) {
            this.action(action == null ? null : action.toString());
            return this;
        }

        public final void setAction(String action) {
            this.action = action;
        }

        public final String getArn() {
            return arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final String getId() {
            return id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final Map<String, String> getTags() {
            return tags;
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public FindingsFilterListItem build() {
            return new FindingsFilterListItem(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
