/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.macie2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides information about the IP address of the device that an entity used to perform an action on an affected
 * resource.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class IpAddressDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<IpAddressDetails.Builder, IpAddressDetails> {
    private static final SdkField<String> IP_ADDRESS_V4_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(IpAddressDetails::ipAddressV4)).setter(setter(Builder::ipAddressV4))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ipAddressV4").build()).build();

    private static final SdkField<IpCity> IP_CITY_FIELD = SdkField.<IpCity> builder(MarshallingType.SDK_POJO)
            .getter(getter(IpAddressDetails::ipCity)).setter(setter(Builder::ipCity)).constructor(IpCity::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ipCity").build()).build();

    private static final SdkField<IpCountry> IP_COUNTRY_FIELD = SdkField.<IpCountry> builder(MarshallingType.SDK_POJO)
            .getter(getter(IpAddressDetails::ipCountry)).setter(setter(Builder::ipCountry)).constructor(IpCountry::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ipCountry").build()).build();

    private static final SdkField<IpGeoLocation> IP_GEO_LOCATION_FIELD = SdkField
            .<IpGeoLocation> builder(MarshallingType.SDK_POJO).getter(getter(IpAddressDetails::ipGeoLocation))
            .setter(setter(Builder::ipGeoLocation)).constructor(IpGeoLocation::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ipGeoLocation").build()).build();

    private static final SdkField<IpOwner> IP_OWNER_FIELD = SdkField.<IpOwner> builder(MarshallingType.SDK_POJO)
            .getter(getter(IpAddressDetails::ipOwner)).setter(setter(Builder::ipOwner)).constructor(IpOwner::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ipOwner").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IP_ADDRESS_V4_FIELD,
            IP_CITY_FIELD, IP_COUNTRY_FIELD, IP_GEO_LOCATION_FIELD, IP_OWNER_FIELD));

    private static final long serialVersionUID = 1L;

    private final String ipAddressV4;

    private final IpCity ipCity;

    private final IpCountry ipCountry;

    private final IpGeoLocation ipGeoLocation;

    private final IpOwner ipOwner;

    private IpAddressDetails(BuilderImpl builder) {
        this.ipAddressV4 = builder.ipAddressV4;
        this.ipCity = builder.ipCity;
        this.ipCountry = builder.ipCountry;
        this.ipGeoLocation = builder.ipGeoLocation;
        this.ipOwner = builder.ipOwner;
    }

    /**
     * <p>
     * The Internet Protocol version 4 (IPv4) address of the device.
     * </p>
     * 
     * @return The Internet Protocol version 4 (IPv4) address of the device.
     */
    public String ipAddressV4() {
        return ipAddressV4;
    }

    /**
     * <p>
     * The city that the IP address originated from.
     * </p>
     * 
     * @return The city that the IP address originated from.
     */
    public IpCity ipCity() {
        return ipCity;
    }

    /**
     * <p>
     * The country that the IP address originated from.
     * </p>
     * 
     * @return The country that the IP address originated from.
     */
    public IpCountry ipCountry() {
        return ipCountry;
    }

    /**
     * <p>
     * The geographic coordinates of the location that the IP address originated from.
     * </p>
     * 
     * @return The geographic coordinates of the location that the IP address originated from.
     */
    public IpGeoLocation ipGeoLocation() {
        return ipGeoLocation;
    }

    /**
     * <p>
     * The registered owner of the IP address.
     * </p>
     * 
     * @return The registered owner of the IP address.
     */
    public IpOwner ipOwner() {
        return ipOwner;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(ipAddressV4());
        hashCode = 31 * hashCode + Objects.hashCode(ipCity());
        hashCode = 31 * hashCode + Objects.hashCode(ipCountry());
        hashCode = 31 * hashCode + Objects.hashCode(ipGeoLocation());
        hashCode = 31 * hashCode + Objects.hashCode(ipOwner());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IpAddressDetails)) {
            return false;
        }
        IpAddressDetails other = (IpAddressDetails) obj;
        return Objects.equals(ipAddressV4(), other.ipAddressV4()) && Objects.equals(ipCity(), other.ipCity())
                && Objects.equals(ipCountry(), other.ipCountry()) && Objects.equals(ipGeoLocation(), other.ipGeoLocation())
                && Objects.equals(ipOwner(), other.ipOwner());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("IpAddressDetails").add("IpAddressV4", ipAddressV4()).add("IpCity", ipCity())
                .add("IpCountry", ipCountry()).add("IpGeoLocation", ipGeoLocation()).add("IpOwner", ipOwner()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ipAddressV4":
            return Optional.ofNullable(clazz.cast(ipAddressV4()));
        case "ipCity":
            return Optional.ofNullable(clazz.cast(ipCity()));
        case "ipCountry":
            return Optional.ofNullable(clazz.cast(ipCountry()));
        case "ipGeoLocation":
            return Optional.ofNullable(clazz.cast(ipGeoLocation()));
        case "ipOwner":
            return Optional.ofNullable(clazz.cast(ipOwner()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<IpAddressDetails, T> g) {
        return obj -> g.apply((IpAddressDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, IpAddressDetails> {
        /**
         * <p>
         * The Internet Protocol version 4 (IPv4) address of the device.
         * </p>
         * 
         * @param ipAddressV4
         *        The Internet Protocol version 4 (IPv4) address of the device.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipAddressV4(String ipAddressV4);

        /**
         * <p>
         * The city that the IP address originated from.
         * </p>
         * 
         * @param ipCity
         *        The city that the IP address originated from.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipCity(IpCity ipCity);

        /**
         * <p>
         * The city that the IP address originated from.
         * </p>
         * This is a convenience that creates an instance of the {@link IpCity.Builder} avoiding the need to create one
         * manually via {@link IpCity#builder()}.
         *
         * When the {@link Consumer} completes, {@link IpCity.Builder#build()} is called immediately and its result is
         * passed to {@link #ipCity(IpCity)}.
         * 
         * @param ipCity
         *        a consumer that will call methods on {@link IpCity.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ipCity(IpCity)
         */
        default Builder ipCity(Consumer<IpCity.Builder> ipCity) {
            return ipCity(IpCity.builder().applyMutation(ipCity).build());
        }

        /**
         * <p>
         * The country that the IP address originated from.
         * </p>
         * 
         * @param ipCountry
         *        The country that the IP address originated from.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipCountry(IpCountry ipCountry);

        /**
         * <p>
         * The country that the IP address originated from.
         * </p>
         * This is a convenience that creates an instance of the {@link IpCountry.Builder} avoiding the need to create
         * one manually via {@link IpCountry#builder()}.
         *
         * When the {@link Consumer} completes, {@link IpCountry.Builder#build()} is called immediately and its result
         * is passed to {@link #ipCountry(IpCountry)}.
         * 
         * @param ipCountry
         *        a consumer that will call methods on {@link IpCountry.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ipCountry(IpCountry)
         */
        default Builder ipCountry(Consumer<IpCountry.Builder> ipCountry) {
            return ipCountry(IpCountry.builder().applyMutation(ipCountry).build());
        }

        /**
         * <p>
         * The geographic coordinates of the location that the IP address originated from.
         * </p>
         * 
         * @param ipGeoLocation
         *        The geographic coordinates of the location that the IP address originated from.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipGeoLocation(IpGeoLocation ipGeoLocation);

        /**
         * <p>
         * The geographic coordinates of the location that the IP address originated from.
         * </p>
         * This is a convenience that creates an instance of the {@link IpGeoLocation.Builder} avoiding the need to
         * create one manually via {@link IpGeoLocation#builder()}.
         *
         * When the {@link Consumer} completes, {@link IpGeoLocation.Builder#build()} is called immediately and its
         * result is passed to {@link #ipGeoLocation(IpGeoLocation)}.
         * 
         * @param ipGeoLocation
         *        a consumer that will call methods on {@link IpGeoLocation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ipGeoLocation(IpGeoLocation)
         */
        default Builder ipGeoLocation(Consumer<IpGeoLocation.Builder> ipGeoLocation) {
            return ipGeoLocation(IpGeoLocation.builder().applyMutation(ipGeoLocation).build());
        }

        /**
         * <p>
         * The registered owner of the IP address.
         * </p>
         * 
         * @param ipOwner
         *        The registered owner of the IP address.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipOwner(IpOwner ipOwner);

        /**
         * <p>
         * The registered owner of the IP address.
         * </p>
         * This is a convenience that creates an instance of the {@link IpOwner.Builder} avoiding the need to create one
         * manually via {@link IpOwner#builder()}.
         *
         * When the {@link Consumer} completes, {@link IpOwner.Builder#build()} is called immediately and its result is
         * passed to {@link #ipOwner(IpOwner)}.
         * 
         * @param ipOwner
         *        a consumer that will call methods on {@link IpOwner.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ipOwner(IpOwner)
         */
        default Builder ipOwner(Consumer<IpOwner.Builder> ipOwner) {
            return ipOwner(IpOwner.builder().applyMutation(ipOwner).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String ipAddressV4;

        private IpCity ipCity;

        private IpCountry ipCountry;

        private IpGeoLocation ipGeoLocation;

        private IpOwner ipOwner;

        private BuilderImpl() {
        }

        private BuilderImpl(IpAddressDetails model) {
            ipAddressV4(model.ipAddressV4);
            ipCity(model.ipCity);
            ipCountry(model.ipCountry);
            ipGeoLocation(model.ipGeoLocation);
            ipOwner(model.ipOwner);
        }

        public final String getIpAddressV4() {
            return ipAddressV4;
        }

        @Override
        public final Builder ipAddressV4(String ipAddressV4) {
            this.ipAddressV4 = ipAddressV4;
            return this;
        }

        public final void setIpAddressV4(String ipAddressV4) {
            this.ipAddressV4 = ipAddressV4;
        }

        public final IpCity.Builder getIpCity() {
            return ipCity != null ? ipCity.toBuilder() : null;
        }

        @Override
        public final Builder ipCity(IpCity ipCity) {
            this.ipCity = ipCity;
            return this;
        }

        public final void setIpCity(IpCity.BuilderImpl ipCity) {
            this.ipCity = ipCity != null ? ipCity.build() : null;
        }

        public final IpCountry.Builder getIpCountry() {
            return ipCountry != null ? ipCountry.toBuilder() : null;
        }

        @Override
        public final Builder ipCountry(IpCountry ipCountry) {
            this.ipCountry = ipCountry;
            return this;
        }

        public final void setIpCountry(IpCountry.BuilderImpl ipCountry) {
            this.ipCountry = ipCountry != null ? ipCountry.build() : null;
        }

        public final IpGeoLocation.Builder getIpGeoLocation() {
            return ipGeoLocation != null ? ipGeoLocation.toBuilder() : null;
        }

        @Override
        public final Builder ipGeoLocation(IpGeoLocation ipGeoLocation) {
            this.ipGeoLocation = ipGeoLocation;
            return this;
        }

        public final void setIpGeoLocation(IpGeoLocation.BuilderImpl ipGeoLocation) {
            this.ipGeoLocation = ipGeoLocation != null ? ipGeoLocation.build() : null;
        }

        public final IpOwner.Builder getIpOwner() {
            return ipOwner != null ? ipOwner.toBuilder() : null;
        }

        @Override
        public final Builder ipOwner(IpOwner ipOwner) {
            this.ipOwner = ipOwner;
            return this;
        }

        public final void setIpOwner(IpOwner.BuilderImpl ipOwner) {
            this.ipOwner = ipOwner != null ? ipOwner.build() : null;
        }

        @Override
        public IpAddressDetails build() {
            return new IpAddressDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
