/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.macie2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListFindingsFiltersResponse extends Macie2Response implements
        ToCopyableBuilder<ListFindingsFiltersResponse.Builder, ListFindingsFiltersResponse> {
    private static final SdkField<List<FindingsFilterListItem>> FINDINGS_FILTER_LIST_ITEMS_FIELD = SdkField
            .<List<FindingsFilterListItem>> builder(MarshallingType.LIST)
            .getter(getter(ListFindingsFiltersResponse::findingsFilterListItems))
            .setter(setter(Builder::findingsFilterListItems))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("findingsFilterListItems").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<FindingsFilterListItem> builder(MarshallingType.SDK_POJO)
                                            .constructor(FindingsFilterListItem::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListFindingsFiltersResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            FINDINGS_FILTER_LIST_ITEMS_FIELD, NEXT_TOKEN_FIELD));

    private final List<FindingsFilterListItem> findingsFilterListItems;

    private final String nextToken;

    private ListFindingsFiltersResponse(BuilderImpl builder) {
        super(builder);
        this.findingsFilterListItems = builder.findingsFilterListItems;
        this.nextToken = builder.nextToken;
    }

    /**
     * Returns true if the FindingsFilterListItems property was specified by the sender (it may be empty), or false if
     * the sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasFindingsFilterListItems() {
        return findingsFilterListItems != null && !(findingsFilterListItems instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of objects, one for each filter that's associated with the account.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasFindingsFilterListItems()} to see if a value was sent in this field.
     * </p>
     * 
     * @return An array of objects, one for each filter that's associated with the account.
     */
    public List<FindingsFilterListItem> findingsFilterListItems() {
        return findingsFilterListItems;
    }

    /**
     * <p>
     * The string to use in a subsequent request to get the next page of results in a paginated response. This value is
     * null if there are no additional pages.
     * </p>
     * 
     * @return The string to use in a subsequent request to get the next page of results in a paginated response. This
     *         value is null if there are no additional pages.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(findingsFilterListItems());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListFindingsFiltersResponse)) {
            return false;
        }
        ListFindingsFiltersResponse other = (ListFindingsFiltersResponse) obj;
        return Objects.equals(findingsFilterListItems(), other.findingsFilterListItems())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ListFindingsFiltersResponse").add("FindingsFilterListItems", findingsFilterListItems())
                .add("NextToken", nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "findingsFilterListItems":
            return Optional.ofNullable(clazz.cast(findingsFilterListItems()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListFindingsFiltersResponse, T> g) {
        return obj -> g.apply((ListFindingsFiltersResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Macie2Response.Builder, SdkPojo, CopyableBuilder<Builder, ListFindingsFiltersResponse> {
        /**
         * <p>
         * An array of objects, one for each filter that's associated with the account.
         * </p>
         * 
         * @param findingsFilterListItems
         *        An array of objects, one for each filter that's associated with the account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder findingsFilterListItems(Collection<FindingsFilterListItem> findingsFilterListItems);

        /**
         * <p>
         * An array of objects, one for each filter that's associated with the account.
         * </p>
         * 
         * @param findingsFilterListItems
         *        An array of objects, one for each filter that's associated with the account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder findingsFilterListItems(FindingsFilterListItem... findingsFilterListItems);

        /**
         * <p>
         * An array of objects, one for each filter that's associated with the account.
         * </p>
         * This is a convenience that creates an instance of the {@link List<FindingsFilterListItem>.Builder} avoiding
         * the need to create one manually via {@link List<FindingsFilterListItem>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<FindingsFilterListItem>.Builder#build()} is called
         * immediately and its result is passed to {@link #findingsFilterListItems(List<FindingsFilterListItem>)}.
         * 
         * @param findingsFilterListItems
         *        a consumer that will call methods on {@link List<FindingsFilterListItem>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #findingsFilterListItems(List<FindingsFilterListItem>)
         */
        Builder findingsFilterListItems(Consumer<FindingsFilterListItem.Builder>... findingsFilterListItems);

        /**
         * <p>
         * The string to use in a subsequent request to get the next page of results in a paginated response. This value
         * is null if there are no additional pages.
         * </p>
         * 
         * @param nextToken
         *        The string to use in a subsequent request to get the next page of results in a paginated response.
         *        This value is null if there are no additional pages.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends Macie2Response.BuilderImpl implements Builder {
        private List<FindingsFilterListItem> findingsFilterListItems = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListFindingsFiltersResponse model) {
            super(model);
            findingsFilterListItems(model.findingsFilterListItems);
            nextToken(model.nextToken);
        }

        public final Collection<FindingsFilterListItem.Builder> getFindingsFilterListItems() {
            return findingsFilterListItems != null ? findingsFilterListItems.stream().map(FindingsFilterListItem::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder findingsFilterListItems(Collection<FindingsFilterListItem> findingsFilterListItems) {
            this.findingsFilterListItems = ___listOfFindingsFilterListItemCopier.copy(findingsFilterListItems);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder findingsFilterListItems(FindingsFilterListItem... findingsFilterListItems) {
            findingsFilterListItems(Arrays.asList(findingsFilterListItems));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder findingsFilterListItems(Consumer<FindingsFilterListItem.Builder>... findingsFilterListItems) {
            findingsFilterListItems(Stream.of(findingsFilterListItems)
                    .map(c -> FindingsFilterListItem.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setFindingsFilterListItems(Collection<FindingsFilterListItem.BuilderImpl> findingsFilterListItems) {
            this.findingsFilterListItems = ___listOfFindingsFilterListItemCopier.copyFromBuilder(findingsFilterListItems);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListFindingsFiltersResponse build() {
            return new ListFindingsFiltersResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
