/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.macie2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies which S3 buckets contain the objects that a classification job analyzes, and the scope of that analysis.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class S3JobDefinition implements SdkPojo, Serializable, ToCopyableBuilder<S3JobDefinition.Builder, S3JobDefinition> {
    private static final SdkField<List<S3BucketDefinitionForJob>> BUCKET_DEFINITIONS_FIELD = SdkField
            .<List<S3BucketDefinitionForJob>> builder(MarshallingType.LIST)
            .getter(getter(S3JobDefinition::bucketDefinitions))
            .setter(setter(Builder::bucketDefinitions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("bucketDefinitions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<S3BucketDefinitionForJob> builder(MarshallingType.SDK_POJO)
                                            .constructor(S3BucketDefinitionForJob::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Scoping> SCOPING_FIELD = SdkField.<Scoping> builder(MarshallingType.SDK_POJO)
            .getter(getter(S3JobDefinition::scoping)).setter(setter(Builder::scoping)).constructor(Scoping::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scoping").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BUCKET_DEFINITIONS_FIELD,
            SCOPING_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<S3BucketDefinitionForJob> bucketDefinitions;

    private final Scoping scoping;

    private S3JobDefinition(BuilderImpl builder) {
        this.bucketDefinitions = builder.bucketDefinitions;
        this.scoping = builder.scoping;
    }

    /**
     * Returns true if the BucketDefinitions property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasBucketDefinitions() {
        return bucketDefinitions != null && !(bucketDefinitions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of objects, one for each bucket that contains objects to analyze.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasBucketDefinitions()} to see if a value was sent in this field.
     * </p>
     * 
     * @return An array of objects, one for each bucket that contains objects to analyze.
     */
    public List<S3BucketDefinitionForJob> bucketDefinitions() {
        return bucketDefinitions;
    }

    /**
     * <p>
     * The property- and tag-based conditions that determine which objects to include or exclude from the analysis.
     * </p>
     * 
     * @return The property- and tag-based conditions that determine which objects to include or exclude from the
     *         analysis.
     */
    public Scoping scoping() {
        return scoping;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(bucketDefinitions());
        hashCode = 31 * hashCode + Objects.hashCode(scoping());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof S3JobDefinition)) {
            return false;
        }
        S3JobDefinition other = (S3JobDefinition) obj;
        return Objects.equals(bucketDefinitions(), other.bucketDefinitions()) && Objects.equals(scoping(), other.scoping());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("S3JobDefinition").add("BucketDefinitions", bucketDefinitions()).add("Scoping", scoping())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "bucketDefinitions":
            return Optional.ofNullable(clazz.cast(bucketDefinitions()));
        case "scoping":
            return Optional.ofNullable(clazz.cast(scoping()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<S3JobDefinition, T> g) {
        return obj -> g.apply((S3JobDefinition) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, S3JobDefinition> {
        /**
         * <p>
         * An array of objects, one for each bucket that contains objects to analyze.
         * </p>
         * 
         * @param bucketDefinitions
         *        An array of objects, one for each bucket that contains objects to analyze.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bucketDefinitions(Collection<S3BucketDefinitionForJob> bucketDefinitions);

        /**
         * <p>
         * An array of objects, one for each bucket that contains objects to analyze.
         * </p>
         * 
         * @param bucketDefinitions
         *        An array of objects, one for each bucket that contains objects to analyze.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bucketDefinitions(S3BucketDefinitionForJob... bucketDefinitions);

        /**
         * <p>
         * An array of objects, one for each bucket that contains objects to analyze.
         * </p>
         * This is a convenience that creates an instance of the {@link List<S3BucketDefinitionForJob>.Builder} avoiding
         * the need to create one manually via {@link List<S3BucketDefinitionForJob>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<S3BucketDefinitionForJob>.Builder#build()} is called
         * immediately and its result is passed to {@link #bucketDefinitions(List<S3BucketDefinitionForJob>)}.
         * 
         * @param bucketDefinitions
         *        a consumer that will call methods on {@link List<S3BucketDefinitionForJob>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #bucketDefinitions(List<S3BucketDefinitionForJob>)
         */
        Builder bucketDefinitions(Consumer<S3BucketDefinitionForJob.Builder>... bucketDefinitions);

        /**
         * <p>
         * The property- and tag-based conditions that determine which objects to include or exclude from the analysis.
         * </p>
         * 
         * @param scoping
         *        The property- and tag-based conditions that determine which objects to include or exclude from the
         *        analysis.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scoping(Scoping scoping);

        /**
         * <p>
         * The property- and tag-based conditions that determine which objects to include or exclude from the analysis.
         * </p>
         * This is a convenience that creates an instance of the {@link Scoping.Builder} avoiding the need to create one
         * manually via {@link Scoping#builder()}.
         *
         * When the {@link Consumer} completes, {@link Scoping.Builder#build()} is called immediately and its result is
         * passed to {@link #scoping(Scoping)}.
         * 
         * @param scoping
         *        a consumer that will call methods on {@link Scoping.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #scoping(Scoping)
         */
        default Builder scoping(Consumer<Scoping.Builder> scoping) {
            return scoping(Scoping.builder().applyMutation(scoping).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private List<S3BucketDefinitionForJob> bucketDefinitions = DefaultSdkAutoConstructList.getInstance();

        private Scoping scoping;

        private BuilderImpl() {
        }

        private BuilderImpl(S3JobDefinition model) {
            bucketDefinitions(model.bucketDefinitions);
            scoping(model.scoping);
        }

        public final Collection<S3BucketDefinitionForJob.Builder> getBucketDefinitions() {
            return bucketDefinitions != null ? bucketDefinitions.stream().map(S3BucketDefinitionForJob::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder bucketDefinitions(Collection<S3BucketDefinitionForJob> bucketDefinitions) {
            this.bucketDefinitions = ___listOfS3BucketDefinitionForJobCopier.copy(bucketDefinitions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder bucketDefinitions(S3BucketDefinitionForJob... bucketDefinitions) {
            bucketDefinitions(Arrays.asList(bucketDefinitions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder bucketDefinitions(Consumer<S3BucketDefinitionForJob.Builder>... bucketDefinitions) {
            bucketDefinitions(Stream.of(bucketDefinitions).map(c -> S3BucketDefinitionForJob.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setBucketDefinitions(Collection<S3BucketDefinitionForJob.BuilderImpl> bucketDefinitions) {
            this.bucketDefinitions = ___listOfS3BucketDefinitionForJobCopier.copyFromBuilder(bucketDefinitions);
        }

        public final Scoping.Builder getScoping() {
            return scoping != null ? scoping.toBuilder() : null;
        }

        @Override
        public final Builder scoping(Scoping scoping) {
            this.scoping = scoping;
            return this;
        }

        public final void setScoping(Scoping.BuilderImpl scoping) {
            this.scoping = scoping != null ? scoping.build() : null;
        }

        @Override
        public S3JobDefinition build() {
            return new S3JobDefinition(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
