/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.macie2.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides information about the context in which temporary security credentials were issued to an entity.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SessionContextAttributes implements SdkPojo, Serializable,
        ToCopyableBuilder<SessionContextAttributes.Builder, SessionContextAttributes> {
    private static final SdkField<Instant> CREATION_DATE_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(SessionContextAttributes::creationDate))
            .setter(setter(Builder::creationDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationDate").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<Boolean> MFA_AUTHENTICATED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(SessionContextAttributes::mfaAuthenticated)).setter(setter(Builder::mfaAuthenticated))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mfaAuthenticated").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CREATION_DATE_FIELD,
            MFA_AUTHENTICATED_FIELD));

    private static final long serialVersionUID = 1L;

    private final Instant creationDate;

    private final Boolean mfaAuthenticated;

    private SessionContextAttributes(BuilderImpl builder) {
        this.creationDate = builder.creationDate;
        this.mfaAuthenticated = builder.mfaAuthenticated;
    }

    /**
     * <p>
     * The date and time, in UTC and ISO 8601 format, when the credentials were issued.
     * </p>
     * 
     * @return The date and time, in UTC and ISO 8601 format, when the credentials were issued.
     */
    public Instant creationDate() {
        return creationDate;
    }

    /**
     * <p>
     * Specifies whether the credentials were authenticated with a multi-factor authentication (MFA) device.
     * </p>
     * 
     * @return Specifies whether the credentials were authenticated with a multi-factor authentication (MFA) device.
     */
    public Boolean mfaAuthenticated() {
        return mfaAuthenticated;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(creationDate());
        hashCode = 31 * hashCode + Objects.hashCode(mfaAuthenticated());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SessionContextAttributes)) {
            return false;
        }
        SessionContextAttributes other = (SessionContextAttributes) obj;
        return Objects.equals(creationDate(), other.creationDate())
                && Objects.equals(mfaAuthenticated(), other.mfaAuthenticated());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("SessionContextAttributes").add("CreationDate", creationDate())
                .add("MfaAuthenticated", mfaAuthenticated()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "creationDate":
            return Optional.ofNullable(clazz.cast(creationDate()));
        case "mfaAuthenticated":
            return Optional.ofNullable(clazz.cast(mfaAuthenticated()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SessionContextAttributes, T> g) {
        return obj -> g.apply((SessionContextAttributes) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SessionContextAttributes> {
        /**
         * <p>
         * The date and time, in UTC and ISO 8601 format, when the credentials were issued.
         * </p>
         * 
         * @param creationDate
         *        The date and time, in UTC and ISO 8601 format, when the credentials were issued.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationDate(Instant creationDate);

        /**
         * <p>
         * Specifies whether the credentials were authenticated with a multi-factor authentication (MFA) device.
         * </p>
         * 
         * @param mfaAuthenticated
         *        Specifies whether the credentials were authenticated with a multi-factor authentication (MFA) device.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mfaAuthenticated(Boolean mfaAuthenticated);
    }

    static final class BuilderImpl implements Builder {
        private Instant creationDate;

        private Boolean mfaAuthenticated;

        private BuilderImpl() {
        }

        private BuilderImpl(SessionContextAttributes model) {
            creationDate(model.creationDate);
            mfaAuthenticated(model.mfaAuthenticated);
        }

        public final Instant getCreationDate() {
            return creationDate;
        }

        @Override
        public final Builder creationDate(Instant creationDate) {
            this.creationDate = creationDate;
            return this;
        }

        public final void setCreationDate(Instant creationDate) {
            this.creationDate = creationDate;
        }

        public final Boolean getMfaAuthenticated() {
            return mfaAuthenticated;
        }

        @Override
        public final Builder mfaAuthenticated(Boolean mfaAuthenticated) {
            this.mfaAuthenticated = mfaAuthenticated;
            return this;
        }

        public final void setMfaAuthenticated(Boolean mfaAuthenticated) {
            this.mfaAuthenticated = mfaAuthenticated;
        }

        @Override
        public SessionContextAttributes build() {
            return new SessionContextAttributes(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
