/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.macie2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides the numeric score and textual representation of a severity value.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Severity implements SdkPojo, Serializable, ToCopyableBuilder<Severity.Builder, Severity> {
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Severity::descriptionAsString)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<Long> SCORE_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .getter(getter(Severity::score)).setter(setter(Builder::score))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("score").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(DESCRIPTION_FIELD, SCORE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String description;

    private final Long score;

    private Severity(BuilderImpl builder) {
        this.description = builder.description;
        this.score = builder.score;
    }

    /**
     * <p>
     * The textual representation of the severity value, such as Low or High.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #description} will
     * return {@link SeverityDescription#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #descriptionAsString}.
     * </p>
     * 
     * @return The textual representation of the severity value, such as Low or High.
     * @see SeverityDescription
     */
    public SeverityDescription description() {
        return SeverityDescription.fromValue(description);
    }

    /**
     * <p>
     * The textual representation of the severity value, such as Low or High.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #description} will
     * return {@link SeverityDescription#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #descriptionAsString}.
     * </p>
     * 
     * @return The textual representation of the severity value, such as Low or High.
     * @see SeverityDescription
     */
    public String descriptionAsString() {
        return description;
    }

    /**
     * <p>
     * The numeric score for the severity value, ranging from 0 (least severe) to 4 (most severe).
     * </p>
     * 
     * @return The numeric score for the severity value, ranging from 0 (least severe) to 4 (most severe).
     */
    public Long score() {
        return score;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(descriptionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(score());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Severity)) {
            return false;
        }
        Severity other = (Severity) obj;
        return Objects.equals(descriptionAsString(), other.descriptionAsString()) && Objects.equals(score(), other.score());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("Severity").add("Description", descriptionAsString()).add("Score", score()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "description":
            return Optional.ofNullable(clazz.cast(descriptionAsString()));
        case "score":
            return Optional.ofNullable(clazz.cast(score()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Severity, T> g) {
        return obj -> g.apply((Severity) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Severity> {
        /**
         * <p>
         * The textual representation of the severity value, such as Low or High.
         * </p>
         * 
         * @param description
         *        The textual representation of the severity value, such as Low or High.
         * @see SeverityDescription
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SeverityDescription
         */
        Builder description(String description);

        /**
         * <p>
         * The textual representation of the severity value, such as Low or High.
         * </p>
         * 
         * @param description
         *        The textual representation of the severity value, such as Low or High.
         * @see SeverityDescription
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SeverityDescription
         */
        Builder description(SeverityDescription description);

        /**
         * <p>
         * The numeric score for the severity value, ranging from 0 (least severe) to 4 (most severe).
         * </p>
         * 
         * @param score
         *        The numeric score for the severity value, ranging from 0 (least severe) to 4 (most severe).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder score(Long score);
    }

    static final class BuilderImpl implements Builder {
        private String description;

        private Long score;

        private BuilderImpl() {
        }

        private BuilderImpl(Severity model) {
            description(model.description);
            score(model.score);
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        @Override
        public final Builder description(SeverityDescription description) {
            this.description(description == null ? null : description.toString());
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final Long getScore() {
            return score;
        }

        @Override
        public final Builder score(Long score) {
            this.score = score;
            return this;
        }

        public final void setScore(Long score) {
            this.score = score;
        }

        @Override
        public Severity build() {
            return new Severity(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
