/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.macie2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies a tag-based condition that determines whether an object is included or excluded from a classification job.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TagScopeTerm implements SdkPojo, Serializable, ToCopyableBuilder<TagScopeTerm.Builder, TagScopeTerm> {
    private static final SdkField<String> COMPARATOR_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(TagScopeTerm::comparatorAsString)).setter(setter(Builder::comparator))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("comparator").build()).build();

    private static final SdkField<String> KEY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(TagScopeTerm::key)).setter(setter(Builder::key))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("key").build()).build();

    private static final SdkField<List<TagValuePair>> TAG_VALUES_FIELD = SdkField
            .<List<TagValuePair>> builder(MarshallingType.LIST)
            .getter(getter(TagScopeTerm::tagValues))
            .setter(setter(Builder::tagValues))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tagValues").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<TagValuePair> builder(MarshallingType.SDK_POJO)
                                            .constructor(TagValuePair::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> TARGET_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(TagScopeTerm::targetAsString)).setter(setter(Builder::target))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("target").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COMPARATOR_FIELD, KEY_FIELD,
            TAG_VALUES_FIELD, TARGET_FIELD));

    private static final long serialVersionUID = 1L;

    private final String comparator;

    private final String key;

    private final List<TagValuePair> tagValues;

    private final String target;

    private TagScopeTerm(BuilderImpl builder) {
        this.comparator = builder.comparator;
        this.key = builder.key;
        this.tagValues = builder.tagValues;
        this.target = builder.target;
    }

    /**
     * <p>
     * The operator to use in the condition.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #comparator} will
     * return {@link JobComparator#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #comparatorAsString}.
     * </p>
     * 
     * @return The operator to use in the condition.
     * @see JobComparator
     */
    public JobComparator comparator() {
        return JobComparator.fromValue(comparator);
    }

    /**
     * <p>
     * The operator to use in the condition.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #comparator} will
     * return {@link JobComparator#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #comparatorAsString}.
     * </p>
     * 
     * @return The operator to use in the condition.
     * @see JobComparator
     */
    public String comparatorAsString() {
        return comparator;
    }

    /**
     * <p>
     * The tag key to use in the condition.
     * </p>
     * 
     * @return The tag key to use in the condition.
     */
    public String key() {
        return key;
    }

    /**
     * Returns true if the TagValues property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasTagValues() {
        return tagValues != null && !(tagValues instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The tag key and value pairs to use in the condition.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTagValues()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The tag key and value pairs to use in the condition.
     */
    public List<TagValuePair> tagValues() {
        return tagValues;
    }

    /**
     * <p>
     * The type of object to apply the condition to.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #target} will
     * return {@link TagTarget#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #targetAsString}.
     * </p>
     * 
     * @return The type of object to apply the condition to.
     * @see TagTarget
     */
    public TagTarget target() {
        return TagTarget.fromValue(target);
    }

    /**
     * <p>
     * The type of object to apply the condition to.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #target} will
     * return {@link TagTarget#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #targetAsString}.
     * </p>
     * 
     * @return The type of object to apply the condition to.
     * @see TagTarget
     */
    public String targetAsString() {
        return target;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(comparatorAsString());
        hashCode = 31 * hashCode + Objects.hashCode(key());
        hashCode = 31 * hashCode + Objects.hashCode(tagValues());
        hashCode = 31 * hashCode + Objects.hashCode(targetAsString());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TagScopeTerm)) {
            return false;
        }
        TagScopeTerm other = (TagScopeTerm) obj;
        return Objects.equals(comparatorAsString(), other.comparatorAsString()) && Objects.equals(key(), other.key())
                && Objects.equals(tagValues(), other.tagValues()) && Objects.equals(targetAsString(), other.targetAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("TagScopeTerm").add("Comparator", comparatorAsString()).add("Key", key())
                .add("TagValues", tagValues()).add("Target", targetAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "comparator":
            return Optional.ofNullable(clazz.cast(comparatorAsString()));
        case "key":
            return Optional.ofNullable(clazz.cast(key()));
        case "tagValues":
            return Optional.ofNullable(clazz.cast(tagValues()));
        case "target":
            return Optional.ofNullable(clazz.cast(targetAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TagScopeTerm, T> g) {
        return obj -> g.apply((TagScopeTerm) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TagScopeTerm> {
        /**
         * <p>
         * The operator to use in the condition.
         * </p>
         * 
         * @param comparator
         *        The operator to use in the condition.
         * @see JobComparator
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see JobComparator
         */
        Builder comparator(String comparator);

        /**
         * <p>
         * The operator to use in the condition.
         * </p>
         * 
         * @param comparator
         *        The operator to use in the condition.
         * @see JobComparator
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see JobComparator
         */
        Builder comparator(JobComparator comparator);

        /**
         * <p>
         * The tag key to use in the condition.
         * </p>
         * 
         * @param key
         *        The tag key to use in the condition.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder key(String key);

        /**
         * <p>
         * The tag key and value pairs to use in the condition.
         * </p>
         * 
         * @param tagValues
         *        The tag key and value pairs to use in the condition.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tagValues(Collection<TagValuePair> tagValues);

        /**
         * <p>
         * The tag key and value pairs to use in the condition.
         * </p>
         * 
         * @param tagValues
         *        The tag key and value pairs to use in the condition.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tagValues(TagValuePair... tagValues);

        /**
         * <p>
         * The tag key and value pairs to use in the condition.
         * </p>
         * This is a convenience that creates an instance of the {@link List<TagValuePair>.Builder} avoiding the need to
         * create one manually via {@link List<TagValuePair>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<TagValuePair>.Builder#build()} is called immediately and its
         * result is passed to {@link #tagValues(List<TagValuePair>)}.
         * 
         * @param tagValues
         *        a consumer that will call methods on {@link List<TagValuePair>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tagValues(List<TagValuePair>)
         */
        Builder tagValues(Consumer<TagValuePair.Builder>... tagValues);

        /**
         * <p>
         * The type of object to apply the condition to.
         * </p>
         * 
         * @param target
         *        The type of object to apply the condition to.
         * @see TagTarget
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TagTarget
         */
        Builder target(String target);

        /**
         * <p>
         * The type of object to apply the condition to.
         * </p>
         * 
         * @param target
         *        The type of object to apply the condition to.
         * @see TagTarget
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TagTarget
         */
        Builder target(TagTarget target);
    }

    static final class BuilderImpl implements Builder {
        private String comparator;

        private String key;

        private List<TagValuePair> tagValues = DefaultSdkAutoConstructList.getInstance();

        private String target;

        private BuilderImpl() {
        }

        private BuilderImpl(TagScopeTerm model) {
            comparator(model.comparator);
            key(model.key);
            tagValues(model.tagValues);
            target(model.target);
        }

        public final String getComparator() {
            return comparator;
        }

        @Override
        public final Builder comparator(String comparator) {
            this.comparator = comparator;
            return this;
        }

        @Override
        public final Builder comparator(JobComparator comparator) {
            this.comparator(comparator == null ? null : comparator.toString());
            return this;
        }

        public final void setComparator(String comparator) {
            this.comparator = comparator;
        }

        public final String getKey() {
            return key;
        }

        @Override
        public final Builder key(String key) {
            this.key = key;
            return this;
        }

        public final void setKey(String key) {
            this.key = key;
        }

        public final Collection<TagValuePair.Builder> getTagValues() {
            return tagValues != null ? tagValues.stream().map(TagValuePair::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tagValues(Collection<TagValuePair> tagValues) {
            this.tagValues = ___listOfTagValuePairCopier.copy(tagValues);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagValues(TagValuePair... tagValues) {
            tagValues(Arrays.asList(tagValues));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagValues(Consumer<TagValuePair.Builder>... tagValues) {
            tagValues(Stream.of(tagValues).map(c -> TagValuePair.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTagValues(Collection<TagValuePair.BuilderImpl> tagValues) {
            this.tagValues = ___listOfTagValuePairCopier.copyFromBuilder(tagValues);
        }

        public final String getTarget() {
            return target;
        }

        @Override
        public final Builder target(String target) {
            this.target = target;
            return this;
        }

        @Override
        public final Builder target(TagTarget target) {
            this.target(target == null ? null : target.toString());
            return this;
        }

        public final void setTarget(String target) {
            this.target = target;
        }

        @Override
        public TagScopeTerm build() {
            return new TagScopeTerm(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
