/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.macie2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides information about the status of a sensitive data finding.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ClassificationResultStatus implements SdkPojo, Serializable,
        ToCopyableBuilder<ClassificationResultStatus.Builder, ClassificationResultStatus> {
    private static final SdkField<String> CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("code")
            .getter(getter(ClassificationResultStatus::code)).setter(setter(Builder::code))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("code").build()).build();

    private static final SdkField<String> REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("reason")
            .getter(getter(ClassificationResultStatus::reason)).setter(setter(Builder::reason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("reason").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CODE_FIELD, REASON_FIELD));

    private static final long serialVersionUID = 1L;

    private final String code;

    private final String reason;

    private ClassificationResultStatus(BuilderImpl builder) {
        this.code = builder.code;
        this.reason = builder.reason;
    }

    /**
     * <p>
     * The status of the finding. Possible values are:
     * </p>
     * <ul>
     * <li>
     * <p>
     * COMPLETE - Amazon Macie successfully completed its analysis of the object that the finding applies to.
     * </p>
     * </li>
     * <li>
     * <p>
     * PARTIAL - Macie analyzed only a subset of the data in the object that the finding applies to. For example, the
     * object is an archive file that contains files in an unsupported format.
     * </p>
     * </li>
     * <li>
     * <p>
     * SKIPPED - Macie wasn't able to analyze the object that the finding applies to. For example, the object is a
     * malformed file or a file that uses an unsupported format.
     * </p>
     * </li>
     * </ul>
     * 
     * @return <p>
     *         The status of the finding. Possible values are:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         COMPLETE - Amazon Macie successfully completed its analysis of the object that the finding applies to.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         PARTIAL - Macie analyzed only a subset of the data in the object that the finding applies to. For
     *         example, the object is an archive file that contains files in an unsupported format.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         SKIPPED - Macie wasn't able to analyze the object that the finding applies to. For example, the object is
     *         a malformed file or a file that uses an unsupported format.
     *         </p>
     *         </li>
     *         </ul>
     */
    public String code() {
        return code;
    }

    /**
     * <p>
     * A brief description of the status of the finding. Amazon Macie uses this value to notify you of any errors,
     * warnings, or considerations that might impact your analysis of the finding.
     * </p>
     * 
     * @return A brief description of the status of the finding. Amazon Macie uses this value to notify you of any
     *         errors, warnings, or considerations that might impact your analysis of the finding.
     */
    public String reason() {
        return reason;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(code());
        hashCode = 31 * hashCode + Objects.hashCode(reason());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ClassificationResultStatus)) {
            return false;
        }
        ClassificationResultStatus other = (ClassificationResultStatus) obj;
        return Objects.equals(code(), other.code()) && Objects.equals(reason(), other.reason());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ClassificationResultStatus").add("Code", code()).add("Reason", reason()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "code":
            return Optional.ofNullable(clazz.cast(code()));
        case "reason":
            return Optional.ofNullable(clazz.cast(reason()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ClassificationResultStatus, T> g) {
        return obj -> g.apply((ClassificationResultStatus) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ClassificationResultStatus> {
        /**
         * <p>
         * The status of the finding. Possible values are:
         * </p>
         * <ul>
         * <li>
         * <p>
         * COMPLETE - Amazon Macie successfully completed its analysis of the object that the finding applies to.
         * </p>
         * </li>
         * <li>
         * <p>
         * PARTIAL - Macie analyzed only a subset of the data in the object that the finding applies to. For example,
         * the object is an archive file that contains files in an unsupported format.
         * </p>
         * </li>
         * <li>
         * <p>
         * SKIPPED - Macie wasn't able to analyze the object that the finding applies to. For example, the object is a
         * malformed file or a file that uses an unsupported format.
         * </p>
         * </li>
         * </ul>
         * 
         * @param code
         *        <p>
         *        The status of the finding. Possible values are:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        COMPLETE - Amazon Macie successfully completed its analysis of the object that the finding applies to.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        PARTIAL - Macie analyzed only a subset of the data in the object that the finding applies to. For
         *        example, the object is an archive file that contains files in an unsupported format.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        SKIPPED - Macie wasn't able to analyze the object that the finding applies to. For example, the object
         *        is a malformed file or a file that uses an unsupported format.
         *        </p>
         *        </li>
         *        </ul>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder code(String code);

        /**
         * <p>
         * A brief description of the status of the finding. Amazon Macie uses this value to notify you of any errors,
         * warnings, or considerations that might impact your analysis of the finding.
         * </p>
         * 
         * @param reason
         *        A brief description of the status of the finding. Amazon Macie uses this value to notify you of any
         *        errors, warnings, or considerations that might impact your analysis of the finding.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reason(String reason);
    }

    static final class BuilderImpl implements Builder {
        private String code;

        private String reason;

        private BuilderImpl() {
        }

        private BuilderImpl(ClassificationResultStatus model) {
            code(model.code);
            reason(model.reason);
        }

        public final String getCode() {
            return code;
        }

        @Override
        public final Builder code(String code) {
            this.code = code;
            return this;
        }

        public final void setCode(String code) {
            this.code = code;
        }

        public final String getReason() {
            return reason;
        }

        @Override
        public final Builder reason(String reason) {
            this.reason = reason;
            return this;
        }

        public final void setReason(String reason) {
            this.reason = reason;
        }

        @Override
        public ClassificationResultStatus build() {
            return new ClassificationResultStatus(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
