/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.macie2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies the location of an occurrence of sensitive data in an Adobe Portable Document Format file.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Page implements SdkPojo, Serializable, ToCopyableBuilder<Page.Builder, Page> {
    private static final SdkField<Range> LINE_RANGE_FIELD = SdkField.<Range> builder(MarshallingType.SDK_POJO)
            .memberName("lineRange").getter(getter(Page::lineRange)).setter(setter(Builder::lineRange))
            .constructor(Range::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lineRange").build()).build();

    private static final SdkField<Range> OFFSET_RANGE_FIELD = SdkField.<Range> builder(MarshallingType.SDK_POJO)
            .memberName("offsetRange").getter(getter(Page::offsetRange)).setter(setter(Builder::offsetRange))
            .constructor(Range::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("offsetRange").build()).build();

    private static final SdkField<Long> PAGE_NUMBER_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("pageNumber").getter(getter(Page::pageNumber)).setter(setter(Builder::pageNumber))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pageNumber").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LINE_RANGE_FIELD,
            OFFSET_RANGE_FIELD, PAGE_NUMBER_FIELD));

    private static final long serialVersionUID = 1L;

    private final Range lineRange;

    private final Range offsetRange;

    private final Long pageNumber;

    private Page(BuilderImpl builder) {
        this.lineRange = builder.lineRange;
        this.offsetRange = builder.offsetRange;
        this.pageNumber = builder.pageNumber;
    }

    /**
     * <p>
     * The line that contains the data, and the position of the data on that line.
     * </p>
     * 
     * @return The line that contains the data, and the position of the data on that line.
     */
    public Range lineRange() {
        return lineRange;
    }

    /**
     * <p>
     * The position of the data on the page, relative to the beginning of the page.
     * </p>
     * 
     * @return The position of the data on the page, relative to the beginning of the page.
     */
    public Range offsetRange() {
        return offsetRange;
    }

    /**
     * <p>
     * The page number of the page that contains the data.
     * </p>
     * 
     * @return The page number of the page that contains the data.
     */
    public Long pageNumber() {
        return pageNumber;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(lineRange());
        hashCode = 31 * hashCode + Objects.hashCode(offsetRange());
        hashCode = 31 * hashCode + Objects.hashCode(pageNumber());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Page)) {
            return false;
        }
        Page other = (Page) obj;
        return Objects.equals(lineRange(), other.lineRange()) && Objects.equals(offsetRange(), other.offsetRange())
                && Objects.equals(pageNumber(), other.pageNumber());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("Page").add("LineRange", lineRange()).add("OffsetRange", offsetRange())
                .add("PageNumber", pageNumber()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "lineRange":
            return Optional.ofNullable(clazz.cast(lineRange()));
        case "offsetRange":
            return Optional.ofNullable(clazz.cast(offsetRange()));
        case "pageNumber":
            return Optional.ofNullable(clazz.cast(pageNumber()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Page, T> g) {
        return obj -> g.apply((Page) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Page> {
        /**
         * <p>
         * The line that contains the data, and the position of the data on that line.
         * </p>
         * 
         * @param lineRange
         *        The line that contains the data, and the position of the data on that line.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lineRange(Range lineRange);

        /**
         * <p>
         * The line that contains the data, and the position of the data on that line.
         * </p>
         * This is a convenience that creates an instance of the {@link Range.Builder} avoiding the need to create one
         * manually via {@link Range#builder()}.
         *
         * When the {@link Consumer} completes, {@link Range.Builder#build()} is called immediately and its result is
         * passed to {@link #lineRange(Range)}.
         * 
         * @param lineRange
         *        a consumer that will call methods on {@link Range.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #lineRange(Range)
         */
        default Builder lineRange(Consumer<Range.Builder> lineRange) {
            return lineRange(Range.builder().applyMutation(lineRange).build());
        }

        /**
         * <p>
         * The position of the data on the page, relative to the beginning of the page.
         * </p>
         * 
         * @param offsetRange
         *        The position of the data on the page, relative to the beginning of the page.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder offsetRange(Range offsetRange);

        /**
         * <p>
         * The position of the data on the page, relative to the beginning of the page.
         * </p>
         * This is a convenience that creates an instance of the {@link Range.Builder} avoiding the need to create one
         * manually via {@link Range#builder()}.
         *
         * When the {@link Consumer} completes, {@link Range.Builder#build()} is called immediately and its result is
         * passed to {@link #offsetRange(Range)}.
         * 
         * @param offsetRange
         *        a consumer that will call methods on {@link Range.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #offsetRange(Range)
         */
        default Builder offsetRange(Consumer<Range.Builder> offsetRange) {
            return offsetRange(Range.builder().applyMutation(offsetRange).build());
        }

        /**
         * <p>
         * The page number of the page that contains the data.
         * </p>
         * 
         * @param pageNumber
         *        The page number of the page that contains the data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pageNumber(Long pageNumber);
    }

    static final class BuilderImpl implements Builder {
        private Range lineRange;

        private Range offsetRange;

        private Long pageNumber;

        private BuilderImpl() {
        }

        private BuilderImpl(Page model) {
            lineRange(model.lineRange);
            offsetRange(model.offsetRange);
            pageNumber(model.pageNumber);
        }

        public final Range.Builder getLineRange() {
            return lineRange != null ? lineRange.toBuilder() : null;
        }

        @Override
        public final Builder lineRange(Range lineRange) {
            this.lineRange = lineRange;
            return this;
        }

        public final void setLineRange(Range.BuilderImpl lineRange) {
            this.lineRange = lineRange != null ? lineRange.build() : null;
        }

        public final Range.Builder getOffsetRange() {
            return offsetRange != null ? offsetRange.toBuilder() : null;
        }

        @Override
        public final Builder offsetRange(Range offsetRange) {
            this.offsetRange = offsetRange;
            return this;
        }

        public final void setOffsetRange(Range.BuilderImpl offsetRange) {
            this.offsetRange = offsetRange != null ? offsetRange.build() : null;
        }

        public final Long getPageNumber() {
            return pageNumber;
        }

        @Override
        public final Builder pageNumber(Long pageNumber) {
            this.pageNumber = pageNumber;
            return this;
        }

        public final void setPageNumber(Long pageNumber) {
            this.pageNumber = pageNumber;
        }

        @Override
        public Page build() {
            return new Page(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
