/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.macie2.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides quota and aggregated usage data for an account.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class UsageRecord implements SdkPojo, Serializable, ToCopyableBuilder<UsageRecord.Builder, UsageRecord> {
    private static final SdkField<String> ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("accountId").getter(getter(UsageRecord::accountId)).setter(setter(Builder::accountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accountId").build()).build();

    private static final SdkField<Instant> FREE_TRIAL_START_DATE_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("freeTrialStartDate")
            .getter(getter(UsageRecord::freeTrialStartDate))
            .setter(setter(Builder::freeTrialStartDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("freeTrialStartDate").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<List<UsageByAccount>> USAGE_FIELD = SdkField
            .<List<UsageByAccount>> builder(MarshallingType.LIST)
            .memberName("usage")
            .getter(getter(UsageRecord::usage))
            .setter(setter(Builder::usage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("usage").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<UsageByAccount> builder(MarshallingType.SDK_POJO)
                                            .constructor(UsageByAccount::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNT_ID_FIELD,
            FREE_TRIAL_START_DATE_FIELD, USAGE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String accountId;

    private final Instant freeTrialStartDate;

    private final List<UsageByAccount> usage;

    private UsageRecord(BuilderImpl builder) {
        this.accountId = builder.accountId;
        this.freeTrialStartDate = builder.freeTrialStartDate;
        this.usage = builder.usage;
    }

    /**
     * <p>
     * The unique identifier for the AWS account that the data applies to.
     * </p>
     * 
     * @return The unique identifier for the AWS account that the data applies to.
     */
    public String accountId() {
        return accountId;
    }

    /**
     * <p>
     * The date and time, in UTC and extended ISO 8601 format, when the free trial started for the account.
     * </p>
     * 
     * @return The date and time, in UTC and extended ISO 8601 format, when the free trial started for the account.
     */
    public Instant freeTrialStartDate() {
        return freeTrialStartDate;
    }

    /**
     * Returns true if the Usage property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasUsage() {
        return usage != null && !(usage instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of objects that contains usage data and quotas for the account. Each object contains the data for a
     * specific usage metric and the corresponding quota.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasUsage()} to see if a value was sent in this field.
     * </p>
     * 
     * @return An array of objects that contains usage data and quotas for the account. Each object contains the data
     *         for a specific usage metric and the corresponding quota.
     */
    public List<UsageByAccount> usage() {
        return usage;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(accountId());
        hashCode = 31 * hashCode + Objects.hashCode(freeTrialStartDate());
        hashCode = 31 * hashCode + Objects.hashCode(hasUsage() ? usage() : null);
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UsageRecord)) {
            return false;
        }
        UsageRecord other = (UsageRecord) obj;
        return Objects.equals(accountId(), other.accountId()) && Objects.equals(freeTrialStartDate(), other.freeTrialStartDate())
                && hasUsage() == other.hasUsage() && Objects.equals(usage(), other.usage());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("UsageRecord").add("AccountId", accountId()).add("FreeTrialStartDate", freeTrialStartDate())
                .add("Usage", hasUsage() ? usage() : null).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "accountId":
            return Optional.ofNullable(clazz.cast(accountId()));
        case "freeTrialStartDate":
            return Optional.ofNullable(clazz.cast(freeTrialStartDate()));
        case "usage":
            return Optional.ofNullable(clazz.cast(usage()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UsageRecord, T> g) {
        return obj -> g.apply((UsageRecord) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, UsageRecord> {
        /**
         * <p>
         * The unique identifier for the AWS account that the data applies to.
         * </p>
         * 
         * @param accountId
         *        The unique identifier for the AWS account that the data applies to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountId(String accountId);

        /**
         * <p>
         * The date and time, in UTC and extended ISO 8601 format, when the free trial started for the account.
         * </p>
         * 
         * @param freeTrialStartDate
         *        The date and time, in UTC and extended ISO 8601 format, when the free trial started for the account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder freeTrialStartDate(Instant freeTrialStartDate);

        /**
         * <p>
         * An array of objects that contains usage data and quotas for the account. Each object contains the data for a
         * specific usage metric and the corresponding quota.
         * </p>
         * 
         * @param usage
         *        An array of objects that contains usage data and quotas for the account. Each object contains the data
         *        for a specific usage metric and the corresponding quota.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder usage(Collection<UsageByAccount> usage);

        /**
         * <p>
         * An array of objects that contains usage data and quotas for the account. Each object contains the data for a
         * specific usage metric and the corresponding quota.
         * </p>
         * 
         * @param usage
         *        An array of objects that contains usage data and quotas for the account. Each object contains the data
         *        for a specific usage metric and the corresponding quota.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder usage(UsageByAccount... usage);

        /**
         * <p>
         * An array of objects that contains usage data and quotas for the account. Each object contains the data for a
         * specific usage metric and the corresponding quota.
         * </p>
         * This is a convenience that creates an instance of the {@link List<UsageByAccount>.Builder} avoiding the need
         * to create one manually via {@link List<UsageByAccount>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<UsageByAccount>.Builder#build()} is called immediately and
         * its result is passed to {@link #usage(List<UsageByAccount>)}.
         * 
         * @param usage
         *        a consumer that will call methods on {@link List<UsageByAccount>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #usage(List<UsageByAccount>)
         */
        Builder usage(Consumer<UsageByAccount.Builder>... usage);
    }

    static final class BuilderImpl implements Builder {
        private String accountId;

        private Instant freeTrialStartDate;

        private List<UsageByAccount> usage = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UsageRecord model) {
            accountId(model.accountId);
            freeTrialStartDate(model.freeTrialStartDate);
            usage(model.usage);
        }

        public final String getAccountId() {
            return accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        public final Instant getFreeTrialStartDate() {
            return freeTrialStartDate;
        }

        @Override
        public final Builder freeTrialStartDate(Instant freeTrialStartDate) {
            this.freeTrialStartDate = freeTrialStartDate;
            return this;
        }

        public final void setFreeTrialStartDate(Instant freeTrialStartDate) {
            this.freeTrialStartDate = freeTrialStartDate;
        }

        public final Collection<UsageByAccount.Builder> getUsage() {
            if (usage instanceof SdkAutoConstructList) {
                return null;
            }
            return usage != null ? usage.stream().map(UsageByAccount::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder usage(Collection<UsageByAccount> usage) {
            this.usage = ___listOfUsageByAccountCopier.copy(usage);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder usage(UsageByAccount... usage) {
            usage(Arrays.asList(usage));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder usage(Consumer<UsageByAccount.Builder>... usage) {
            usage(Stream.of(usage).map(c -> UsageByAccount.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setUsage(Collection<UsageByAccount.BuilderImpl> usage) {
            this.usage = ___listOfUsageByAccountCopier.copyFromBuilder(usage);
        }

        @Override
        public UsageRecord build() {
            return new UsageRecord(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
