/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.macie2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies criteria for sorting the results of a query for account quotas and usage data.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class UsageStatisticsSortBy implements SdkPojo, Serializable,
        ToCopyableBuilder<UsageStatisticsSortBy.Builder, UsageStatisticsSortBy> {
    private static final SdkField<String> KEY_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("key")
            .getter(getter(UsageStatisticsSortBy::keyAsString)).setter(setter(Builder::key))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("key").build()).build();

    private static final SdkField<String> ORDER_BY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("orderBy").getter(getter(UsageStatisticsSortBy::orderByAsString)).setter(setter(Builder::orderBy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("orderBy").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(KEY_FIELD, ORDER_BY_FIELD));

    private static final long serialVersionUID = 1L;

    private final String key;

    private final String orderBy;

    private UsageStatisticsSortBy(BuilderImpl builder) {
        this.key = builder.key;
        this.orderBy = builder.orderBy;
    }

    /**
     * <p>
     * The field to sort the results by.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #key} will return
     * {@link UsageStatisticsSortKey#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #keyAsString}.
     * </p>
     * 
     * @return The field to sort the results by.
     * @see UsageStatisticsSortKey
     */
    public UsageStatisticsSortKey key() {
        return UsageStatisticsSortKey.fromValue(key);
    }

    /**
     * <p>
     * The field to sort the results by.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #key} will return
     * {@link UsageStatisticsSortKey#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #keyAsString}.
     * </p>
     * 
     * @return The field to sort the results by.
     * @see UsageStatisticsSortKey
     */
    public String keyAsString() {
        return key;
    }

    /**
     * <p>
     * The sort order to apply to the results, based on the value for the field specified by the key property. Valid
     * values are: ASC, sort the results in ascending order; and, DESC, sort the results in descending order.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #orderBy} will
     * return {@link OrderBy#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #orderByAsString}.
     * </p>
     * 
     * @return The sort order to apply to the results, based on the value for the field specified by the key property.
     *         Valid values are: ASC, sort the results in ascending order; and, DESC, sort the results in descending
     *         order.
     * @see OrderBy
     */
    public OrderBy orderBy() {
        return OrderBy.fromValue(orderBy);
    }

    /**
     * <p>
     * The sort order to apply to the results, based on the value for the field specified by the key property. Valid
     * values are: ASC, sort the results in ascending order; and, DESC, sort the results in descending order.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #orderBy} will
     * return {@link OrderBy#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #orderByAsString}.
     * </p>
     * 
     * @return The sort order to apply to the results, based on the value for the field specified by the key property.
     *         Valid values are: ASC, sort the results in ascending order; and, DESC, sort the results in descending
     *         order.
     * @see OrderBy
     */
    public String orderByAsString() {
        return orderBy;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(keyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(orderByAsString());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UsageStatisticsSortBy)) {
            return false;
        }
        UsageStatisticsSortBy other = (UsageStatisticsSortBy) obj;
        return Objects.equals(keyAsString(), other.keyAsString()) && Objects.equals(orderByAsString(), other.orderByAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("UsageStatisticsSortBy").add("Key", keyAsString()).add("OrderBy", orderByAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "key":
            return Optional.ofNullable(clazz.cast(keyAsString()));
        case "orderBy":
            return Optional.ofNullable(clazz.cast(orderByAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UsageStatisticsSortBy, T> g) {
        return obj -> g.apply((UsageStatisticsSortBy) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, UsageStatisticsSortBy> {
        /**
         * <p>
         * The field to sort the results by.
         * </p>
         * 
         * @param key
         *        The field to sort the results by.
         * @see UsageStatisticsSortKey
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see UsageStatisticsSortKey
         */
        Builder key(String key);

        /**
         * <p>
         * The field to sort the results by.
         * </p>
         * 
         * @param key
         *        The field to sort the results by.
         * @see UsageStatisticsSortKey
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see UsageStatisticsSortKey
         */
        Builder key(UsageStatisticsSortKey key);

        /**
         * <p>
         * The sort order to apply to the results, based on the value for the field specified by the key property. Valid
         * values are: ASC, sort the results in ascending order; and, DESC, sort the results in descending order.
         * </p>
         * 
         * @param orderBy
         *        The sort order to apply to the results, based on the value for the field specified by the key
         *        property. Valid values are: ASC, sort the results in ascending order; and, DESC, sort the results in
         *        descending order.
         * @see OrderBy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OrderBy
         */
        Builder orderBy(String orderBy);

        /**
         * <p>
         * The sort order to apply to the results, based on the value for the field specified by the key property. Valid
         * values are: ASC, sort the results in ascending order; and, DESC, sort the results in descending order.
         * </p>
         * 
         * @param orderBy
         *        The sort order to apply to the results, based on the value for the field specified by the key
         *        property. Valid values are: ASC, sort the results in ascending order; and, DESC, sort the results in
         *        descending order.
         * @see OrderBy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OrderBy
         */
        Builder orderBy(OrderBy orderBy);
    }

    static final class BuilderImpl implements Builder {
        private String key;

        private String orderBy;

        private BuilderImpl() {
        }

        private BuilderImpl(UsageStatisticsSortBy model) {
            key(model.key);
            orderBy(model.orderBy);
        }

        public final String getKey() {
            return key;
        }

        @Override
        public final Builder key(String key) {
            this.key = key;
            return this;
        }

        @Override
        public final Builder key(UsageStatisticsSortKey key) {
            this.key(key == null ? null : key.toString());
            return this;
        }

        public final void setKey(String key) {
            this.key = key;
        }

        public final String getOrderBy() {
            return orderBy;
        }

        @Override
        public final Builder orderBy(String orderBy) {
            this.orderBy = orderBy;
            return this;
        }

        @Override
        public final Builder orderBy(OrderBy orderBy) {
            this.orderBy(orderBy == null ? null : orderBy.toString());
            return this;
        }

        public final void setOrderBy(String orderBy) {
            this.orderBy = orderBy;
        }

        @Override
        public UsageStatisticsSortBy build() {
            return new UsageStatisticsSortBy(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
