/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.macie2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class S3Destination
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, S3Destination> {
    private static final SdkField<String> BUCKET_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("bucketName").getter(S3Destination.getter(S3Destination::bucketName)).setter(S3Destination.setter(Builder::bucketName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("bucketName").build()}).build();
    private static final SdkField<String> KEY_PREFIX_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("keyPrefix").getter(S3Destination.getter(S3Destination::keyPrefix)).setter(S3Destination.setter(Builder::keyPrefix)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("keyPrefix").build()}).build();
    private static final SdkField<String> KMS_KEY_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("kmsKeyArn").getter(S3Destination.getter(S3Destination::kmsKeyArn)).setter(S3Destination.setter(Builder::kmsKeyArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("kmsKeyArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BUCKET_NAME_FIELD, KEY_PREFIX_FIELD, KMS_KEY_ARN_FIELD));
    private static final long serialVersionUID = 1L;
    private final String bucketName;
    private final String keyPrefix;
    private final String kmsKeyArn;

    private S3Destination(BuilderImpl builder) {
        this.bucketName = builder.bucketName;
        this.keyPrefix = builder.keyPrefix;
        this.kmsKeyArn = builder.kmsKeyArn;
    }

    public String bucketName() {
        return this.bucketName;
    }

    public String keyPrefix() {
        return this.keyPrefix;
    }

    public String kmsKeyArn() {
        return this.kmsKeyArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.bucketName());
        hashCode = 31 * hashCode + Objects.hashCode(this.keyPrefix());
        hashCode = 31 * hashCode + Objects.hashCode(this.kmsKeyArn());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof S3Destination)) {
            return false;
        }
        S3Destination other = (S3Destination)obj;
        return Objects.equals(this.bucketName(), other.bucketName()) && Objects.equals(this.keyPrefix(), other.keyPrefix()) && Objects.equals(this.kmsKeyArn(), other.kmsKeyArn());
    }

    public String toString() {
        return ToString.builder((String)"S3Destination").add("BucketName", (Object)this.bucketName()).add("KeyPrefix", (Object)this.keyPrefix()).add("KmsKeyArn", (Object)this.kmsKeyArn()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "bucketName": {
                return Optional.ofNullable(clazz.cast(this.bucketName()));
            }
            case "keyPrefix": {
                return Optional.ofNullable(clazz.cast(this.keyPrefix()));
            }
            case "kmsKeyArn": {
                return Optional.ofNullable(clazz.cast(this.kmsKeyArn()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<S3Destination, T> g) {
        return obj -> g.apply((S3Destination)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String bucketName;
        private String keyPrefix;
        private String kmsKeyArn;

        private BuilderImpl() {
        }

        private BuilderImpl(S3Destination model) {
            this.bucketName(model.bucketName);
            this.keyPrefix(model.keyPrefix);
            this.kmsKeyArn(model.kmsKeyArn);
        }

        public final String getBucketName() {
            return this.bucketName;
        }

        @Override
        public final Builder bucketName(String bucketName) {
            this.bucketName = bucketName;
            return this;
        }

        public final void setBucketName(String bucketName) {
            this.bucketName = bucketName;
        }

        public final String getKeyPrefix() {
            return this.keyPrefix;
        }

        @Override
        public final Builder keyPrefix(String keyPrefix) {
            this.keyPrefix = keyPrefix;
            return this;
        }

        public final void setKeyPrefix(String keyPrefix) {
            this.keyPrefix = keyPrefix;
        }

        public final String getKmsKeyArn() {
            return this.kmsKeyArn;
        }

        @Override
        public final Builder kmsKeyArn(String kmsKeyArn) {
            this.kmsKeyArn = kmsKeyArn;
            return this;
        }

        public final void setKmsKeyArn(String kmsKeyArn) {
            this.kmsKeyArn = kmsKeyArn;
        }

        public S3Destination build() {
            return new S3Destination(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, S3Destination> {
        public Builder bucketName(String var1);

        public Builder keyPrefix(String var1);

        public Builder kmsKeyArn(String var1);
    }
}

