/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.macie2.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides information about a custom data identifier.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchGetCustomDataIdentifierSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<BatchGetCustomDataIdentifierSummary.Builder, BatchGetCustomDataIdentifierSummary> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("arn")
            .getter(getter(BatchGetCustomDataIdentifierSummary::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()).build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("createdAt")
            .getter(getter(BatchGetCustomDataIdentifierSummary::createdAt))
            .setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<Boolean> DELETED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("deleted").getter(getter(BatchGetCustomDataIdentifierSummary::deleted)).setter(setter(Builder::deleted))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deleted").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(BatchGetCustomDataIdentifierSummary::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("id")
            .getter(getter(BatchGetCustomDataIdentifierSummary::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(BatchGetCustomDataIdentifierSummary::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, CREATED_AT_FIELD,
            DELETED_FIELD, DESCRIPTION_FIELD, ID_FIELD, NAME_FIELD));

    private static final long serialVersionUID = 1L;

    private final String arn;

    private final Instant createdAt;

    private final Boolean deleted;

    private final String description;

    private final String id;

    private final String name;

    private BatchGetCustomDataIdentifierSummary(BuilderImpl builder) {
        this.arn = builder.arn;
        this.createdAt = builder.createdAt;
        this.deleted = builder.deleted;
        this.description = builder.description;
        this.id = builder.id;
        this.name = builder.name;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the custom data identifier.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the custom data identifier.
     */
    public String arn() {
        return arn;
    }

    /**
     * <p>
     * The date and time, in UTC and extended ISO 8601 format, when the custom data identifier was created.
     * </p>
     * 
     * @return The date and time, in UTC and extended ISO 8601 format, when the custom data identifier was created.
     */
    public Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * Specifies whether the custom data identifier was deleted. If you delete a custom data identifier, Amazon Macie
     * doesn't delete it permanently. Instead, it soft deletes the identifier.
     * </p>
     * 
     * @return Specifies whether the custom data identifier was deleted. If you delete a custom data identifier, Amazon
     *         Macie doesn't delete it permanently. Instead, it soft deletes the identifier.
     */
    public Boolean deleted() {
        return deleted;
    }

    /**
     * <p>
     * The custom description of the custom data identifier.
     * </p>
     * 
     * @return The custom description of the custom data identifier.
     */
    public String description() {
        return description;
    }

    /**
     * <p>
     * The unique identifier for the custom data identifier.
     * </p>
     * 
     * @return The unique identifier for the custom data identifier.
     */
    public String id() {
        return id;
    }

    /**
     * <p>
     * The custom name of the custom data identifier.
     * </p>
     * 
     * @return The custom name of the custom data identifier.
     */
    public String name() {
        return name;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(deleted());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchGetCustomDataIdentifierSummary)) {
            return false;
        }
        BatchGetCustomDataIdentifierSummary other = (BatchGetCustomDataIdentifierSummary) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(createdAt(), other.createdAt())
                && Objects.equals(deleted(), other.deleted()) && Objects.equals(description(), other.description())
                && Objects.equals(id(), other.id()) && Objects.equals(name(), other.name());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("BatchGetCustomDataIdentifierSummary").add("Arn", arn()).add("CreatedAt", createdAt())
                .add("Deleted", deleted()).add("Description", description()).add("Id", id()).add("Name", name()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "createdAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "deleted":
            return Optional.ofNullable(clazz.cast(deleted()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "id":
            return Optional.ofNullable(clazz.cast(id()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BatchGetCustomDataIdentifierSummary, T> g) {
        return obj -> g.apply((BatchGetCustomDataIdentifierSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, BatchGetCustomDataIdentifierSummary> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the custom data identifier.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) of the custom data identifier.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The date and time, in UTC and extended ISO 8601 format, when the custom data identifier was created.
         * </p>
         * 
         * @param createdAt
         *        The date and time, in UTC and extended ISO 8601 format, when the custom data identifier was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * Specifies whether the custom data identifier was deleted. If you delete a custom data identifier, Amazon
         * Macie doesn't delete it permanently. Instead, it soft deletes the identifier.
         * </p>
         * 
         * @param deleted
         *        Specifies whether the custom data identifier was deleted. If you delete a custom data identifier,
         *        Amazon Macie doesn't delete it permanently. Instead, it soft deletes the identifier.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deleted(Boolean deleted);

        /**
         * <p>
         * The custom description of the custom data identifier.
         * </p>
         * 
         * @param description
         *        The custom description of the custom data identifier.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The unique identifier for the custom data identifier.
         * </p>
         * 
         * @param id
         *        The unique identifier for the custom data identifier.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The custom name of the custom data identifier.
         * </p>
         * 
         * @param name
         *        The custom name of the custom data identifier.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);
    }

    static final class BuilderImpl implements Builder {
        private String arn;

        private Instant createdAt;

        private Boolean deleted;

        private String description;

        private String id;

        private String name;

        private BuilderImpl() {
        }

        private BuilderImpl(BatchGetCustomDataIdentifierSummary model) {
            arn(model.arn);
            createdAt(model.createdAt);
            deleted(model.deleted);
            description(model.description);
            id(model.id);
            name(model.name);
        }

        public final String getArn() {
            return arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        public final Boolean getDeleted() {
            return deleted;
        }

        @Override
        public final Builder deleted(Boolean deleted) {
            this.deleted = deleted;
            return this;
        }

        public final void setDeleted(Boolean deleted) {
            this.deleted = deleted;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getId() {
            return id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public BatchGetCustomDataIdentifierSummary build() {
            return new BatchGetCustomDataIdentifierSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
