/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.macie2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateCustomDataIdentifierResponse extends Macie2Response implements
        ToCopyableBuilder<CreateCustomDataIdentifierResponse.Builder, CreateCustomDataIdentifierResponse> {
    private static final SdkField<String> CUSTOM_DATA_IDENTIFIER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("customDataIdentifierId").getter(getter(CreateCustomDataIdentifierResponse::customDataIdentifierId))
            .setter(setter(Builder::customDataIdentifierId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("customDataIdentifierId").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(CUSTOM_DATA_IDENTIFIER_ID_FIELD));

    private final String customDataIdentifierId;

    private CreateCustomDataIdentifierResponse(BuilderImpl builder) {
        super(builder);
        this.customDataIdentifierId = builder.customDataIdentifierId;
    }

    /**
     * <p>
     * The unique identifier for the custom data identifier that was created.
     * </p>
     * 
     * @return The unique identifier for the custom data identifier that was created.
     */
    public String customDataIdentifierId() {
        return customDataIdentifierId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(customDataIdentifierId());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateCustomDataIdentifierResponse)) {
            return false;
        }
        CreateCustomDataIdentifierResponse other = (CreateCustomDataIdentifierResponse) obj;
        return Objects.equals(customDataIdentifierId(), other.customDataIdentifierId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("CreateCustomDataIdentifierResponse").add("CustomDataIdentifierId", customDataIdentifierId())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "customDataIdentifierId":
            return Optional.ofNullable(clazz.cast(customDataIdentifierId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateCustomDataIdentifierResponse, T> g) {
        return obj -> g.apply((CreateCustomDataIdentifierResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Macie2Response.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateCustomDataIdentifierResponse> {
        /**
         * <p>
         * The unique identifier for the custom data identifier that was created.
         * </p>
         * 
         * @param customDataIdentifierId
         *        The unique identifier for the custom data identifier that was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customDataIdentifierId(String customDataIdentifierId);
    }

    static final class BuilderImpl extends Macie2Response.BuilderImpl implements Builder {
        private String customDataIdentifierId;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateCustomDataIdentifierResponse model) {
            super(model);
            customDataIdentifierId(model.customDataIdentifierId);
        }

        public final String getCustomDataIdentifierId() {
            return customDataIdentifierId;
        }

        @Override
        public final Builder customDataIdentifierId(String customDataIdentifierId) {
            this.customDataIdentifierId = customDataIdentifierId;
            return this;
        }

        public final void setCustomDataIdentifierId(String customDataIdentifierId) {
            this.customDataIdentifierId = customDataIdentifierId;
        }

        @Override
        public CreateCustomDataIdentifierResponse build() {
            return new CreateCustomDataIdentifierResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
