/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.macie2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies the operator to use in a property-based condition that filters the results of a query for findings.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CriterionAdditionalProperties implements SdkPojo, Serializable,
        ToCopyableBuilder<CriterionAdditionalProperties.Builder, CriterionAdditionalProperties> {
    private static final SdkField<List<String>> EQ_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("eq")
            .getter(getter(CriterionAdditionalProperties::eq))
            .setter(setter(Builder::eq))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eq").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> EQ_EXACT_MATCH_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("eqExactMatch")
            .getter(getter(CriterionAdditionalProperties::eqExactMatch))
            .setter(setter(Builder::eqExactMatch))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eqExactMatch").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Long> GT_FIELD = SdkField.<Long> builder(MarshallingType.LONG).memberName("gt")
            .getter(getter(CriterionAdditionalProperties::gt)).setter(setter(Builder::gt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("gt").build()).build();

    private static final SdkField<Long> GTE_FIELD = SdkField.<Long> builder(MarshallingType.LONG).memberName("gte")
            .getter(getter(CriterionAdditionalProperties::gte)).setter(setter(Builder::gte))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("gte").build()).build();

    private static final SdkField<Long> LT_FIELD = SdkField.<Long> builder(MarshallingType.LONG).memberName("lt")
            .getter(getter(CriterionAdditionalProperties::lt)).setter(setter(Builder::lt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lt").build()).build();

    private static final SdkField<Long> LTE_FIELD = SdkField.<Long> builder(MarshallingType.LONG).memberName("lte")
            .getter(getter(CriterionAdditionalProperties::lte)).setter(setter(Builder::lte))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lte").build()).build();

    private static final SdkField<List<String>> NEQ_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("neq")
            .getter(getter(CriterionAdditionalProperties::neq))
            .setter(setter(Builder::neq))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("neq").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EQ_FIELD,
            EQ_EXACT_MATCH_FIELD, GT_FIELD, GTE_FIELD, LT_FIELD, LTE_FIELD, NEQ_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<String> eq;

    private final List<String> eqExactMatch;

    private final Long gt;

    private final Long gte;

    private final Long lt;

    private final Long lte;

    private final List<String> neq;

    private CriterionAdditionalProperties(BuilderImpl builder) {
        this.eq = builder.eq;
        this.eqExactMatch = builder.eqExactMatch;
        this.gt = builder.gt;
        this.gte = builder.gte;
        this.lt = builder.lt;
        this.lte = builder.lte;
        this.neq = builder.neq;
    }

    /**
     * Returns true if the Eq property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasEq() {
        return eq != null && !(eq instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An equal to condition to apply to a specified property value for findings.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasEq()} to see if a value was sent in this field.
     * </p>
     * 
     * @return An equal to condition to apply to a specified property value for findings.
     */
    public List<String> eq() {
        return eq;
    }

    /**
     * Returns true if the EqExactMatch property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasEqExactMatch() {
        return eqExactMatch != null && !(eqExactMatch instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A condition that requires an array field to exactly match the specified property values. You can use this
     * operator with the following properties: customDataIdentifiers.detections.arn,
     * customDataIdentifiers.detections.name, resourcesAffected.s3Bucket.tags.key,
     * resourcesAffected.s3Bucket.tags.value, resourcesAffected.s3Object.tags.key,
     * resourcesAffected.s3Object.tags.value, sensitiveData.category, and sensitiveData.detections.type.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasEqExactMatch()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A condition that requires an array field to exactly match the specified property values. You can use this
     *         operator with the following properties: customDataIdentifiers.detections.arn,
     *         customDataIdentifiers.detections.name, resourcesAffected.s3Bucket.tags.key,
     *         resourcesAffected.s3Bucket.tags.value, resourcesAffected.s3Object.tags.key,
     *         resourcesAffected.s3Object.tags.value, sensitiveData.category, and sensitiveData.detections.type.
     */
    public List<String> eqExactMatch() {
        return eqExactMatch;
    }

    /**
     * <p>
     * A greater than condition to apply to a specified property value for findings.
     * </p>
     * 
     * @return A greater than condition to apply to a specified property value for findings.
     */
    public Long gt() {
        return gt;
    }

    /**
     * <p>
     * A greater than or equal to condition to apply to a specified property value for findings.
     * </p>
     * 
     * @return A greater than or equal to condition to apply to a specified property value for findings.
     */
    public Long gte() {
        return gte;
    }

    /**
     * <p>
     * A less than condition to apply to a specified property value for findings.
     * </p>
     * 
     * @return A less than condition to apply to a specified property value for findings.
     */
    public Long lt() {
        return lt;
    }

    /**
     * <p>
     * A less than or equal to condition to apply to a specified property value for findings.
     * </p>
     * 
     * @return A less than or equal to condition to apply to a specified property value for findings.
     */
    public Long lte() {
        return lte;
    }

    /**
     * Returns true if the Neq property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasNeq() {
        return neq != null && !(neq instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A not equal to condition to apply to a specified property value for findings.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasNeq()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A not equal to condition to apply to a specified property value for findings.
     */
    public List<String> neq() {
        return neq;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasEq() ? eq() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasEqExactMatch() ? eqExactMatch() : null);
        hashCode = 31 * hashCode + Objects.hashCode(gt());
        hashCode = 31 * hashCode + Objects.hashCode(gte());
        hashCode = 31 * hashCode + Objects.hashCode(lt());
        hashCode = 31 * hashCode + Objects.hashCode(lte());
        hashCode = 31 * hashCode + Objects.hashCode(hasNeq() ? neq() : null);
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CriterionAdditionalProperties)) {
            return false;
        }
        CriterionAdditionalProperties other = (CriterionAdditionalProperties) obj;
        return hasEq() == other.hasEq() && Objects.equals(eq(), other.eq()) && hasEqExactMatch() == other.hasEqExactMatch()
                && Objects.equals(eqExactMatch(), other.eqExactMatch()) && Objects.equals(gt(), other.gt())
                && Objects.equals(gte(), other.gte()) && Objects.equals(lt(), other.lt()) && Objects.equals(lte(), other.lte())
                && hasNeq() == other.hasNeq() && Objects.equals(neq(), other.neq());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("CriterionAdditionalProperties").add("Eq", hasEq() ? eq() : null)
                .add("EqExactMatch", hasEqExactMatch() ? eqExactMatch() : null).add("Gt", gt()).add("Gte", gte()).add("Lt", lt())
                .add("Lte", lte()).add("Neq", hasNeq() ? neq() : null).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "eq":
            return Optional.ofNullable(clazz.cast(eq()));
        case "eqExactMatch":
            return Optional.ofNullable(clazz.cast(eqExactMatch()));
        case "gt":
            return Optional.ofNullable(clazz.cast(gt()));
        case "gte":
            return Optional.ofNullable(clazz.cast(gte()));
        case "lt":
            return Optional.ofNullable(clazz.cast(lt()));
        case "lte":
            return Optional.ofNullable(clazz.cast(lte()));
        case "neq":
            return Optional.ofNullable(clazz.cast(neq()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CriterionAdditionalProperties, T> g) {
        return obj -> g.apply((CriterionAdditionalProperties) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CriterionAdditionalProperties> {
        /**
         * <p>
         * An equal to condition to apply to a specified property value for findings.
         * </p>
         * 
         * @param eq
         *        An equal to condition to apply to a specified property value for findings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eq(Collection<String> eq);

        /**
         * <p>
         * An equal to condition to apply to a specified property value for findings.
         * </p>
         * 
         * @param eq
         *        An equal to condition to apply to a specified property value for findings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eq(String... eq);

        /**
         * <p>
         * A condition that requires an array field to exactly match the specified property values. You can use this
         * operator with the following properties: customDataIdentifiers.detections.arn,
         * customDataIdentifiers.detections.name, resourcesAffected.s3Bucket.tags.key,
         * resourcesAffected.s3Bucket.tags.value, resourcesAffected.s3Object.tags.key,
         * resourcesAffected.s3Object.tags.value, sensitiveData.category, and sensitiveData.detections.type.
         * </p>
         * 
         * @param eqExactMatch
         *        A condition that requires an array field to exactly match the specified property values. You can use
         *        this operator with the following properties: customDataIdentifiers.detections.arn,
         *        customDataIdentifiers.detections.name, resourcesAffected.s3Bucket.tags.key,
         *        resourcesAffected.s3Bucket.tags.value, resourcesAffected.s3Object.tags.key,
         *        resourcesAffected.s3Object.tags.value, sensitiveData.category, and sensitiveData.detections.type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eqExactMatch(Collection<String> eqExactMatch);

        /**
         * <p>
         * A condition that requires an array field to exactly match the specified property values. You can use this
         * operator with the following properties: customDataIdentifiers.detections.arn,
         * customDataIdentifiers.detections.name, resourcesAffected.s3Bucket.tags.key,
         * resourcesAffected.s3Bucket.tags.value, resourcesAffected.s3Object.tags.key,
         * resourcesAffected.s3Object.tags.value, sensitiveData.category, and sensitiveData.detections.type.
         * </p>
         * 
         * @param eqExactMatch
         *        A condition that requires an array field to exactly match the specified property values. You can use
         *        this operator with the following properties: customDataIdentifiers.detections.arn,
         *        customDataIdentifiers.detections.name, resourcesAffected.s3Bucket.tags.key,
         *        resourcesAffected.s3Bucket.tags.value, resourcesAffected.s3Object.tags.key,
         *        resourcesAffected.s3Object.tags.value, sensitiveData.category, and sensitiveData.detections.type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eqExactMatch(String... eqExactMatch);

        /**
         * <p>
         * A greater than condition to apply to a specified property value for findings.
         * </p>
         * 
         * @param gt
         *        A greater than condition to apply to a specified property value for findings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder gt(Long gt);

        /**
         * <p>
         * A greater than or equal to condition to apply to a specified property value for findings.
         * </p>
         * 
         * @param gte
         *        A greater than or equal to condition to apply to a specified property value for findings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder gte(Long gte);

        /**
         * <p>
         * A less than condition to apply to a specified property value for findings.
         * </p>
         * 
         * @param lt
         *        A less than condition to apply to a specified property value for findings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lt(Long lt);

        /**
         * <p>
         * A less than or equal to condition to apply to a specified property value for findings.
         * </p>
         * 
         * @param lte
         *        A less than or equal to condition to apply to a specified property value for findings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lte(Long lte);

        /**
         * <p>
         * A not equal to condition to apply to a specified property value for findings.
         * </p>
         * 
         * @param neq
         *        A not equal to condition to apply to a specified property value for findings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder neq(Collection<String> neq);

        /**
         * <p>
         * A not equal to condition to apply to a specified property value for findings.
         * </p>
         * 
         * @param neq
         *        A not equal to condition to apply to a specified property value for findings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder neq(String... neq);
    }

    static final class BuilderImpl implements Builder {
        private List<String> eq = DefaultSdkAutoConstructList.getInstance();

        private List<String> eqExactMatch = DefaultSdkAutoConstructList.getInstance();

        private Long gt;

        private Long gte;

        private Long lt;

        private Long lte;

        private List<String> neq = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CriterionAdditionalProperties model) {
            eq(model.eq);
            eqExactMatch(model.eqExactMatch);
            gt(model.gt);
            gte(model.gte);
            lt(model.lt);
            lte(model.lte);
            neq(model.neq);
        }

        public final Collection<String> getEq() {
            if (eq instanceof SdkAutoConstructList) {
                return null;
            }
            return eq;
        }

        @Override
        public final Builder eq(Collection<String> eq) {
            this.eq = ___listOf__stringCopier.copy(eq);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder eq(String... eq) {
            eq(Arrays.asList(eq));
            return this;
        }

        public final void setEq(Collection<String> eq) {
            this.eq = ___listOf__stringCopier.copy(eq);
        }

        public final Collection<String> getEqExactMatch() {
            if (eqExactMatch instanceof SdkAutoConstructList) {
                return null;
            }
            return eqExactMatch;
        }

        @Override
        public final Builder eqExactMatch(Collection<String> eqExactMatch) {
            this.eqExactMatch = ___listOf__stringCopier.copy(eqExactMatch);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder eqExactMatch(String... eqExactMatch) {
            eqExactMatch(Arrays.asList(eqExactMatch));
            return this;
        }

        public final void setEqExactMatch(Collection<String> eqExactMatch) {
            this.eqExactMatch = ___listOf__stringCopier.copy(eqExactMatch);
        }

        public final Long getGt() {
            return gt;
        }

        @Override
        public final Builder gt(Long gt) {
            this.gt = gt;
            return this;
        }

        public final void setGt(Long gt) {
            this.gt = gt;
        }

        public final Long getGte() {
            return gte;
        }

        @Override
        public final Builder gte(Long gte) {
            this.gte = gte;
            return this;
        }

        public final void setGte(Long gte) {
            this.gte = gte;
        }

        public final Long getLt() {
            return lt;
        }

        @Override
        public final Builder lt(Long lt) {
            this.lt = lt;
            return this;
        }

        public final void setLt(Long lt) {
            this.lt = lt;
        }

        public final Long getLte() {
            return lte;
        }

        @Override
        public final Builder lte(Long lte) {
            this.lte = lte;
            return this;
        }

        public final void setLte(Long lte) {
            this.lte = lte;
        }

        public final Collection<String> getNeq() {
            if (neq instanceof SdkAutoConstructList) {
                return null;
            }
            return neq;
        }

        @Override
        public final Builder neq(Collection<String> neq) {
            this.neq = ___listOf__stringCopier.copy(neq);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder neq(String... neq) {
            neq(Arrays.asList(neq));
            return this;
        }

        public final void setNeq(Collection<String> neq) {
            this.neq = ___listOf__stringCopier.copy(neq);
        }

        @Override
        public CriterionAdditionalProperties build() {
            return new CriterionAdditionalProperties(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
