/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.macie2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies the recurrence pattern for running a classification job.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class JobScheduleFrequency implements SdkPojo, Serializable,
        ToCopyableBuilder<JobScheduleFrequency.Builder, JobScheduleFrequency> {
    private static final SdkField<DailySchedule> DAILY_SCHEDULE_FIELD = SdkField
            .<DailySchedule> builder(MarshallingType.SDK_POJO).memberName("dailySchedule")
            .getter(getter(JobScheduleFrequency::dailySchedule)).setter(setter(Builder::dailySchedule))
            .constructor(DailySchedule::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dailySchedule").build()).build();

    private static final SdkField<MonthlySchedule> MONTHLY_SCHEDULE_FIELD = SdkField
            .<MonthlySchedule> builder(MarshallingType.SDK_POJO).memberName("monthlySchedule")
            .getter(getter(JobScheduleFrequency::monthlySchedule)).setter(setter(Builder::monthlySchedule))
            .constructor(MonthlySchedule::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("monthlySchedule").build()).build();

    private static final SdkField<WeeklySchedule> WEEKLY_SCHEDULE_FIELD = SdkField
            .<WeeklySchedule> builder(MarshallingType.SDK_POJO).memberName("weeklySchedule")
            .getter(getter(JobScheduleFrequency::weeklySchedule)).setter(setter(Builder::weeklySchedule))
            .constructor(WeeklySchedule::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("weeklySchedule").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DAILY_SCHEDULE_FIELD,
            MONTHLY_SCHEDULE_FIELD, WEEKLY_SCHEDULE_FIELD));

    private static final long serialVersionUID = 1L;

    private final DailySchedule dailySchedule;

    private final MonthlySchedule monthlySchedule;

    private final WeeklySchedule weeklySchedule;

    private JobScheduleFrequency(BuilderImpl builder) {
        this.dailySchedule = builder.dailySchedule;
        this.monthlySchedule = builder.monthlySchedule;
        this.weeklySchedule = builder.weeklySchedule;
    }

    /**
     * <p>
     * Specifies a daily recurrence pattern for running the job.
     * </p>
     * 
     * @return Specifies a daily recurrence pattern for running the job.
     */
    public DailySchedule dailySchedule() {
        return dailySchedule;
    }

    /**
     * <p>
     * Specifies a monthly recurrence pattern for running the job.
     * </p>
     * 
     * @return Specifies a monthly recurrence pattern for running the job.
     */
    public MonthlySchedule monthlySchedule() {
        return monthlySchedule;
    }

    /**
     * <p>
     * Specifies a weekly recurrence pattern for running the job.
     * </p>
     * 
     * @return Specifies a weekly recurrence pattern for running the job.
     */
    public WeeklySchedule weeklySchedule() {
        return weeklySchedule;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(dailySchedule());
        hashCode = 31 * hashCode + Objects.hashCode(monthlySchedule());
        hashCode = 31 * hashCode + Objects.hashCode(weeklySchedule());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof JobScheduleFrequency)) {
            return false;
        }
        JobScheduleFrequency other = (JobScheduleFrequency) obj;
        return Objects.equals(dailySchedule(), other.dailySchedule())
                && Objects.equals(monthlySchedule(), other.monthlySchedule())
                && Objects.equals(weeklySchedule(), other.weeklySchedule());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("JobScheduleFrequency").add("DailySchedule", dailySchedule())
                .add("MonthlySchedule", monthlySchedule()).add("WeeklySchedule", weeklySchedule()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "dailySchedule":
            return Optional.ofNullable(clazz.cast(dailySchedule()));
        case "monthlySchedule":
            return Optional.ofNullable(clazz.cast(monthlySchedule()));
        case "weeklySchedule":
            return Optional.ofNullable(clazz.cast(weeklySchedule()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<JobScheduleFrequency, T> g) {
        return obj -> g.apply((JobScheduleFrequency) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, JobScheduleFrequency> {
        /**
         * <p>
         * Specifies a daily recurrence pattern for running the job.
         * </p>
         * 
         * @param dailySchedule
         *        Specifies a daily recurrence pattern for running the job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dailySchedule(DailySchedule dailySchedule);

        /**
         * <p>
         * Specifies a daily recurrence pattern for running the job.
         * </p>
         * This is a convenience that creates an instance of the {@link DailySchedule.Builder} avoiding the need to
         * create one manually via {@link DailySchedule#builder()}.
         *
         * When the {@link Consumer} completes, {@link DailySchedule.Builder#build()} is called immediately and its
         * result is passed to {@link #dailySchedule(DailySchedule)}.
         * 
         * @param dailySchedule
         *        a consumer that will call methods on {@link DailySchedule.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dailySchedule(DailySchedule)
         */
        default Builder dailySchedule(Consumer<DailySchedule.Builder> dailySchedule) {
            return dailySchedule(DailySchedule.builder().applyMutation(dailySchedule).build());
        }

        /**
         * <p>
         * Specifies a monthly recurrence pattern for running the job.
         * </p>
         * 
         * @param monthlySchedule
         *        Specifies a monthly recurrence pattern for running the job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder monthlySchedule(MonthlySchedule monthlySchedule);

        /**
         * <p>
         * Specifies a monthly recurrence pattern for running the job.
         * </p>
         * This is a convenience that creates an instance of the {@link MonthlySchedule.Builder} avoiding the need to
         * create one manually via {@link MonthlySchedule#builder()}.
         *
         * When the {@link Consumer} completes, {@link MonthlySchedule.Builder#build()} is called immediately and its
         * result is passed to {@link #monthlySchedule(MonthlySchedule)}.
         * 
         * @param monthlySchedule
         *        a consumer that will call methods on {@link MonthlySchedule.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #monthlySchedule(MonthlySchedule)
         */
        default Builder monthlySchedule(Consumer<MonthlySchedule.Builder> monthlySchedule) {
            return monthlySchedule(MonthlySchedule.builder().applyMutation(monthlySchedule).build());
        }

        /**
         * <p>
         * Specifies a weekly recurrence pattern for running the job.
         * </p>
         * 
         * @param weeklySchedule
         *        Specifies a weekly recurrence pattern for running the job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder weeklySchedule(WeeklySchedule weeklySchedule);

        /**
         * <p>
         * Specifies a weekly recurrence pattern for running the job.
         * </p>
         * This is a convenience that creates an instance of the {@link WeeklySchedule.Builder} avoiding the need to
         * create one manually via {@link WeeklySchedule#builder()}.
         *
         * When the {@link Consumer} completes, {@link WeeklySchedule.Builder#build()} is called immediately and its
         * result is passed to {@link #weeklySchedule(WeeklySchedule)}.
         * 
         * @param weeklySchedule
         *        a consumer that will call methods on {@link WeeklySchedule.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #weeklySchedule(WeeklySchedule)
         */
        default Builder weeklySchedule(Consumer<WeeklySchedule.Builder> weeklySchedule) {
            return weeklySchedule(WeeklySchedule.builder().applyMutation(weeklySchedule).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private DailySchedule dailySchedule;

        private MonthlySchedule monthlySchedule;

        private WeeklySchedule weeklySchedule;

        private BuilderImpl() {
        }

        private BuilderImpl(JobScheduleFrequency model) {
            dailySchedule(model.dailySchedule);
            monthlySchedule(model.monthlySchedule);
            weeklySchedule(model.weeklySchedule);
        }

        public final DailySchedule.Builder getDailySchedule() {
            return dailySchedule != null ? dailySchedule.toBuilder() : null;
        }

        @Override
        public final Builder dailySchedule(DailySchedule dailySchedule) {
            this.dailySchedule = dailySchedule;
            return this;
        }

        public final void setDailySchedule(DailySchedule.BuilderImpl dailySchedule) {
            this.dailySchedule = dailySchedule != null ? dailySchedule.build() : null;
        }

        public final MonthlySchedule.Builder getMonthlySchedule() {
            return monthlySchedule != null ? monthlySchedule.toBuilder() : null;
        }

        @Override
        public final Builder monthlySchedule(MonthlySchedule monthlySchedule) {
            this.monthlySchedule = monthlySchedule;
            return this;
        }

        public final void setMonthlySchedule(MonthlySchedule.BuilderImpl monthlySchedule) {
            this.monthlySchedule = monthlySchedule != null ? monthlySchedule.build() : null;
        }

        public final WeeklySchedule.Builder getWeeklySchedule() {
            return weeklySchedule != null ? weeklySchedule.toBuilder() : null;
        }

        @Override
        public final Builder weeklySchedule(WeeklySchedule weeklySchedule) {
            this.weeklySchedule = weeklySchedule;
            return this;
        }

        public final void setWeeklySchedule(WeeklySchedule.BuilderImpl weeklySchedule) {
            this.weeklySchedule = weeklySchedule != null ? weeklySchedule.build() : null;
        }

        @Override
        public JobScheduleFrequency build() {
            return new JobScheduleFrequency(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
