/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.macie2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides the details of a policy finding.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PolicyDetails implements SdkPojo, Serializable, ToCopyableBuilder<PolicyDetails.Builder, PolicyDetails> {
    private static final SdkField<FindingAction> ACTION_FIELD = SdkField.<FindingAction> builder(MarshallingType.SDK_POJO)
            .memberName("action").getter(getter(PolicyDetails::action)).setter(setter(Builder::action))
            .constructor(FindingAction::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("action").build()).build();

    private static final SdkField<FindingActor> ACTOR_FIELD = SdkField.<FindingActor> builder(MarshallingType.SDK_POJO)
            .memberName("actor").getter(getter(PolicyDetails::actor)).setter(setter(Builder::actor))
            .constructor(FindingActor::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("actor").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTION_FIELD, ACTOR_FIELD));

    private static final long serialVersionUID = 1L;

    private final FindingAction action;

    private final FindingActor actor;

    private PolicyDetails(BuilderImpl builder) {
        this.action = builder.action;
        this.actor = builder.actor;
    }

    /**
     * <p>
     * The action that produced the finding.
     * </p>
     * 
     * @return The action that produced the finding.
     */
    public FindingAction action() {
        return action;
    }

    /**
     * <p>
     * The entity that performed the action that produced the finding.
     * </p>
     * 
     * @return The entity that performed the action that produced the finding.
     */
    public FindingActor actor() {
        return actor;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(action());
        hashCode = 31 * hashCode + Objects.hashCode(actor());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PolicyDetails)) {
            return false;
        }
        PolicyDetails other = (PolicyDetails) obj;
        return Objects.equals(action(), other.action()) && Objects.equals(actor(), other.actor());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("PolicyDetails").add("Action", action()).add("Actor", actor()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "action":
            return Optional.ofNullable(clazz.cast(action()));
        case "actor":
            return Optional.ofNullable(clazz.cast(actor()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PolicyDetails, T> g) {
        return obj -> g.apply((PolicyDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PolicyDetails> {
        /**
         * <p>
         * The action that produced the finding.
         * </p>
         * 
         * @param action
         *        The action that produced the finding.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder action(FindingAction action);

        /**
         * <p>
         * The action that produced the finding.
         * </p>
         * This is a convenience that creates an instance of the {@link FindingAction.Builder} avoiding the need to
         * create one manually via {@link FindingAction#builder()}.
         *
         * When the {@link Consumer} completes, {@link FindingAction.Builder#build()} is called immediately and its
         * result is passed to {@link #action(FindingAction)}.
         * 
         * @param action
         *        a consumer that will call methods on {@link FindingAction.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #action(FindingAction)
         */
        default Builder action(Consumer<FindingAction.Builder> action) {
            return action(FindingAction.builder().applyMutation(action).build());
        }

        /**
         * <p>
         * The entity that performed the action that produced the finding.
         * </p>
         * 
         * @param actor
         *        The entity that performed the action that produced the finding.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder actor(FindingActor actor);

        /**
         * <p>
         * The entity that performed the action that produced the finding.
         * </p>
         * This is a convenience that creates an instance of the {@link FindingActor.Builder} avoiding the need to
         * create one manually via {@link FindingActor#builder()}.
         *
         * When the {@link Consumer} completes, {@link FindingActor.Builder#build()} is called immediately and its
         * result is passed to {@link #actor(FindingActor)}.
         * 
         * @param actor
         *        a consumer that will call methods on {@link FindingActor.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #actor(FindingActor)
         */
        default Builder actor(Consumer<FindingActor.Builder> actor) {
            return actor(FindingActor.builder().applyMutation(actor).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private FindingAction action;

        private FindingActor actor;

        private BuilderImpl() {
        }

        private BuilderImpl(PolicyDetails model) {
            action(model.action);
            actor(model.actor);
        }

        public final FindingAction.Builder getAction() {
            return action != null ? action.toBuilder() : null;
        }

        @Override
        public final Builder action(FindingAction action) {
            this.action = action;
            return this;
        }

        public final void setAction(FindingAction.BuilderImpl action) {
            this.action = action != null ? action.build() : null;
        }

        public final FindingActor.Builder getActor() {
            return actor != null ? actor.toBuilder() : null;
        }

        @Override
        public final Builder actor(FindingActor actor) {
            this.actor = actor;
            return this;
        }

        public final void setActor(FindingActor.BuilderImpl actor) {
            this.actor = actor != null ? actor.build() : null;
        }

        @Override
        public PolicyDetails build() {
            return new PolicyDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
