/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.macie2.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum FindingType {
    SENSITIVE_DATA_S3_OBJECT_MULTIPLE("SensitiveData:S3Object/Multiple"),
    SENSITIVE_DATA_S3_OBJECT_FINANCIAL("SensitiveData:S3Object/Financial"),
    SENSITIVE_DATA_S3_OBJECT_PERSONAL("SensitiveData:S3Object/Personal"),
    SENSITIVE_DATA_S3_OBJECT_CREDENTIALS("SensitiveData:S3Object/Credentials"),
    SENSITIVE_DATA_S3_OBJECT_CUSTOM_IDENTIFIER("SensitiveData:S3Object/CustomIdentifier"),
    POLICY_IAM_USER_S3_BUCKET_PUBLIC("Policy:IAMUser/S3BucketPublic"),
    POLICY_IAM_USER_S3_BUCKET_SHARED_EXTERNALLY("Policy:IAMUser/S3BucketSharedExternally"),
    POLICY_IAM_USER_S3_BUCKET_REPLICATED_EXTERNALLY("Policy:IAMUser/S3BucketReplicatedExternally"),
    POLICY_IAM_USER_S3_BUCKET_ENCRYPTION_DISABLED("Policy:IAMUser/S3BucketEncryptionDisabled"),
    POLICY_IAM_USER_S3_BLOCK_PUBLIC_ACCESS_DISABLED("Policy:IAMUser/S3BlockPublicAccessDisabled"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private FindingType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static FindingType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(FindingType.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<FindingType> knownValues() {
        return Stream.of(FindingType.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

