/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.macie2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateCustomDataIdentifierRequest extends Macie2Request implements
        ToCopyableBuilder<CreateCustomDataIdentifierRequest.Builder, CreateCustomDataIdentifierRequest> {
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("clientToken")
            .getter(getter(CreateCustomDataIdentifierRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(CreateCustomDataIdentifierRequest::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<List<String>> IGNORE_WORDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("ignoreWords")
            .getter(getter(CreateCustomDataIdentifierRequest::ignoreWords))
            .setter(setter(Builder::ignoreWords))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ignoreWords").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> KEYWORDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("keywords")
            .getter(getter(CreateCustomDataIdentifierRequest::keywords))
            .setter(setter(Builder::keywords))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("keywords").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Integer> MAXIMUM_MATCH_DISTANCE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("maximumMatchDistance").getter(getter(CreateCustomDataIdentifierRequest::maximumMatchDistance))
            .setter(setter(Builder::maximumMatchDistance))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maximumMatchDistance").build())
            .build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(CreateCustomDataIdentifierRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> REGEX_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("regex")
            .getter(getter(CreateCustomDataIdentifierRequest::regex)).setter(setter(Builder::regex))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("regex").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("tags")
            .getter(getter(CreateCustomDataIdentifierRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_TOKEN_FIELD,
            DESCRIPTION_FIELD, IGNORE_WORDS_FIELD, KEYWORDS_FIELD, MAXIMUM_MATCH_DISTANCE_FIELD, NAME_FIELD, REGEX_FIELD,
            TAGS_FIELD));

    private final String clientToken;

    private final String description;

    private final List<String> ignoreWords;

    private final List<String> keywords;

    private final Integer maximumMatchDistance;

    private final String name;

    private final String regex;

    private final Map<String, String> tags;

    private CreateCustomDataIdentifierRequest(BuilderImpl builder) {
        super(builder);
        this.clientToken = builder.clientToken;
        this.description = builder.description;
        this.ignoreWords = builder.ignoreWords;
        this.keywords = builder.keywords;
        this.maximumMatchDistance = builder.maximumMatchDistance;
        this.name = builder.name;
        this.regex = builder.regex;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * A unique, case-sensitive token that you provide to ensure the idempotency of the request.
     * </p>
     * 
     * @return A unique, case-sensitive token that you provide to ensure the idempotency of the request.
     */
    public final String clientToken() {
        return clientToken;
    }

    /**
     * <p>
     * A custom description of the custom data identifier. The description can contain as many as 512 characters.
     * </p>
     * <p>
     * We strongly recommend that you avoid including any sensitive data in the description of a custom data identifier.
     * Other users of your account might be able to see the identifier's description, depending on the actions that
     * they're allowed to perform in Amazon Macie.
     * </p>
     * 
     * @return A custom description of the custom data identifier. The description can contain as many as 512
     *         characters.</p>
     *         <p>
     *         We strongly recommend that you avoid including any sensitive data in the description of a custom data
     *         identifier. Other users of your account might be able to see the identifier's description, depending on
     *         the actions that they're allowed to perform in Amazon Macie.
     */
    public final String description() {
        return description;
    }

    /**
     * Returns true if the IgnoreWords property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasIgnoreWords() {
        return ignoreWords != null && !(ignoreWords instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array that lists specific character sequences (ignore words) to exclude from the results. If the text matched
     * by the regular expression is the same as any string in this array, Amazon Macie ignores it. The array can contain
     * as many as 10 ignore words. Each ignore word can contain 4 - 90 characters. Ignore words are case sensitive.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasIgnoreWords()} to see if a value was sent in this field.
     * </p>
     * 
     * @return An array that lists specific character sequences (ignore words) to exclude from the results. If the text
     *         matched by the regular expression is the same as any string in this array, Amazon Macie ignores it. The
     *         array can contain as many as 10 ignore words. Each ignore word can contain 4 - 90 characters. Ignore
     *         words are case sensitive.
     */
    public final List<String> ignoreWords() {
        return ignoreWords;
    }

    /**
     * Returns true if the Keywords property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasKeywords() {
        return keywords != null && !(keywords instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array that lists specific character sequences (keywords), one of which must be within proximity
     * (maximumMatchDistance) of the regular expression to match. The array can contain as many as 50 keywords. Each
     * keyword can contain 4 - 90 characters. Keywords aren't case sensitive.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasKeywords()} to see if a value was sent in this field.
     * </p>
     * 
     * @return An array that lists specific character sequences (keywords), one of which must be within proximity
     *         (maximumMatchDistance) of the regular expression to match. The array can contain as many as 50 keywords.
     *         Each keyword can contain 4 - 90 characters. Keywords aren't case sensitive.
     */
    public final List<String> keywords() {
        return keywords;
    }

    /**
     * <p>
     * The maximum number of characters that can exist between text that matches the regex pattern and the character
     * sequences specified by the keywords array. Macie includes or excludes a result based on the proximity of a
     * keyword to text that matches the regex pattern. The distance can be 1 - 300 characters. The default value is 50.
     * </p>
     * 
     * @return The maximum number of characters that can exist between text that matches the regex pattern and the
     *         character sequences specified by the keywords array. Macie includes or excludes a result based on the
     *         proximity of a keyword to text that matches the regex pattern. The distance can be 1 - 300 characters.
     *         The default value is 50.
     */
    public final Integer maximumMatchDistance() {
        return maximumMatchDistance;
    }

    /**
     * <p>
     * A custom name for the custom data identifier. The name can contain as many as 128 characters.
     * </p>
     * <p>
     * We strongly recommend that you avoid including any sensitive data in the name of a custom data identifier. Other
     * users of your account might be able to see the identifier's name, depending on the actions that they're allowed
     * to perform in Amazon Macie.
     * </p>
     * 
     * @return A custom name for the custom data identifier. The name can contain as many as 128 characters.</p>
     *         <p>
     *         We strongly recommend that you avoid including any sensitive data in the name of a custom data
     *         identifier. Other users of your account might be able to see the identifier's name, depending on the
     *         actions that they're allowed to perform in Amazon Macie.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The regular expression (<i>regex</i>) that defines the pattern to match. The expression can contain as many as
     * 512 characters.
     * </p>
     * 
     * @return The regular expression (<i>regex</i>) that defines the pattern to match. The expression can contain as
     *         many as 512 characters.
     */
    public final String regex() {
        return regex;
    }

    /**
     * Returns true if the Tags property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * A map of key-value pairs that specifies the tags to associate with the custom data identifier.
     * </p>
     * <p>
     * A custom data identifier can have a maximum of 50 tags. Each tag consists of a tag key and an associated tag
     * value. The maximum length of a tag key is 128 characters. The maximum length of a tag value is 256 characters.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTags()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A map of key-value pairs that specifies the tags to associate with the custom data identifier.</p>
     *         <p>
     *         A custom data identifier can have a maximum of 50 tags. Each tag consists of a tag key and an associated
     *         tag value. The maximum length of a tag key is 128 characters. The maximum length of a tag value is 256
     *         characters.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(hasIgnoreWords() ? ignoreWords() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasKeywords() ? keywords() : null);
        hashCode = 31 * hashCode + Objects.hashCode(maximumMatchDistance());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(regex());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateCustomDataIdentifierRequest)) {
            return false;
        }
        CreateCustomDataIdentifierRequest other = (CreateCustomDataIdentifierRequest) obj;
        return Objects.equals(clientToken(), other.clientToken()) && Objects.equals(description(), other.description())
                && hasIgnoreWords() == other.hasIgnoreWords() && Objects.equals(ignoreWords(), other.ignoreWords())
                && hasKeywords() == other.hasKeywords() && Objects.equals(keywords(), other.keywords())
                && Objects.equals(maximumMatchDistance(), other.maximumMatchDistance()) && Objects.equals(name(), other.name())
                && Objects.equals(regex(), other.regex()) && hasTags() == other.hasTags() && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateCustomDataIdentifierRequest").add("ClientToken", clientToken())
                .add("Description", description()).add("IgnoreWords", hasIgnoreWords() ? ignoreWords() : null)
                .add("Keywords", hasKeywords() ? keywords() : null).add("MaximumMatchDistance", maximumMatchDistance())
                .add("Name", name()).add("Regex", regex()).add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "clientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "ignoreWords":
            return Optional.ofNullable(clazz.cast(ignoreWords()));
        case "keywords":
            return Optional.ofNullable(clazz.cast(keywords()));
        case "maximumMatchDistance":
            return Optional.ofNullable(clazz.cast(maximumMatchDistance()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "regex":
            return Optional.ofNullable(clazz.cast(regex()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateCustomDataIdentifierRequest, T> g) {
        return obj -> g.apply((CreateCustomDataIdentifierRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Macie2Request.Builder, SdkPojo, CopyableBuilder<Builder, CreateCustomDataIdentifierRequest> {
        /**
         * <p>
         * A unique, case-sensitive token that you provide to ensure the idempotency of the request.
         * </p>
         * 
         * @param clientToken
         *        A unique, case-sensitive token that you provide to ensure the idempotency of the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * A custom description of the custom data identifier. The description can contain as many as 512 characters.
         * </p>
         * <p>
         * We strongly recommend that you avoid including any sensitive data in the description of a custom data
         * identifier. Other users of your account might be able to see the identifier's description, depending on the
         * actions that they're allowed to perform in Amazon Macie.
         * </p>
         * 
         * @param description
         *        A custom description of the custom data identifier. The description can contain as many as 512
         *        characters.</p>
         *        <p>
         *        We strongly recommend that you avoid including any sensitive data in the description of a custom data
         *        identifier. Other users of your account might be able to see the identifier's description, depending
         *        on the actions that they're allowed to perform in Amazon Macie.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * An array that lists specific character sequences (ignore words) to exclude from the results. If the text
         * matched by the regular expression is the same as any string in this array, Amazon Macie ignores it. The array
         * can contain as many as 10 ignore words. Each ignore word can contain 4 - 90 characters. Ignore words are case
         * sensitive.
         * </p>
         * 
         * @param ignoreWords
         *        An array that lists specific character sequences (ignore words) to exclude from the results. If the
         *        text matched by the regular expression is the same as any string in this array, Amazon Macie ignores
         *        it. The array can contain as many as 10 ignore words. Each ignore word can contain 4 - 90 characters.
         *        Ignore words are case sensitive.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ignoreWords(Collection<String> ignoreWords);

        /**
         * <p>
         * An array that lists specific character sequences (ignore words) to exclude from the results. If the text
         * matched by the regular expression is the same as any string in this array, Amazon Macie ignores it. The array
         * can contain as many as 10 ignore words. Each ignore word can contain 4 - 90 characters. Ignore words are case
         * sensitive.
         * </p>
         * 
         * @param ignoreWords
         *        An array that lists specific character sequences (ignore words) to exclude from the results. If the
         *        text matched by the regular expression is the same as any string in this array, Amazon Macie ignores
         *        it. The array can contain as many as 10 ignore words. Each ignore word can contain 4 - 90 characters.
         *        Ignore words are case sensitive.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ignoreWords(String... ignoreWords);

        /**
         * <p>
         * An array that lists specific character sequences (keywords), one of which must be within proximity
         * (maximumMatchDistance) of the regular expression to match. The array can contain as many as 50 keywords. Each
         * keyword can contain 4 - 90 characters. Keywords aren't case sensitive.
         * </p>
         * 
         * @param keywords
         *        An array that lists specific character sequences (keywords), one of which must be within proximity
         *        (maximumMatchDistance) of the regular expression to match. The array can contain as many as 50
         *        keywords. Each keyword can contain 4 - 90 characters. Keywords aren't case sensitive.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder keywords(Collection<String> keywords);

        /**
         * <p>
         * An array that lists specific character sequences (keywords), one of which must be within proximity
         * (maximumMatchDistance) of the regular expression to match. The array can contain as many as 50 keywords. Each
         * keyword can contain 4 - 90 characters. Keywords aren't case sensitive.
         * </p>
         * 
         * @param keywords
         *        An array that lists specific character sequences (keywords), one of which must be within proximity
         *        (maximumMatchDistance) of the regular expression to match. The array can contain as many as 50
         *        keywords. Each keyword can contain 4 - 90 characters. Keywords aren't case sensitive.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder keywords(String... keywords);

        /**
         * <p>
         * The maximum number of characters that can exist between text that matches the regex pattern and the character
         * sequences specified by the keywords array. Macie includes or excludes a result based on the proximity of a
         * keyword to text that matches the regex pattern. The distance can be 1 - 300 characters. The default value is
         * 50.
         * </p>
         * 
         * @param maximumMatchDistance
         *        The maximum number of characters that can exist between text that matches the regex pattern and the
         *        character sequences specified by the keywords array. Macie includes or excludes a result based on the
         *        proximity of a keyword to text that matches the regex pattern. The distance can be 1 - 300 characters.
         *        The default value is 50.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maximumMatchDistance(Integer maximumMatchDistance);

        /**
         * <p>
         * A custom name for the custom data identifier. The name can contain as many as 128 characters.
         * </p>
         * <p>
         * We strongly recommend that you avoid including any sensitive data in the name of a custom data identifier.
         * Other users of your account might be able to see the identifier's name, depending on the actions that they're
         * allowed to perform in Amazon Macie.
         * </p>
         * 
         * @param name
         *        A custom name for the custom data identifier. The name can contain as many as 128 characters.</p>
         *        <p>
         *        We strongly recommend that you avoid including any sensitive data in the name of a custom data
         *        identifier. Other users of your account might be able to see the identifier's name, depending on the
         *        actions that they're allowed to perform in Amazon Macie.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The regular expression (<i>regex</i>) that defines the pattern to match. The expression can contain as many
         * as 512 characters.
         * </p>
         * 
         * @param regex
         *        The regular expression (<i>regex</i>) that defines the pattern to match. The expression can contain as
         *        many as 512 characters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder regex(String regex);

        /**
         * <p>
         * A map of key-value pairs that specifies the tags to associate with the custom data identifier.
         * </p>
         * <p>
         * A custom data identifier can have a maximum of 50 tags. Each tag consists of a tag key and an associated tag
         * value. The maximum length of a tag key is 128 characters. The maximum length of a tag value is 256
         * characters.
         * </p>
         * 
         * @param tags
         *        A map of key-value pairs that specifies the tags to associate with the custom data identifier.</p>
         *        <p>
         *        A custom data identifier can have a maximum of 50 tags. Each tag consists of a tag key and an
         *        associated tag value. The maximum length of a tag key is 128 characters. The maximum length of a tag
         *        value is 256 characters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Macie2Request.BuilderImpl implements Builder {
        private String clientToken;

        private String description;

        private List<String> ignoreWords = DefaultSdkAutoConstructList.getInstance();

        private List<String> keywords = DefaultSdkAutoConstructList.getInstance();

        private Integer maximumMatchDistance;

        private String name;

        private String regex;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateCustomDataIdentifierRequest model) {
            super(model);
            clientToken(model.clientToken);
            description(model.description);
            ignoreWords(model.ignoreWords);
            keywords(model.keywords);
            maximumMatchDistance(model.maximumMatchDistance);
            name(model.name);
            regex(model.regex);
            tags(model.tags);
        }

        public final String getClientToken() {
            return clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final Collection<String> getIgnoreWords() {
            if (ignoreWords instanceof SdkAutoConstructList) {
                return null;
            }
            return ignoreWords;
        }

        @Override
        public final Builder ignoreWords(Collection<String> ignoreWords) {
            this.ignoreWords = ___listOf__stringCopier.copy(ignoreWords);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ignoreWords(String... ignoreWords) {
            ignoreWords(Arrays.asList(ignoreWords));
            return this;
        }

        public final void setIgnoreWords(Collection<String> ignoreWords) {
            this.ignoreWords = ___listOf__stringCopier.copy(ignoreWords);
        }

        public final Collection<String> getKeywords() {
            if (keywords instanceof SdkAutoConstructList) {
                return null;
            }
            return keywords;
        }

        @Override
        public final Builder keywords(Collection<String> keywords) {
            this.keywords = ___listOf__stringCopier.copy(keywords);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder keywords(String... keywords) {
            keywords(Arrays.asList(keywords));
            return this;
        }

        public final void setKeywords(Collection<String> keywords) {
            this.keywords = ___listOf__stringCopier.copy(keywords);
        }

        public final Integer getMaximumMatchDistance() {
            return maximumMatchDistance;
        }

        @Override
        public final Builder maximumMatchDistance(Integer maximumMatchDistance) {
            this.maximumMatchDistance = maximumMatchDistance;
            return this;
        }

        public final void setMaximumMatchDistance(Integer maximumMatchDistance) {
            this.maximumMatchDistance = maximumMatchDistance;
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getRegex() {
            return regex;
        }

        @Override
        public final Builder regex(String regex) {
            this.regex = regex;
            return this;
        }

        public final void setRegex(String regex) {
            this.regex = regex;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateCustomDataIdentifierRequest build() {
            return new CreateCustomDataIdentifierRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
