/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.macie2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies criteria for sorting the results of a request for information about classification jobs.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListJobsSortCriteria implements SdkPojo, Serializable,
        ToCopyableBuilder<ListJobsSortCriteria.Builder, ListJobsSortCriteria> {
    private static final SdkField<String> ATTRIBUTE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("attributeName").getter(getter(ListJobsSortCriteria::attributeNameAsString))
            .setter(setter(Builder::attributeName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("attributeName").build()).build();

    private static final SdkField<String> ORDER_BY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("orderBy").getter(getter(ListJobsSortCriteria::orderByAsString)).setter(setter(Builder::orderBy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("orderBy").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ATTRIBUTE_NAME_FIELD,
            ORDER_BY_FIELD));

    private static final long serialVersionUID = 1L;

    private final String attributeName;

    private final String orderBy;

    private ListJobsSortCriteria(BuilderImpl builder) {
        this.attributeName = builder.attributeName;
        this.orderBy = builder.orderBy;
    }

    /**
     * <p>
     * The property to sort the results by.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #attributeName}
     * will return {@link ListJobsSortAttributeName#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #attributeNameAsString}.
     * </p>
     * 
     * @return The property to sort the results by.
     * @see ListJobsSortAttributeName
     */
    public final ListJobsSortAttributeName attributeName() {
        return ListJobsSortAttributeName.fromValue(attributeName);
    }

    /**
     * <p>
     * The property to sort the results by.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #attributeName}
     * will return {@link ListJobsSortAttributeName#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #attributeNameAsString}.
     * </p>
     * 
     * @return The property to sort the results by.
     * @see ListJobsSortAttributeName
     */
    public final String attributeNameAsString() {
        return attributeName;
    }

    /**
     * <p>
     * The sort order to apply to the results, based on the value for the property specified by the attributeName
     * property. Valid values are: ASC, sort the results in ascending order; and, DESC, sort the results in descending
     * order.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #orderBy} will
     * return {@link OrderBy#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #orderByAsString}.
     * </p>
     * 
     * @return The sort order to apply to the results, based on the value for the property specified by the
     *         attributeName property. Valid values are: ASC, sort the results in ascending order; and, DESC, sort the
     *         results in descending order.
     * @see OrderBy
     */
    public final OrderBy orderBy() {
        return OrderBy.fromValue(orderBy);
    }

    /**
     * <p>
     * The sort order to apply to the results, based on the value for the property specified by the attributeName
     * property. Valid values are: ASC, sort the results in ascending order; and, DESC, sort the results in descending
     * order.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #orderBy} will
     * return {@link OrderBy#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #orderByAsString}.
     * </p>
     * 
     * @return The sort order to apply to the results, based on the value for the property specified by the
     *         attributeName property. Valid values are: ASC, sort the results in ascending order; and, DESC, sort the
     *         results in descending order.
     * @see OrderBy
     */
    public final String orderByAsString() {
        return orderBy;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(attributeNameAsString());
        hashCode = 31 * hashCode + Objects.hashCode(orderByAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListJobsSortCriteria)) {
            return false;
        }
        ListJobsSortCriteria other = (ListJobsSortCriteria) obj;
        return Objects.equals(attributeNameAsString(), other.attributeNameAsString())
                && Objects.equals(orderByAsString(), other.orderByAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListJobsSortCriteria").add("AttributeName", attributeNameAsString())
                .add("OrderBy", orderByAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "attributeName":
            return Optional.ofNullable(clazz.cast(attributeNameAsString()));
        case "orderBy":
            return Optional.ofNullable(clazz.cast(orderByAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListJobsSortCriteria, T> g) {
        return obj -> g.apply((ListJobsSortCriteria) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ListJobsSortCriteria> {
        /**
         * <p>
         * The property to sort the results by.
         * </p>
         * 
         * @param attributeName
         *        The property to sort the results by.
         * @see ListJobsSortAttributeName
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ListJobsSortAttributeName
         */
        Builder attributeName(String attributeName);

        /**
         * <p>
         * The property to sort the results by.
         * </p>
         * 
         * @param attributeName
         *        The property to sort the results by.
         * @see ListJobsSortAttributeName
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ListJobsSortAttributeName
         */
        Builder attributeName(ListJobsSortAttributeName attributeName);

        /**
         * <p>
         * The sort order to apply to the results, based on the value for the property specified by the attributeName
         * property. Valid values are: ASC, sort the results in ascending order; and, DESC, sort the results in
         * descending order.
         * </p>
         * 
         * @param orderBy
         *        The sort order to apply to the results, based on the value for the property specified by the
         *        attributeName property. Valid values are: ASC, sort the results in ascending order; and, DESC, sort
         *        the results in descending order.
         * @see OrderBy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OrderBy
         */
        Builder orderBy(String orderBy);

        /**
         * <p>
         * The sort order to apply to the results, based on the value for the property specified by the attributeName
         * property. Valid values are: ASC, sort the results in ascending order; and, DESC, sort the results in
         * descending order.
         * </p>
         * 
         * @param orderBy
         *        The sort order to apply to the results, based on the value for the property specified by the
         *        attributeName property. Valid values are: ASC, sort the results in ascending order; and, DESC, sort
         *        the results in descending order.
         * @see OrderBy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OrderBy
         */
        Builder orderBy(OrderBy orderBy);
    }

    static final class BuilderImpl implements Builder {
        private String attributeName;

        private String orderBy;

        private BuilderImpl() {
        }

        private BuilderImpl(ListJobsSortCriteria model) {
            attributeName(model.attributeName);
            orderBy(model.orderBy);
        }

        public final String getAttributeName() {
            return attributeName;
        }

        @Override
        public final Builder attributeName(String attributeName) {
            this.attributeName = attributeName;
            return this;
        }

        @Override
        public final Builder attributeName(ListJobsSortAttributeName attributeName) {
            this.attributeName(attributeName == null ? null : attributeName.toString());
            return this;
        }

        public final void setAttributeName(String attributeName) {
            this.attributeName = attributeName;
        }

        public final String getOrderBy() {
            return orderBy;
        }

        @Override
        public final Builder orderBy(String orderBy) {
            this.orderBy = orderBy;
            return this;
        }

        @Override
        public final Builder orderBy(OrderBy orderBy) {
            this.orderBy(orderBy == null ? null : orderBy.toString());
            return this;
        }

        public final void setOrderBy(String orderBy) {
            this.orderBy = orderBy;
        }

        @Override
        public ListJobsSortCriteria build() {
            return new ListJobsSortCriteria(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
