/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.macie2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies configuration settings that determine which findings are published to AWS Security Hub automatically. For
 * information about how Macie publishes findings to Security Hub, see <a
 * href="https://docs.aws.amazon.com/macie/latest/user/securityhub-integration.html">Amazon Macie integration with
 * Security Hub</a> in the <i>Amazon Macie User Guide</i>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SecurityHubConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<SecurityHubConfiguration.Builder, SecurityHubConfiguration> {
    private static final SdkField<Boolean> PUBLISH_CLASSIFICATION_FINDINGS_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("publishClassificationFindings")
            .getter(getter(SecurityHubConfiguration::publishClassificationFindings))
            .setter(setter(Builder::publishClassificationFindings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("publishClassificationFindings")
                    .build()).build();

    private static final SdkField<Boolean> PUBLISH_POLICY_FINDINGS_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("publishPolicyFindings").getter(getter(SecurityHubConfiguration::publishPolicyFindings))
            .setter(setter(Builder::publishPolicyFindings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("publishPolicyFindings").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            PUBLISH_CLASSIFICATION_FINDINGS_FIELD, PUBLISH_POLICY_FINDINGS_FIELD));

    private static final long serialVersionUID = 1L;

    private final Boolean publishClassificationFindings;

    private final Boolean publishPolicyFindings;

    private SecurityHubConfiguration(BuilderImpl builder) {
        this.publishClassificationFindings = builder.publishClassificationFindings;
        this.publishPolicyFindings = builder.publishPolicyFindings;
    }

    /**
     * <p>
     * Specifies whether to publish sensitive data findings to AWS Security Hub. If you set this value to true, Amazon
     * Macie automatically publishes all sensitive data findings that weren't suppressed by a findings filter. The
     * default value is false.
     * </p>
     * 
     * @return Specifies whether to publish sensitive data findings to AWS Security Hub. If you set this value to true,
     *         Amazon Macie automatically publishes all sensitive data findings that weren't suppressed by a findings
     *         filter. The default value is false.
     */
    public final Boolean publishClassificationFindings() {
        return publishClassificationFindings;
    }

    /**
     * <p>
     * Specifies whether to publish policy findings to AWS Security Hub. If you set this value to true, Amazon Macie
     * automatically publishes all new and updated policy findings that weren't suppressed by a findings filter. The
     * default value is true.
     * </p>
     * 
     * @return Specifies whether to publish policy findings to AWS Security Hub. If you set this value to true, Amazon
     *         Macie automatically publishes all new and updated policy findings that weren't suppressed by a findings
     *         filter. The default value is true.
     */
    public final Boolean publishPolicyFindings() {
        return publishPolicyFindings;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(publishClassificationFindings());
        hashCode = 31 * hashCode + Objects.hashCode(publishPolicyFindings());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SecurityHubConfiguration)) {
            return false;
        }
        SecurityHubConfiguration other = (SecurityHubConfiguration) obj;
        return Objects.equals(publishClassificationFindings(), other.publishClassificationFindings())
                && Objects.equals(publishPolicyFindings(), other.publishPolicyFindings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SecurityHubConfiguration").add("PublishClassificationFindings", publishClassificationFindings())
                .add("PublishPolicyFindings", publishPolicyFindings()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "publishClassificationFindings":
            return Optional.ofNullable(clazz.cast(publishClassificationFindings()));
        case "publishPolicyFindings":
            return Optional.ofNullable(clazz.cast(publishPolicyFindings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SecurityHubConfiguration, T> g) {
        return obj -> g.apply((SecurityHubConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SecurityHubConfiguration> {
        /**
         * <p>
         * Specifies whether to publish sensitive data findings to AWS Security Hub. If you set this value to true,
         * Amazon Macie automatically publishes all sensitive data findings that weren't suppressed by a findings
         * filter. The default value is false.
         * </p>
         * 
         * @param publishClassificationFindings
         *        Specifies whether to publish sensitive data findings to AWS Security Hub. If you set this value to
         *        true, Amazon Macie automatically publishes all sensitive data findings that weren't suppressed by a
         *        findings filter. The default value is false.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder publishClassificationFindings(Boolean publishClassificationFindings);

        /**
         * <p>
         * Specifies whether to publish policy findings to AWS Security Hub. If you set this value to true, Amazon Macie
         * automatically publishes all new and updated policy findings that weren't suppressed by a findings filter. The
         * default value is true.
         * </p>
         * 
         * @param publishPolicyFindings
         *        Specifies whether to publish policy findings to AWS Security Hub. If you set this value to true,
         *        Amazon Macie automatically publishes all new and updated policy findings that weren't suppressed by a
         *        findings filter. The default value is true.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder publishPolicyFindings(Boolean publishPolicyFindings);
    }

    static final class BuilderImpl implements Builder {
        private Boolean publishClassificationFindings;

        private Boolean publishPolicyFindings;

        private BuilderImpl() {
        }

        private BuilderImpl(SecurityHubConfiguration model) {
            publishClassificationFindings(model.publishClassificationFindings);
            publishPolicyFindings(model.publishPolicyFindings);
        }

        public final Boolean getPublishClassificationFindings() {
            return publishClassificationFindings;
        }

        @Override
        public final Builder publishClassificationFindings(Boolean publishClassificationFindings) {
            this.publishClassificationFindings = publishClassificationFindings;
            return this;
        }

        public final void setPublishClassificationFindings(Boolean publishClassificationFindings) {
            this.publishClassificationFindings = publishClassificationFindings;
        }

        public final Boolean getPublishPolicyFindings() {
            return publishPolicyFindings;
        }

        @Override
        public final Builder publishPolicyFindings(Boolean publishPolicyFindings) {
            this.publishPolicyFindings = publishPolicyFindings;
            return this;
        }

        public final void setPublishPolicyFindings(Boolean publishPolicyFindings) {
            this.publishPolicyFindings = publishPolicyFindings;
        }

        @Override
        public SecurityHubConfiguration build() {
            return new SecurityHubConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
