/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.macie2.model;

import static java.util.stream.Collectors.toList;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;

@Generated("software.amazon.awssdk:codegen")
final class ___listOfS3BucketDefinitionForJobCopier {
    static List<S3BucketDefinitionForJob> copy(Collection<S3BucketDefinitionForJob> __listOfS3BucketDefinitionForJobParam) {
        if (__listOfS3BucketDefinitionForJobParam == null
                || __listOfS3BucketDefinitionForJobParam instanceof SdkAutoConstructList) {
            return DefaultSdkAutoConstructList.getInstance();
        }
        List<S3BucketDefinitionForJob> __listOfS3BucketDefinitionForJobParamCopy = new ArrayList<>(
                __listOfS3BucketDefinitionForJobParam);
        return Collections.unmodifiableList(__listOfS3BucketDefinitionForJobParamCopy);
    }

    static List<S3BucketDefinitionForJob> copyFromBuilder(
            Collection<? extends S3BucketDefinitionForJob.Builder> __listOfS3BucketDefinitionForJobParam) {
        if (__listOfS3BucketDefinitionForJobParam == null
                || __listOfS3BucketDefinitionForJobParam instanceof DefaultSdkAutoConstructList) {
            return DefaultSdkAutoConstructList.getInstance();
        }
        return copy(__listOfS3BucketDefinitionForJobParam.stream().map(S3BucketDefinitionForJob.Builder::build).collect(toList()));
    }
}
