/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.macie2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides the location of 1-15 occurrences of sensitive data that was detected by managed data identifiers or a custom
 * data identifier and produced a sensitive data finding.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Occurrences implements SdkPojo, Serializable, ToCopyableBuilder<Occurrences.Builder, Occurrences> {
    private static final SdkField<List<Cell>> CELLS_FIELD = SdkField
            .<List<Cell>> builder(MarshallingType.LIST)
            .memberName("cells")
            .getter(getter(Occurrences::cells))
            .setter(setter(Builder::cells))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cells").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Cell> builder(MarshallingType.SDK_POJO)
                                            .constructor(Cell::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<Range>> LINE_RANGES_FIELD = SdkField
            .<List<Range>> builder(MarshallingType.LIST)
            .memberName("lineRanges")
            .getter(getter(Occurrences::lineRanges))
            .setter(setter(Builder::lineRanges))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lineRanges").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Range> builder(MarshallingType.SDK_POJO)
                                            .constructor(Range::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<Range>> OFFSET_RANGES_FIELD = SdkField
            .<List<Range>> builder(MarshallingType.LIST)
            .memberName("offsetRanges")
            .getter(getter(Occurrences::offsetRanges))
            .setter(setter(Builder::offsetRanges))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("offsetRanges").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Range> builder(MarshallingType.SDK_POJO)
                                            .constructor(Range::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<Page>> PAGES_FIELD = SdkField
            .<List<Page>> builder(MarshallingType.LIST)
            .memberName("pages")
            .getter(getter(Occurrences::pages))
            .setter(setter(Builder::pages))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pages").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Page> builder(MarshallingType.SDK_POJO)
                                            .constructor(Page::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<Record>> RECORDS_FIELD = SdkField
            .<List<Record>> builder(MarshallingType.LIST)
            .memberName("records")
            .getter(getter(Occurrences::records))
            .setter(setter(Builder::records))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("records").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Record> builder(MarshallingType.SDK_POJO)
                                            .constructor(Record::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CELLS_FIELD,
            LINE_RANGES_FIELD, OFFSET_RANGES_FIELD, PAGES_FIELD, RECORDS_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<Cell> cells;

    private final List<Range> lineRanges;

    private final List<Range> offsetRanges;

    private final List<Page> pages;

    private final List<Record> records;

    private Occurrences(BuilderImpl builder) {
        this.cells = builder.cells;
        this.lineRanges = builder.lineRanges;
        this.offsetRanges = builder.offsetRanges;
        this.pages = builder.pages;
        this.records = builder.records;
    }

    /**
     * Returns true if the Cells property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasCells() {
        return cells != null && !(cells instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of objects, one for each occurrence of sensitive data in a Microsoft Excel workbook, CSV file, or TSV
     * file. Each object specifies the cell or field that contains the data. This value is null for all other types of
     * files.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasCells()} to see if a value was sent in this field.
     * </p>
     * 
     * @return An array of objects, one for each occurrence of sensitive data in a Microsoft Excel workbook, CSV file,
     *         or TSV file. Each object specifies the cell or field that contains the data. This value is null for all
     *         other types of files.
     */
    public final List<Cell> cells() {
        return cells;
    }

    /**
     * Returns true if the LineRanges property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasLineRanges() {
        return lineRanges != null && !(lineRanges instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of objects, one for each occurrence of sensitive data in a Microsoft Word document or non-binary text
     * file, such as an HTML, JSON, TXT, or XML file. Each object specifies the line that contains the data, and the
     * position of the data on that line.
     * </p>
     * <p>
     * This value is often null for file types that are supported by Cell, Page, or Record objects. Exceptions are the
     * locations of data in: unstructured sections of an otherwise structured file, such as a comment in a file; a
     * malformed file that Amazon Macie analyzes as plain text; and, a CSV or TSV file that has any column names that
     * contain sensitive data.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasLineRanges()} to see if a value was sent in this field.
     * </p>
     * 
     * @return An array of objects, one for each occurrence of sensitive data in a Microsoft Word document or non-binary
     *         text file, such as an HTML, JSON, TXT, or XML file. Each object specifies the line that contains the
     *         data, and the position of the data on that line.</p>
     *         <p>
     *         This value is often null for file types that are supported by Cell, Page, or Record objects. Exceptions
     *         are the locations of data in: unstructured sections of an otherwise structured file, such as a comment in
     *         a file; a malformed file that Amazon Macie analyzes as plain text; and, a CSV or TSV file that has any
     *         column names that contain sensitive data.
     */
    public final List<Range> lineRanges() {
        return lineRanges;
    }

    /**
     * Returns true if the OffsetRanges property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasOffsetRanges() {
        return offsetRanges != null && !(offsetRanges instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of objects, one for each occurrence of sensitive data in a binary text file. Each object specifies the
     * position of the data relative to the beginning of the file.
     * </p>
     * <p>
     * This value is typically null. For binary text files, Amazon Macie adds location data to a lineRanges.Range or
     * Page object, depending on the file type.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasOffsetRanges()} to see if a value was sent in this field.
     * </p>
     * 
     * @return An array of objects, one for each occurrence of sensitive data in a binary text file. Each object
     *         specifies the position of the data relative to the beginning of the file.</p>
     *         <p>
     *         This value is typically null. For binary text files, Amazon Macie adds location data to a
     *         lineRanges.Range or Page object, depending on the file type.
     */
    public final List<Range> offsetRanges() {
        return offsetRanges;
    }

    /**
     * Returns true if the Pages property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasPages() {
        return pages != null && !(pages instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of objects, one for each occurrence of sensitive data in an Adobe Portable Document Format file. Each
     * object specifies the page that contains the data, and the position of the data on that page. This value is null
     * for all other types of files.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasPages()} to see if a value was sent in this field.
     * </p>
     * 
     * @return An array of objects, one for each occurrence of sensitive data in an Adobe Portable Document Format file.
     *         Each object specifies the page that contains the data, and the position of the data on that page. This
     *         value is null for all other types of files.
     */
    public final List<Page> pages() {
        return pages;
    }

    /**
     * Returns true if the Records property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasRecords() {
        return records != null && !(records instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of objects, one for each occurrence of sensitive data in an Apache Avro object container or Apache
     * Parquet file. Each object specifies the record index and the path to the field in the record that contains the
     * data. This value is null for all other types of files.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasRecords()} to see if a value was sent in this field.
     * </p>
     * 
     * @return An array of objects, one for each occurrence of sensitive data in an Apache Avro object container or
     *         Apache Parquet file. Each object specifies the record index and the path to the field in the record that
     *         contains the data. This value is null for all other types of files.
     */
    public final List<Record> records() {
        return records;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasCells() ? cells() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasLineRanges() ? lineRanges() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasOffsetRanges() ? offsetRanges() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasPages() ? pages() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasRecords() ? records() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Occurrences)) {
            return false;
        }
        Occurrences other = (Occurrences) obj;
        return hasCells() == other.hasCells() && Objects.equals(cells(), other.cells())
                && hasLineRanges() == other.hasLineRanges() && Objects.equals(lineRanges(), other.lineRanges())
                && hasOffsetRanges() == other.hasOffsetRanges() && Objects.equals(offsetRanges(), other.offsetRanges())
                && hasPages() == other.hasPages() && Objects.equals(pages(), other.pages()) && hasRecords() == other.hasRecords()
                && Objects.equals(records(), other.records());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Occurrences").add("Cells", hasCells() ? cells() : null)
                .add("LineRanges", hasLineRanges() ? lineRanges() : null)
                .add("OffsetRanges", hasOffsetRanges() ? offsetRanges() : null).add("Pages", hasPages() ? pages() : null)
                .add("Records", hasRecords() ? records() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "cells":
            return Optional.ofNullable(clazz.cast(cells()));
        case "lineRanges":
            return Optional.ofNullable(clazz.cast(lineRanges()));
        case "offsetRanges":
            return Optional.ofNullable(clazz.cast(offsetRanges()));
        case "pages":
            return Optional.ofNullable(clazz.cast(pages()));
        case "records":
            return Optional.ofNullable(clazz.cast(records()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Occurrences, T> g) {
        return obj -> g.apply((Occurrences) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Occurrences> {
        /**
         * <p>
         * An array of objects, one for each occurrence of sensitive data in a Microsoft Excel workbook, CSV file, or
         * TSV file. Each object specifies the cell or field that contains the data. This value is null for all other
         * types of files.
         * </p>
         * 
         * @param cells
         *        An array of objects, one for each occurrence of sensitive data in a Microsoft Excel workbook, CSV
         *        file, or TSV file. Each object specifies the cell or field that contains the data. This value is null
         *        for all other types of files.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cells(Collection<Cell> cells);

        /**
         * <p>
         * An array of objects, one for each occurrence of sensitive data in a Microsoft Excel workbook, CSV file, or
         * TSV file. Each object specifies the cell or field that contains the data. This value is null for all other
         * types of files.
         * </p>
         * 
         * @param cells
         *        An array of objects, one for each occurrence of sensitive data in a Microsoft Excel workbook, CSV
         *        file, or TSV file. Each object specifies the cell or field that contains the data. This value is null
         *        for all other types of files.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cells(Cell... cells);

        /**
         * <p>
         * An array of objects, one for each occurrence of sensitive data in a Microsoft Excel workbook, CSV file, or
         * TSV file. Each object specifies the cell or field that contains the data. This value is null for all other
         * types of files.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Cell>.Builder} avoiding the need to create
         * one manually via {@link List<Cell>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Cell>.Builder#build()} is called immediately and its result
         * is passed to {@link #cells(List<Cell>)}.
         * 
         * @param cells
         *        a consumer that will call methods on {@link List<Cell>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #cells(List<Cell>)
         */
        Builder cells(Consumer<Cell.Builder>... cells);

        /**
         * <p>
         * An array of objects, one for each occurrence of sensitive data in a Microsoft Word document or non-binary
         * text file, such as an HTML, JSON, TXT, or XML file. Each object specifies the line that contains the data,
         * and the position of the data on that line.
         * </p>
         * <p>
         * This value is often null for file types that are supported by Cell, Page, or Record objects. Exceptions are
         * the locations of data in: unstructured sections of an otherwise structured file, such as a comment in a file;
         * a malformed file that Amazon Macie analyzes as plain text; and, a CSV or TSV file that has any column names
         * that contain sensitive data.
         * </p>
         * 
         * @param lineRanges
         *        An array of objects, one for each occurrence of sensitive data in a Microsoft Word document or
         *        non-binary text file, such as an HTML, JSON, TXT, or XML file. Each object specifies the line that
         *        contains the data, and the position of the data on that line.</p>
         *        <p>
         *        This value is often null for file types that are supported by Cell, Page, or Record objects.
         *        Exceptions are the locations of data in: unstructured sections of an otherwise structured file, such
         *        as a comment in a file; a malformed file that Amazon Macie analyzes as plain text; and, a CSV or TSV
         *        file that has any column names that contain sensitive data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lineRanges(Collection<Range> lineRanges);

        /**
         * <p>
         * An array of objects, one for each occurrence of sensitive data in a Microsoft Word document or non-binary
         * text file, such as an HTML, JSON, TXT, or XML file. Each object specifies the line that contains the data,
         * and the position of the data on that line.
         * </p>
         * <p>
         * This value is often null for file types that are supported by Cell, Page, or Record objects. Exceptions are
         * the locations of data in: unstructured sections of an otherwise structured file, such as a comment in a file;
         * a malformed file that Amazon Macie analyzes as plain text; and, a CSV or TSV file that has any column names
         * that contain sensitive data.
         * </p>
         * 
         * @param lineRanges
         *        An array of objects, one for each occurrence of sensitive data in a Microsoft Word document or
         *        non-binary text file, such as an HTML, JSON, TXT, or XML file. Each object specifies the line that
         *        contains the data, and the position of the data on that line.</p>
         *        <p>
         *        This value is often null for file types that are supported by Cell, Page, or Record objects.
         *        Exceptions are the locations of data in: unstructured sections of an otherwise structured file, such
         *        as a comment in a file; a malformed file that Amazon Macie analyzes as plain text; and, a CSV or TSV
         *        file that has any column names that contain sensitive data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lineRanges(Range... lineRanges);

        /**
         * <p>
         * An array of objects, one for each occurrence of sensitive data in a Microsoft Word document or non-binary
         * text file, such as an HTML, JSON, TXT, or XML file. Each object specifies the line that contains the data,
         * and the position of the data on that line.
         * </p>
         * <p>
         * This value is often null for file types that are supported by Cell, Page, or Record objects. Exceptions are
         * the locations of data in: unstructured sections of an otherwise structured file, such as a comment in a file;
         * a malformed file that Amazon Macie analyzes as plain text; and, a CSV or TSV file that has any column names
         * that contain sensitive data.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Range>.Builder} avoiding the need to create
         * one manually via {@link List<Range>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Range>.Builder#build()} is called immediately and its result
         * is passed to {@link #lineRanges(List<Range>)}.
         * 
         * @param lineRanges
         *        a consumer that will call methods on {@link List<Range>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #lineRanges(List<Range>)
         */
        Builder lineRanges(Consumer<Range.Builder>... lineRanges);

        /**
         * <p>
         * An array of objects, one for each occurrence of sensitive data in a binary text file. Each object specifies
         * the position of the data relative to the beginning of the file.
         * </p>
         * <p>
         * This value is typically null. For binary text files, Amazon Macie adds location data to a lineRanges.Range or
         * Page object, depending on the file type.
         * </p>
         * 
         * @param offsetRanges
         *        An array of objects, one for each occurrence of sensitive data in a binary text file. Each object
         *        specifies the position of the data relative to the beginning of the file.</p>
         *        <p>
         *        This value is typically null. For binary text files, Amazon Macie adds location data to a
         *        lineRanges.Range or Page object, depending on the file type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder offsetRanges(Collection<Range> offsetRanges);

        /**
         * <p>
         * An array of objects, one for each occurrence of sensitive data in a binary text file. Each object specifies
         * the position of the data relative to the beginning of the file.
         * </p>
         * <p>
         * This value is typically null. For binary text files, Amazon Macie adds location data to a lineRanges.Range or
         * Page object, depending on the file type.
         * </p>
         * 
         * @param offsetRanges
         *        An array of objects, one for each occurrence of sensitive data in a binary text file. Each object
         *        specifies the position of the data relative to the beginning of the file.</p>
         *        <p>
         *        This value is typically null. For binary text files, Amazon Macie adds location data to a
         *        lineRanges.Range or Page object, depending on the file type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder offsetRanges(Range... offsetRanges);

        /**
         * <p>
         * An array of objects, one for each occurrence of sensitive data in a binary text file. Each object specifies
         * the position of the data relative to the beginning of the file.
         * </p>
         * <p>
         * This value is typically null. For binary text files, Amazon Macie adds location data to a lineRanges.Range or
         * Page object, depending on the file type.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Range>.Builder} avoiding the need to create
         * one manually via {@link List<Range>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Range>.Builder#build()} is called immediately and its result
         * is passed to {@link #offsetRanges(List<Range>)}.
         * 
         * @param offsetRanges
         *        a consumer that will call methods on {@link List<Range>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #offsetRanges(List<Range>)
         */
        Builder offsetRanges(Consumer<Range.Builder>... offsetRanges);

        /**
         * <p>
         * An array of objects, one for each occurrence of sensitive data in an Adobe Portable Document Format file.
         * Each object specifies the page that contains the data, and the position of the data on that page. This value
         * is null for all other types of files.
         * </p>
         * 
         * @param pages
         *        An array of objects, one for each occurrence of sensitive data in an Adobe Portable Document Format
         *        file. Each object specifies the page that contains the data, and the position of the data on that
         *        page. This value is null for all other types of files.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pages(Collection<Page> pages);

        /**
         * <p>
         * An array of objects, one for each occurrence of sensitive data in an Adobe Portable Document Format file.
         * Each object specifies the page that contains the data, and the position of the data on that page. This value
         * is null for all other types of files.
         * </p>
         * 
         * @param pages
         *        An array of objects, one for each occurrence of sensitive data in an Adobe Portable Document Format
         *        file. Each object specifies the page that contains the data, and the position of the data on that
         *        page. This value is null for all other types of files.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pages(Page... pages);

        /**
         * <p>
         * An array of objects, one for each occurrence of sensitive data in an Adobe Portable Document Format file.
         * Each object specifies the page that contains the data, and the position of the data on that page. This value
         * is null for all other types of files.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Page>.Builder} avoiding the need to create
         * one manually via {@link List<Page>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Page>.Builder#build()} is called immediately and its result
         * is passed to {@link #pages(List<Page>)}.
         * 
         * @param pages
         *        a consumer that will call methods on {@link List<Page>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #pages(List<Page>)
         */
        Builder pages(Consumer<Page.Builder>... pages);

        /**
         * <p>
         * An array of objects, one for each occurrence of sensitive data in an Apache Avro object container or Apache
         * Parquet file. Each object specifies the record index and the path to the field in the record that contains
         * the data. This value is null for all other types of files.
         * </p>
         * 
         * @param records
         *        An array of objects, one for each occurrence of sensitive data in an Apache Avro object container or
         *        Apache Parquet file. Each object specifies the record index and the path to the field in the record
         *        that contains the data. This value is null for all other types of files.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder records(Collection<Record> records);

        /**
         * <p>
         * An array of objects, one for each occurrence of sensitive data in an Apache Avro object container or Apache
         * Parquet file. Each object specifies the record index and the path to the field in the record that contains
         * the data. This value is null for all other types of files.
         * </p>
         * 
         * @param records
         *        An array of objects, one for each occurrence of sensitive data in an Apache Avro object container or
         *        Apache Parquet file. Each object specifies the record index and the path to the field in the record
         *        that contains the data. This value is null for all other types of files.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder records(Record... records);

        /**
         * <p>
         * An array of objects, one for each occurrence of sensitive data in an Apache Avro object container or Apache
         * Parquet file. Each object specifies the record index and the path to the field in the record that contains
         * the data. This value is null for all other types of files.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Record>.Builder} avoiding the need to
         * create one manually via {@link List<Record>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Record>.Builder#build()} is called immediately and its
         * result is passed to {@link #records(List<Record>)}.
         * 
         * @param records
         *        a consumer that will call methods on {@link List<Record>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #records(List<Record>)
         */
        Builder records(Consumer<Record.Builder>... records);
    }

    static final class BuilderImpl implements Builder {
        private List<Cell> cells = DefaultSdkAutoConstructList.getInstance();

        private List<Range> lineRanges = DefaultSdkAutoConstructList.getInstance();

        private List<Range> offsetRanges = DefaultSdkAutoConstructList.getInstance();

        private List<Page> pages = DefaultSdkAutoConstructList.getInstance();

        private List<Record> records = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Occurrences model) {
            cells(model.cells);
            lineRanges(model.lineRanges);
            offsetRanges(model.offsetRanges);
            pages(model.pages);
            records(model.records);
        }

        public final List<Cell.Builder> getCells() {
            List<Cell.Builder> result = CellsCopier.copyToBuilder(this.cells);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder cells(Collection<Cell> cells) {
            this.cells = CellsCopier.copy(cells);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder cells(Cell... cells) {
            cells(Arrays.asList(cells));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder cells(Consumer<Cell.Builder>... cells) {
            cells(Stream.of(cells).map(c -> Cell.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setCells(Collection<Cell.BuilderImpl> cells) {
            this.cells = CellsCopier.copyFromBuilder(cells);
        }

        public final List<Range.Builder> getLineRanges() {
            List<Range.Builder> result = RangesCopier.copyToBuilder(this.lineRanges);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder lineRanges(Collection<Range> lineRanges) {
            this.lineRanges = RangesCopier.copy(lineRanges);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder lineRanges(Range... lineRanges) {
            lineRanges(Arrays.asList(lineRanges));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder lineRanges(Consumer<Range.Builder>... lineRanges) {
            lineRanges(Stream.of(lineRanges).map(c -> Range.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setLineRanges(Collection<Range.BuilderImpl> lineRanges) {
            this.lineRanges = RangesCopier.copyFromBuilder(lineRanges);
        }

        public final List<Range.Builder> getOffsetRanges() {
            List<Range.Builder> result = RangesCopier.copyToBuilder(this.offsetRanges);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder offsetRanges(Collection<Range> offsetRanges) {
            this.offsetRanges = RangesCopier.copy(offsetRanges);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder offsetRanges(Range... offsetRanges) {
            offsetRanges(Arrays.asList(offsetRanges));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder offsetRanges(Consumer<Range.Builder>... offsetRanges) {
            offsetRanges(Stream.of(offsetRanges).map(c -> Range.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setOffsetRanges(Collection<Range.BuilderImpl> offsetRanges) {
            this.offsetRanges = RangesCopier.copyFromBuilder(offsetRanges);
        }

        public final List<Page.Builder> getPages() {
            List<Page.Builder> result = PagesCopier.copyToBuilder(this.pages);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder pages(Collection<Page> pages) {
            this.pages = PagesCopier.copy(pages);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder pages(Page... pages) {
            pages(Arrays.asList(pages));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder pages(Consumer<Page.Builder>... pages) {
            pages(Stream.of(pages).map(c -> Page.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setPages(Collection<Page.BuilderImpl> pages) {
            this.pages = PagesCopier.copyFromBuilder(pages);
        }

        public final List<Record.Builder> getRecords() {
            List<Record.Builder> result = RecordsCopier.copyToBuilder(this.records);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder records(Collection<Record> records) {
            this.records = RecordsCopier.copy(records);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder records(Record... records) {
            records(Arrays.asList(records));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder records(Consumer<Record.Builder>... records) {
            records(Stream.of(records).map(c -> Record.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setRecords(Collection<Record.BuilderImpl> records) {
            this.records = RecordsCopier.copyFromBuilder(records);
        }

        @Override
        public Occurrences build() {
            return new Occurrences(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
