/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.macie2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.macie2.model.S3BucketCriteriaForJob;
import software.amazon.awssdk.services.macie2.model.S3BucketDefinitionForJob;
import software.amazon.awssdk.services.macie2.model.Scoping;
import software.amazon.awssdk.services.macie2.model.___listOfS3BucketDefinitionForJobCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class S3JobDefinition
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, S3JobDefinition> {
    private static final SdkField<List<S3BucketDefinitionForJob>> BUCKET_DEFINITIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("bucketDefinitions").getter(S3JobDefinition.getter(S3JobDefinition::bucketDefinitions)).setter(S3JobDefinition.setter(Builder::bucketDefinitions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("bucketDefinitions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(S3BucketDefinitionForJob::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Scoping> SCOPING_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("scoping").getter(S3JobDefinition.getter(S3JobDefinition::scoping)).setter(S3JobDefinition.setter(Builder::scoping)).constructor(Scoping::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scoping").build()}).build();
    private static final SdkField<S3BucketCriteriaForJob> BUCKET_CRITERIA_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("bucketCriteria").getter(S3JobDefinition.getter(S3JobDefinition::bucketCriteria)).setter(S3JobDefinition.setter(Builder::bucketCriteria)).constructor(S3BucketCriteriaForJob::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("bucketCriteria").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BUCKET_DEFINITIONS_FIELD, SCOPING_FIELD, BUCKET_CRITERIA_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<S3BucketDefinitionForJob> bucketDefinitions;
    private final Scoping scoping;
    private final S3BucketCriteriaForJob bucketCriteria;

    private S3JobDefinition(BuilderImpl builder) {
        this.bucketDefinitions = builder.bucketDefinitions;
        this.scoping = builder.scoping;
        this.bucketCriteria = builder.bucketCriteria;
    }

    public final boolean hasBucketDefinitions() {
        return this.bucketDefinitions != null && !(this.bucketDefinitions instanceof SdkAutoConstructList);
    }

    public final List<S3BucketDefinitionForJob> bucketDefinitions() {
        return this.bucketDefinitions;
    }

    public final Scoping scoping() {
        return this.scoping;
    }

    public final S3BucketCriteriaForJob bucketCriteria() {
        return this.bucketCriteria;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasBucketDefinitions() ? this.bucketDefinitions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.scoping());
        hashCode = 31 * hashCode + Objects.hashCode(this.bucketCriteria());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof S3JobDefinition)) {
            return false;
        }
        S3JobDefinition other = (S3JobDefinition)obj;
        return this.hasBucketDefinitions() == other.hasBucketDefinitions() && Objects.equals(this.bucketDefinitions(), other.bucketDefinitions()) && Objects.equals(this.scoping(), other.scoping()) && Objects.equals(this.bucketCriteria(), other.bucketCriteria());
    }

    public final String toString() {
        return ToString.builder((String)"S3JobDefinition").add("BucketDefinitions", this.hasBucketDefinitions() ? this.bucketDefinitions() : null).add("Scoping", (Object)this.scoping()).add("BucketCriteria", (Object)this.bucketCriteria()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "bucketDefinitions": {
                return Optional.ofNullable(clazz.cast(this.bucketDefinitions()));
            }
            case "scoping": {
                return Optional.ofNullable(clazz.cast(this.scoping()));
            }
            case "bucketCriteria": {
                return Optional.ofNullable(clazz.cast(this.bucketCriteria()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<S3JobDefinition, T> g) {
        return obj -> g.apply((S3JobDefinition)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<S3BucketDefinitionForJob> bucketDefinitions = DefaultSdkAutoConstructList.getInstance();
        private Scoping scoping;
        private S3BucketCriteriaForJob bucketCriteria;

        private BuilderImpl() {
        }

        private BuilderImpl(S3JobDefinition model) {
            this.bucketDefinitions(model.bucketDefinitions);
            this.scoping(model.scoping);
            this.bucketCriteria(model.bucketCriteria);
        }

        public final List<S3BucketDefinitionForJob.Builder> getBucketDefinitions() {
            List<S3BucketDefinitionForJob.Builder> result = ___listOfS3BucketDefinitionForJobCopier.copyToBuilder(this.bucketDefinitions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder bucketDefinitions(Collection<S3BucketDefinitionForJob> bucketDefinitions) {
            this.bucketDefinitions = ___listOfS3BucketDefinitionForJobCopier.copy(bucketDefinitions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder bucketDefinitions(S3BucketDefinitionForJob ... bucketDefinitions) {
            this.bucketDefinitions(Arrays.asList(bucketDefinitions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder bucketDefinitions(Consumer<S3BucketDefinitionForJob.Builder> ... bucketDefinitions) {
            this.bucketDefinitions(Stream.of(bucketDefinitions).map(c -> (S3BucketDefinitionForJob)((S3BucketDefinitionForJob.Builder)S3BucketDefinitionForJob.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setBucketDefinitions(Collection<S3BucketDefinitionForJob.BuilderImpl> bucketDefinitions) {
            this.bucketDefinitions = ___listOfS3BucketDefinitionForJobCopier.copyFromBuilder(bucketDefinitions);
        }

        public final Scoping.Builder getScoping() {
            return this.scoping != null ? this.scoping.toBuilder() : null;
        }

        @Override
        public final Builder scoping(Scoping scoping) {
            this.scoping = scoping;
            return this;
        }

        public final void setScoping(Scoping.BuilderImpl scoping) {
            this.scoping = scoping != null ? scoping.build() : null;
        }

        public final S3BucketCriteriaForJob.Builder getBucketCriteria() {
            return this.bucketCriteria != null ? this.bucketCriteria.toBuilder() : null;
        }

        @Override
        public final Builder bucketCriteria(S3BucketCriteriaForJob bucketCriteria) {
            this.bucketCriteria = bucketCriteria;
            return this;
        }

        public final void setBucketCriteria(S3BucketCriteriaForJob.BuilderImpl bucketCriteria) {
            this.bucketCriteria = bucketCriteria != null ? bucketCriteria.build() : null;
        }

        public S3JobDefinition build() {
            return new S3JobDefinition(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, S3JobDefinition> {
        public Builder bucketDefinitions(Collection<S3BucketDefinitionForJob> var1);

        public Builder bucketDefinitions(S3BucketDefinitionForJob ... var1);

        public Builder bucketDefinitions(Consumer<S3BucketDefinitionForJob.Builder> ... var1);

        public Builder scoping(Scoping var1);

        default public Builder scoping(Consumer<Scoping.Builder> scoping) {
            return this.scoping((Scoping)((Scoping.Builder)Scoping.builder().applyMutation(scoping)).build());
        }

        public Builder bucketCriteria(S3BucketCriteriaForJob var1);

        default public Builder bucketCriteria(Consumer<S3BucketCriteriaForJob.Builder> bucketCriteria) {
            return this.bucketCriteria((S3BucketCriteriaForJob)((S3BucketCriteriaForJob.Builder)S3BucketCriteriaForJob.builder().applyMutation(bucketCriteria)).build());
        }
    }
}

