/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.macie2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides information about an identity that performed an action on an affected resource by using temporary security
 * credentials. The credentials were obtained using the AssumeRole operation of the AWS Security Token Service (AWS STS)
 * API.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AssumedRole implements SdkPojo, Serializable, ToCopyableBuilder<AssumedRole.Builder, AssumedRole> {
    private static final SdkField<String> ACCESS_KEY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("accessKeyId").getter(getter(AssumedRole::accessKeyId)).setter(setter(Builder::accessKeyId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accessKeyId").build()).build();

    private static final SdkField<String> ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("accountId").getter(getter(AssumedRole::accountId)).setter(setter(Builder::accountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accountId").build()).build();

    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("arn")
            .getter(getter(AssumedRole::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()).build();

    private static final SdkField<String> PRINCIPAL_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("principalId").getter(getter(AssumedRole::principalId)).setter(setter(Builder::principalId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("principalId").build()).build();

    private static final SdkField<SessionContext> SESSION_CONTEXT_FIELD = SdkField
            .<SessionContext> builder(MarshallingType.SDK_POJO).memberName("sessionContext")
            .getter(getter(AssumedRole::sessionContext)).setter(setter(Builder::sessionContext))
            .constructor(SessionContext::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sessionContext").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCESS_KEY_ID_FIELD,
            ACCOUNT_ID_FIELD, ARN_FIELD, PRINCIPAL_ID_FIELD, SESSION_CONTEXT_FIELD));

    private static final long serialVersionUID = 1L;

    private final String accessKeyId;

    private final String accountId;

    private final String arn;

    private final String principalId;

    private final SessionContext sessionContext;

    private AssumedRole(BuilderImpl builder) {
        this.accessKeyId = builder.accessKeyId;
        this.accountId = builder.accountId;
        this.arn = builder.arn;
        this.principalId = builder.principalId;
        this.sessionContext = builder.sessionContext;
    }

    /**
     * <p>
     * The AWS access key ID that identifies the credentials.
     * </p>
     * 
     * @return The AWS access key ID that identifies the credentials.
     */
    public final String accessKeyId() {
        return accessKeyId;
    }

    /**
     * <p>
     * The unique identifier for the AWS account that owns the entity that was used to get the credentials.
     * </p>
     * 
     * @return The unique identifier for the AWS account that owns the entity that was used to get the credentials.
     */
    public final String accountId() {
        return accountId;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the entity that was used to get the credentials.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the entity that was used to get the credentials.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The unique identifier for the entity that was used to get the credentials.
     * </p>
     * 
     * @return The unique identifier for the entity that was used to get the credentials.
     */
    public final String principalId() {
        return principalId;
    }

    /**
     * <p>
     * The details of the session that was created for the credentials, including the entity that issued the session.
     * </p>
     * 
     * @return The details of the session that was created for the credentials, including the entity that issued the
     *         session.
     */
    public final SessionContext sessionContext() {
        return sessionContext;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(accessKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(accountId());
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(principalId());
        hashCode = 31 * hashCode + Objects.hashCode(sessionContext());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssumedRole)) {
            return false;
        }
        AssumedRole other = (AssumedRole) obj;
        return Objects.equals(accessKeyId(), other.accessKeyId()) && Objects.equals(accountId(), other.accountId())
                && Objects.equals(arn(), other.arn()) && Objects.equals(principalId(), other.principalId())
                && Objects.equals(sessionContext(), other.sessionContext());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AssumedRole").add("AccessKeyId", accessKeyId()).add("AccountId", accountId()).add("Arn", arn())
                .add("PrincipalId", principalId()).add("SessionContext", sessionContext()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "accessKeyId":
            return Optional.ofNullable(clazz.cast(accessKeyId()));
        case "accountId":
            return Optional.ofNullable(clazz.cast(accountId()));
        case "arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "principalId":
            return Optional.ofNullable(clazz.cast(principalId()));
        case "sessionContext":
            return Optional.ofNullable(clazz.cast(sessionContext()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AssumedRole, T> g) {
        return obj -> g.apply((AssumedRole) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AssumedRole> {
        /**
         * <p>
         * The AWS access key ID that identifies the credentials.
         * </p>
         * 
         * @param accessKeyId
         *        The AWS access key ID that identifies the credentials.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accessKeyId(String accessKeyId);

        /**
         * <p>
         * The unique identifier for the AWS account that owns the entity that was used to get the credentials.
         * </p>
         * 
         * @param accountId
         *        The unique identifier for the AWS account that owns the entity that was used to get the credentials.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountId(String accountId);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the entity that was used to get the credentials.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) of the entity that was used to get the credentials.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The unique identifier for the entity that was used to get the credentials.
         * </p>
         * 
         * @param principalId
         *        The unique identifier for the entity that was used to get the credentials.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder principalId(String principalId);

        /**
         * <p>
         * The details of the session that was created for the credentials, including the entity that issued the
         * session.
         * </p>
         * 
         * @param sessionContext
         *        The details of the session that was created for the credentials, including the entity that issued the
         *        session.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sessionContext(SessionContext sessionContext);

        /**
         * <p>
         * The details of the session that was created for the credentials, including the entity that issued the
         * session.
         * </p>
         * This is a convenience that creates an instance of the {@link SessionContext.Builder} avoiding the need to
         * create one manually via {@link SessionContext#builder()}.
         *
         * When the {@link Consumer} completes, {@link SessionContext.Builder#build()} is called immediately and its
         * result is passed to {@link #sessionContext(SessionContext)}.
         * 
         * @param sessionContext
         *        a consumer that will call methods on {@link SessionContext.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sessionContext(SessionContext)
         */
        default Builder sessionContext(Consumer<SessionContext.Builder> sessionContext) {
            return sessionContext(SessionContext.builder().applyMutation(sessionContext).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String accessKeyId;

        private String accountId;

        private String arn;

        private String principalId;

        private SessionContext sessionContext;

        private BuilderImpl() {
        }

        private BuilderImpl(AssumedRole model) {
            accessKeyId(model.accessKeyId);
            accountId(model.accountId);
            arn(model.arn);
            principalId(model.principalId);
            sessionContext(model.sessionContext);
        }

        public final String getAccessKeyId() {
            return accessKeyId;
        }

        @Override
        public final Builder accessKeyId(String accessKeyId) {
            this.accessKeyId = accessKeyId;
            return this;
        }

        public final void setAccessKeyId(String accessKeyId) {
            this.accessKeyId = accessKeyId;
        }

        public final String getAccountId() {
            return accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        public final String getArn() {
            return arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final String getPrincipalId() {
            return principalId;
        }

        @Override
        public final Builder principalId(String principalId) {
            this.principalId = principalId;
            return this;
        }

        public final void setPrincipalId(String principalId) {
            this.principalId = principalId;
        }

        public final SessionContext.Builder getSessionContext() {
            return sessionContext != null ? sessionContext.toBuilder() : null;
        }

        @Override
        public final Builder sessionContext(SessionContext sessionContext) {
            this.sessionContext = sessionContext;
            return this;
        }

        public final void setSessionContext(SessionContext.BuilderImpl sessionContext) {
            this.sessionContext = sessionContext != null ? sessionContext.build() : null;
        }

        @Override
        public AssumedRole build() {
            return new AssumedRole(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
