/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.macie2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies the location of an occurrence of sensitive data in a Microsoft Excel workbook, CSV file, or TSV file.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Cell implements SdkPojo, Serializable, ToCopyableBuilder<Cell.Builder, Cell> {
    private static final SdkField<String> CELL_REFERENCE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("cellReference").getter(getter(Cell::cellReference)).setter(setter(Builder::cellReference))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cellReference").build()).build();

    private static final SdkField<Long> COLUMN_FIELD = SdkField.<Long> builder(MarshallingType.LONG).memberName("column")
            .getter(getter(Cell::column)).setter(setter(Builder::column))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("column").build()).build();

    private static final SdkField<String> COLUMN_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("columnName").getter(getter(Cell::columnName)).setter(setter(Builder::columnName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("columnName").build()).build();

    private static final SdkField<Long> ROW_FIELD = SdkField.<Long> builder(MarshallingType.LONG).memberName("row")
            .getter(getter(Cell::row)).setter(setter(Builder::row))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("row").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CELL_REFERENCE_FIELD,
            COLUMN_FIELD, COLUMN_NAME_FIELD, ROW_FIELD));

    private static final long serialVersionUID = 1L;

    private final String cellReference;

    private final Long column;

    private final String columnName;

    private final Long row;

    private Cell(BuilderImpl builder) {
        this.cellReference = builder.cellReference;
        this.column = builder.column;
        this.columnName = builder.columnName;
        this.row = builder.row;
    }

    /**
     * <p>
     * The location of the cell, as an absolute cell reference, that contains the data. For example, Sheet2!C5 for cell
     * C5 on Sheet2 in a Microsoft Excel workbook. This value is null for CSV and TSV files.
     * </p>
     * 
     * @return The location of the cell, as an absolute cell reference, that contains the data. For example, Sheet2!C5
     *         for cell C5 on Sheet2 in a Microsoft Excel workbook. This value is null for CSV and TSV files.
     */
    public final String cellReference() {
        return cellReference;
    }

    /**
     * <p>
     * The column number of the column that contains the data. For a Microsoft Excel workbook, this value correlates to
     * the alphabetical character(s) for a column identifier. For example, 1 for column A, 2 for column B, and so on.
     * </p>
     * 
     * @return The column number of the column that contains the data. For a Microsoft Excel workbook, this value
     *         correlates to the alphabetical character(s) for a column identifier. For example, 1 for column A, 2 for
     *         column B, and so on.
     */
    public final Long column() {
        return column;
    }

    /**
     * <p>
     * The name of the column that contains the data, if available. This value is also null if Amazon Macie detects
     * sensitive data in the name of any column in the file.
     * </p>
     * 
     * @return The name of the column that contains the data, if available. This value is also null if Amazon Macie
     *         detects sensitive data in the name of any column in the file.
     */
    public final String columnName() {
        return columnName;
    }

    /**
     * <p>
     * The row number of the row that contains the data.
     * </p>
     * 
     * @return The row number of the row that contains the data.
     */
    public final Long row() {
        return row;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(cellReference());
        hashCode = 31 * hashCode + Objects.hashCode(column());
        hashCode = 31 * hashCode + Objects.hashCode(columnName());
        hashCode = 31 * hashCode + Objects.hashCode(row());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Cell)) {
            return false;
        }
        Cell other = (Cell) obj;
        return Objects.equals(cellReference(), other.cellReference()) && Objects.equals(column(), other.column())
                && Objects.equals(columnName(), other.columnName()) && Objects.equals(row(), other.row());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Cell").add("CellReference", cellReference()).add("Column", column())
                .add("ColumnName", columnName()).add("Row", row()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "cellReference":
            return Optional.ofNullable(clazz.cast(cellReference()));
        case "column":
            return Optional.ofNullable(clazz.cast(column()));
        case "columnName":
            return Optional.ofNullable(clazz.cast(columnName()));
        case "row":
            return Optional.ofNullable(clazz.cast(row()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Cell, T> g) {
        return obj -> g.apply((Cell) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Cell> {
        /**
         * <p>
         * The location of the cell, as an absolute cell reference, that contains the data. For example, Sheet2!C5 for
         * cell C5 on Sheet2 in a Microsoft Excel workbook. This value is null for CSV and TSV files.
         * </p>
         * 
         * @param cellReference
         *        The location of the cell, as an absolute cell reference, that contains the data. For example,
         *        Sheet2!C5 for cell C5 on Sheet2 in a Microsoft Excel workbook. This value is null for CSV and TSV
         *        files.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cellReference(String cellReference);

        /**
         * <p>
         * The column number of the column that contains the data. For a Microsoft Excel workbook, this value correlates
         * to the alphabetical character(s) for a column identifier. For example, 1 for column A, 2 for column B, and so
         * on.
         * </p>
         * 
         * @param column
         *        The column number of the column that contains the data. For a Microsoft Excel workbook, this value
         *        correlates to the alphabetical character(s) for a column identifier. For example, 1 for column A, 2
         *        for column B, and so on.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder column(Long column);

        /**
         * <p>
         * The name of the column that contains the data, if available. This value is also null if Amazon Macie detects
         * sensitive data in the name of any column in the file.
         * </p>
         * 
         * @param columnName
         *        The name of the column that contains the data, if available. This value is also null if Amazon Macie
         *        detects sensitive data in the name of any column in the file.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder columnName(String columnName);

        /**
         * <p>
         * The row number of the row that contains the data.
         * </p>
         * 
         * @param row
         *        The row number of the row that contains the data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder row(Long row);
    }

    static final class BuilderImpl implements Builder {
        private String cellReference;

        private Long column;

        private String columnName;

        private Long row;

        private BuilderImpl() {
        }

        private BuilderImpl(Cell model) {
            cellReference(model.cellReference);
            column(model.column);
            columnName(model.columnName);
            row(model.row);
        }

        public final String getCellReference() {
            return cellReference;
        }

        @Override
        public final Builder cellReference(String cellReference) {
            this.cellReference = cellReference;
            return this;
        }

        public final void setCellReference(String cellReference) {
            this.cellReference = cellReference;
        }

        public final Long getColumn() {
            return column;
        }

        @Override
        public final Builder column(Long column) {
            this.column = column;
            return this;
        }

        public final void setColumn(Long column) {
            this.column = column;
        }

        public final String getColumnName() {
            return columnName;
        }

        @Override
        public final Builder columnName(String columnName) {
            this.columnName = columnName;
            return this;
        }

        public final void setColumnName(String columnName) {
            this.columnName = columnName;
        }

        public final Long getRow() {
            return row;
        }

        @Override
        public final Builder row(Long row) {
            this.row = row;
            return this;
        }

        public final void setRow(Long row) {
            this.row = row;
        }

        @Override
        public Cell build() {
            return new Cell(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
