/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.macie2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides information about a sensitive data finding, including the classification job that produced the finding.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ClassificationDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<ClassificationDetails.Builder, ClassificationDetails> {
    private static final SdkField<String> DETAILED_RESULTS_LOCATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("detailedResultsLocation").getter(getter(ClassificationDetails::detailedResultsLocation))
            .setter(setter(Builder::detailedResultsLocation))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("detailedResultsLocation").build())
            .build();

    private static final SdkField<String> JOB_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("jobArn")
            .getter(getter(ClassificationDetails::jobArn)).setter(setter(Builder::jobArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobArn").build()).build();

    private static final SdkField<String> JOB_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("jobId")
            .getter(getter(ClassificationDetails::jobId)).setter(setter(Builder::jobId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobId").build()).build();

    private static final SdkField<ClassificationResult> RESULT_FIELD = SdkField
            .<ClassificationResult> builder(MarshallingType.SDK_POJO).memberName("result")
            .getter(getter(ClassificationDetails::result)).setter(setter(Builder::result))
            .constructor(ClassificationResult::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("result").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            DETAILED_RESULTS_LOCATION_FIELD, JOB_ARN_FIELD, JOB_ID_FIELD, RESULT_FIELD));

    private static final long serialVersionUID = 1L;

    private final String detailedResultsLocation;

    private final String jobArn;

    private final String jobId;

    private final ClassificationResult result;

    private ClassificationDetails(BuilderImpl builder) {
        this.detailedResultsLocation = builder.detailedResultsLocation;
        this.jobArn = builder.jobArn;
        this.jobId = builder.jobId;
        this.result = builder.result;
    }

    /**
     * <p>
     * The path to the folder or file (in Amazon S3) that contains the corresponding sensitive data discovery result for
     * the finding. If a finding applies to a large archive or compressed file, this value is the path to a folder.
     * Otherwise, this value is the path to a file.
     * </p>
     * 
     * @return The path to the folder or file (in Amazon S3) that contains the corresponding sensitive data discovery
     *         result for the finding. If a finding applies to a large archive or compressed file, this value is the
     *         path to a folder. Otherwise, this value is the path to a file.
     */
    public final String detailedResultsLocation() {
        return detailedResultsLocation;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the classification job that produced the finding.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the classification job that produced the finding.
     */
    public final String jobArn() {
        return jobArn;
    }

    /**
     * <p>
     * The unique identifier for the classification job that produced the finding.
     * </p>
     * 
     * @return The unique identifier for the classification job that produced the finding.
     */
    public final String jobId() {
        return jobId;
    }

    /**
     * <p>
     * The status and other details of the finding.
     * </p>
     * 
     * @return The status and other details of the finding.
     */
    public final ClassificationResult result() {
        return result;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(detailedResultsLocation());
        hashCode = 31 * hashCode + Objects.hashCode(jobArn());
        hashCode = 31 * hashCode + Objects.hashCode(jobId());
        hashCode = 31 * hashCode + Objects.hashCode(result());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ClassificationDetails)) {
            return false;
        }
        ClassificationDetails other = (ClassificationDetails) obj;
        return Objects.equals(detailedResultsLocation(), other.detailedResultsLocation())
                && Objects.equals(jobArn(), other.jobArn()) && Objects.equals(jobId(), other.jobId())
                && Objects.equals(result(), other.result());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ClassificationDetails").add("DetailedResultsLocation", detailedResultsLocation())
                .add("JobArn", jobArn()).add("JobId", jobId()).add("Result", result()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "detailedResultsLocation":
            return Optional.ofNullable(clazz.cast(detailedResultsLocation()));
        case "jobArn":
            return Optional.ofNullable(clazz.cast(jobArn()));
        case "jobId":
            return Optional.ofNullable(clazz.cast(jobId()));
        case "result":
            return Optional.ofNullable(clazz.cast(result()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ClassificationDetails, T> g) {
        return obj -> g.apply((ClassificationDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ClassificationDetails> {
        /**
         * <p>
         * The path to the folder or file (in Amazon S3) that contains the corresponding sensitive data discovery result
         * for the finding. If a finding applies to a large archive or compressed file, this value is the path to a
         * folder. Otherwise, this value is the path to a file.
         * </p>
         * 
         * @param detailedResultsLocation
         *        The path to the folder or file (in Amazon S3) that contains the corresponding sensitive data discovery
         *        result for the finding. If a finding applies to a large archive or compressed file, this value is the
         *        path to a folder. Otherwise, this value is the path to a file.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder detailedResultsLocation(String detailedResultsLocation);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the classification job that produced the finding.
         * </p>
         * 
         * @param jobArn
         *        The Amazon Resource Name (ARN) of the classification job that produced the finding.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobArn(String jobArn);

        /**
         * <p>
         * The unique identifier for the classification job that produced the finding.
         * </p>
         * 
         * @param jobId
         *        The unique identifier for the classification job that produced the finding.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobId(String jobId);

        /**
         * <p>
         * The status and other details of the finding.
         * </p>
         * 
         * @param result
         *        The status and other details of the finding.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder result(ClassificationResult result);

        /**
         * <p>
         * The status and other details of the finding.
         * </p>
         * This is a convenience that creates an instance of the {@link ClassificationResult.Builder} avoiding the need
         * to create one manually via {@link ClassificationResult#builder()}.
         *
         * When the {@link Consumer} completes, {@link ClassificationResult.Builder#build()} is called immediately and
         * its result is passed to {@link #result(ClassificationResult)}.
         * 
         * @param result
         *        a consumer that will call methods on {@link ClassificationResult.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #result(ClassificationResult)
         */
        default Builder result(Consumer<ClassificationResult.Builder> result) {
            return result(ClassificationResult.builder().applyMutation(result).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String detailedResultsLocation;

        private String jobArn;

        private String jobId;

        private ClassificationResult result;

        private BuilderImpl() {
        }

        private BuilderImpl(ClassificationDetails model) {
            detailedResultsLocation(model.detailedResultsLocation);
            jobArn(model.jobArn);
            jobId(model.jobId);
            result(model.result);
        }

        public final String getDetailedResultsLocation() {
            return detailedResultsLocation;
        }

        @Override
        public final Builder detailedResultsLocation(String detailedResultsLocation) {
            this.detailedResultsLocation = detailedResultsLocation;
            return this;
        }

        public final void setDetailedResultsLocation(String detailedResultsLocation) {
            this.detailedResultsLocation = detailedResultsLocation;
        }

        public final String getJobArn() {
            return jobArn;
        }

        @Override
        public final Builder jobArn(String jobArn) {
            this.jobArn = jobArn;
            return this;
        }

        public final void setJobArn(String jobArn) {
            this.jobArn = jobArn;
        }

        public final String getJobId() {
            return jobId;
        }

        @Override
        public final Builder jobId(String jobId) {
            this.jobId = jobId;
            return this;
        }

        public final void setJobId(String jobId) {
            this.jobId = jobId;
        }

        public final ClassificationResult.Builder getResult() {
            return result != null ? result.toBuilder() : null;
        }

        @Override
        public final Builder result(ClassificationResult result) {
            this.result = result;
            return this;
        }

        public final void setResult(ClassificationResult.BuilderImpl result) {
            this.result = result != null ? result.build() : null;
        }

        @Override
        public ClassificationDetails build() {
            return new ClassificationDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
