/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.macie2.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;

/**
 * <p>
 * The frequency with which Amazon Macie publishes updates to policy findings for an account. This includes publishing
 * updates to Security Hub and Amazon EventBridge (formerly called Amazon CloudWatch Events). For more information, see
 * <a href="https://docs.aws.amazon.com/macie/latest/user/findings-monitor.html">Monitoring and processing findings</a>
 * in the <i>Amazon Macie User Guide</i>. Valid values are:
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public enum FindingPublishingFrequency {
    FIFTEEN_MINUTES("FIFTEEN_MINUTES"),

    ONE_HOUR("ONE_HOUR"),

    SIX_HOURS("SIX_HOURS"),

    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private FindingPublishingFrequency(String value) {
        this.value = value;
    }

    @Override
    public String toString() {
        return String.valueOf(value);
    }

    /**
     * Use this in place of valueOf to convert the raw string returned by the service into the enum value.
     *
     * @param value
     *        real value
     * @return FindingPublishingFrequency corresponding to the value
     */
    public static FindingPublishingFrequency fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(FindingPublishingFrequency.values()).filter(e -> e.toString().equals(value)).findFirst()
                .orElse(UNKNOWN_TO_SDK_VERSION);
    }

    /**
     * Use this in place of {@link #values()} to return a {@link Set} of all values known to the SDK. This will return
     * all known enum values except {@link #UNKNOWN_TO_SDK_VERSION}.
     *
     * @return a {@link Set} of known {@link FindingPublishingFrequency}s
     */
    public static Set<FindingPublishingFrequency> knownValues() {
        return Stream.of(values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}
