/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.macie2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies one or more property- and tag-based conditions that define criteria for including or excluding S3 objects
 * from a classification job.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class JobScopingBlock implements SdkPojo, Serializable, ToCopyableBuilder<JobScopingBlock.Builder, JobScopingBlock> {
    private static final SdkField<List<JobScopeTerm>> AND_FIELD = SdkField
            .<List<JobScopeTerm>> builder(MarshallingType.LIST)
            .memberName("and")
            .getter(getter(JobScopingBlock::and))
            .setter(setter(Builder::and))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("and").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<JobScopeTerm> builder(MarshallingType.SDK_POJO)
                                            .constructor(JobScopeTerm::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AND_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<JobScopeTerm> and;

    private JobScopingBlock(BuilderImpl builder) {
        this.and = builder.and;
    }

    /**
     * Returns true if the And property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasAnd() {
        return and != null && !(and instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of conditions, one for each property- or tag-based condition that determines which objects to include or
     * exclude from the job. If you specify more than one condition, Amazon Macie uses AND logic to join the conditions.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasAnd()} to see if a value was sent in this field.
     * </p>
     * 
     * @return An array of conditions, one for each property- or tag-based condition that determines which objects to
     *         include or exclude from the job. If you specify more than one condition, Amazon Macie uses AND logic to
     *         join the conditions.
     */
    public final List<JobScopeTerm> and() {
        return and;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasAnd() ? and() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof JobScopingBlock)) {
            return false;
        }
        JobScopingBlock other = (JobScopingBlock) obj;
        return hasAnd() == other.hasAnd() && Objects.equals(and(), other.and());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("JobScopingBlock").add("And", hasAnd() ? and() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "and":
            return Optional.ofNullable(clazz.cast(and()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<JobScopingBlock, T> g) {
        return obj -> g.apply((JobScopingBlock) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, JobScopingBlock> {
        /**
         * <p>
         * An array of conditions, one for each property- or tag-based condition that determines which objects to
         * include or exclude from the job. If you specify more than one condition, Amazon Macie uses AND logic to join
         * the conditions.
         * </p>
         * 
         * @param and
         *        An array of conditions, one for each property- or tag-based condition that determines which objects to
         *        include or exclude from the job. If you specify more than one condition, Amazon Macie uses AND logic
         *        to join the conditions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder and(Collection<JobScopeTerm> and);

        /**
         * <p>
         * An array of conditions, one for each property- or tag-based condition that determines which objects to
         * include or exclude from the job. If you specify more than one condition, Amazon Macie uses AND logic to join
         * the conditions.
         * </p>
         * 
         * @param and
         *        An array of conditions, one for each property- or tag-based condition that determines which objects to
         *        include or exclude from the job. If you specify more than one condition, Amazon Macie uses AND logic
         *        to join the conditions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder and(JobScopeTerm... and);

        /**
         * <p>
         * An array of conditions, one for each property- or tag-based condition that determines which objects to
         * include or exclude from the job. If you specify more than one condition, Amazon Macie uses AND logic to join
         * the conditions.
         * </p>
         * This is a convenience that creates an instance of the {@link List<JobScopeTerm>.Builder} avoiding the need to
         * create one manually via {@link List<JobScopeTerm>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<JobScopeTerm>.Builder#build()} is called immediately and its
         * result is passed to {@link #and(List<JobScopeTerm>)}.
         * 
         * @param and
         *        a consumer that will call methods on {@link List<JobScopeTerm>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #and(List<JobScopeTerm>)
         */
        Builder and(Consumer<JobScopeTerm.Builder>... and);
    }

    static final class BuilderImpl implements Builder {
        private List<JobScopeTerm> and = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(JobScopingBlock model) {
            and(model.and);
        }

        public final List<JobScopeTerm.Builder> getAnd() {
            List<JobScopeTerm.Builder> result = ___listOfJobScopeTermCopier.copyToBuilder(this.and);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder and(Collection<JobScopeTerm> and) {
            this.and = ___listOfJobScopeTermCopier.copy(and);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder and(JobScopeTerm... and) {
            and(Arrays.asList(and));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder and(Consumer<JobScopeTerm.Builder>... and) {
            and(Stream.of(and).map(c -> JobScopeTerm.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setAnd(Collection<JobScopeTerm.BuilderImpl> and) {
            this.and = ___listOfJobScopeTermCopier.copyFromBuilder(and);
        }

        @Override
        public JobScopingBlock build() {
            return new JobScopingBlock(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
