/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.macie2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class PutFindingsPublicationConfigurationRequest extends Macie2Request implements
        ToCopyableBuilder<PutFindingsPublicationConfigurationRequest.Builder, PutFindingsPublicationConfigurationRequest> {
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("clientToken")
            .getter(getter(PutFindingsPublicationConfigurationRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<SecurityHubConfiguration> SECURITY_HUB_CONFIGURATION_FIELD = SdkField
            .<SecurityHubConfiguration> builder(MarshallingType.SDK_POJO).memberName("securityHubConfiguration")
            .getter(getter(PutFindingsPublicationConfigurationRequest::securityHubConfiguration))
            .setter(setter(Builder::securityHubConfiguration)).constructor(SecurityHubConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("securityHubConfiguration").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_TOKEN_FIELD,
            SECURITY_HUB_CONFIGURATION_FIELD));

    private final String clientToken;

    private final SecurityHubConfiguration securityHubConfiguration;

    private PutFindingsPublicationConfigurationRequest(BuilderImpl builder) {
        super(builder);
        this.clientToken = builder.clientToken;
        this.securityHubConfiguration = builder.securityHubConfiguration;
    }

    /**
     * <p>
     * A unique, case-sensitive token that you provide to ensure the idempotency of the request.
     * </p>
     * 
     * @return A unique, case-sensitive token that you provide to ensure the idempotency of the request.
     */
    public final String clientToken() {
        return clientToken;
    }

    /**
     * <p>
     * The configuration settings that determine which findings to publish to Security Hub.
     * </p>
     * 
     * @return The configuration settings that determine which findings to publish to Security Hub.
     */
    public final SecurityHubConfiguration securityHubConfiguration() {
        return securityHubConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(securityHubConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutFindingsPublicationConfigurationRequest)) {
            return false;
        }
        PutFindingsPublicationConfigurationRequest other = (PutFindingsPublicationConfigurationRequest) obj;
        return Objects.equals(clientToken(), other.clientToken())
                && Objects.equals(securityHubConfiguration(), other.securityHubConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PutFindingsPublicationConfigurationRequest").add("ClientToken", clientToken())
                .add("SecurityHubConfiguration", securityHubConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "clientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "securityHubConfiguration":
            return Optional.ofNullable(clazz.cast(securityHubConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PutFindingsPublicationConfigurationRequest, T> g) {
        return obj -> g.apply((PutFindingsPublicationConfigurationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Macie2Request.Builder, SdkPojo,
            CopyableBuilder<Builder, PutFindingsPublicationConfigurationRequest> {
        /**
         * <p>
         * A unique, case-sensitive token that you provide to ensure the idempotency of the request.
         * </p>
         * 
         * @param clientToken
         *        A unique, case-sensitive token that you provide to ensure the idempotency of the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * The configuration settings that determine which findings to publish to Security Hub.
         * </p>
         * 
         * @param securityHubConfiguration
         *        The configuration settings that determine which findings to publish to Security Hub.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityHubConfiguration(SecurityHubConfiguration securityHubConfiguration);

        /**
         * <p>
         * The configuration settings that determine which findings to publish to Security Hub.
         * </p>
         * This is a convenience that creates an instance of the {@link SecurityHubConfiguration.Builder} avoiding the
         * need to create one manually via {@link SecurityHubConfiguration#builder()}.
         *
         * When the {@link Consumer} completes, {@link SecurityHubConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #securityHubConfiguration(SecurityHubConfiguration)}.
         * 
         * @param securityHubConfiguration
         *        a consumer that will call methods on {@link SecurityHubConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #securityHubConfiguration(SecurityHubConfiguration)
         */
        default Builder securityHubConfiguration(Consumer<SecurityHubConfiguration.Builder> securityHubConfiguration) {
            return securityHubConfiguration(SecurityHubConfiguration.builder().applyMutation(securityHubConfiguration).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Macie2Request.BuilderImpl implements Builder {
        private String clientToken;

        private SecurityHubConfiguration securityHubConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(PutFindingsPublicationConfigurationRequest model) {
            super(model);
            clientToken(model.clientToken);
            securityHubConfiguration(model.securityHubConfiguration);
        }

        public final String getClientToken() {
            return clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        public final SecurityHubConfiguration.Builder getSecurityHubConfiguration() {
            return securityHubConfiguration != null ? securityHubConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder securityHubConfiguration(SecurityHubConfiguration securityHubConfiguration) {
            this.securityHubConfiguration = securityHubConfiguration;
            return this;
        }

        public final void setSecurityHubConfiguration(SecurityHubConfiguration.BuilderImpl securityHubConfiguration) {
            this.securityHubConfiguration = securityHubConfiguration != null ? securityHubConfiguration.build() : null;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutFindingsPublicationConfigurationRequest build() {
            return new PutFindingsPublicationConfigurationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
