/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.macie2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies the location of an occurrence of sensitive data in a non-binary text file, such as an HTML, TXT, or XML
 * file.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Range implements SdkPojo, Serializable, ToCopyableBuilder<Range.Builder, Range> {
    private static final SdkField<Long> END_FIELD = SdkField.<Long> builder(MarshallingType.LONG).memberName("end")
            .getter(getter(Range::end)).setter(setter(Builder::end))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("end").build()).build();

    private static final SdkField<Long> START_FIELD = SdkField.<Long> builder(MarshallingType.LONG).memberName("start")
            .getter(getter(Range::start)).setter(setter(Builder::start))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("start").build()).build();

    private static final SdkField<Long> START_COLUMN_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("startColumn").getter(getter(Range::startColumn)).setter(setter(Builder::startColumn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startColumn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(END_FIELD, START_FIELD,
            START_COLUMN_FIELD));

    private static final long serialVersionUID = 1L;

    private final Long end;

    private final Long start;

    private final Long startColumn;

    private Range(BuilderImpl builder) {
        this.end = builder.end;
        this.start = builder.start;
        this.startColumn = builder.startColumn;
    }

    /**
     * <p>
     * The number of lines from the beginning of the file to the end of the sensitive data.
     * </p>
     * 
     * @return The number of lines from the beginning of the file to the end of the sensitive data.
     */
    public final Long end() {
        return end;
    }

    /**
     * <p>
     * The number of lines from the beginning of the file to the beginning of the sensitive data.
     * </p>
     * 
     * @return The number of lines from the beginning of the file to the beginning of the sensitive data.
     */
    public final Long start() {
        return start;
    }

    /**
     * <p>
     * The number of characters, with spaces and starting from 1, from the beginning of the first line that contains the
     * sensitive data (start) to the beginning of the sensitive data.
     * </p>
     * 
     * @return The number of characters, with spaces and starting from 1, from the beginning of the first line that
     *         contains the sensitive data (start) to the beginning of the sensitive data.
     */
    public final Long startColumn() {
        return startColumn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(end());
        hashCode = 31 * hashCode + Objects.hashCode(start());
        hashCode = 31 * hashCode + Objects.hashCode(startColumn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Range)) {
            return false;
        }
        Range other = (Range) obj;
        return Objects.equals(end(), other.end()) && Objects.equals(start(), other.start())
                && Objects.equals(startColumn(), other.startColumn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Range").add("End", end()).add("Start", start()).add("StartColumn", startColumn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "end":
            return Optional.ofNullable(clazz.cast(end()));
        case "start":
            return Optional.ofNullable(clazz.cast(start()));
        case "startColumn":
            return Optional.ofNullable(clazz.cast(startColumn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Range, T> g) {
        return obj -> g.apply((Range) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Range> {
        /**
         * <p>
         * The number of lines from the beginning of the file to the end of the sensitive data.
         * </p>
         * 
         * @param end
         *        The number of lines from the beginning of the file to the end of the sensitive data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder end(Long end);

        /**
         * <p>
         * The number of lines from the beginning of the file to the beginning of the sensitive data.
         * </p>
         * 
         * @param start
         *        The number of lines from the beginning of the file to the beginning of the sensitive data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder start(Long start);

        /**
         * <p>
         * The number of characters, with spaces and starting from 1, from the beginning of the first line that contains
         * the sensitive data (start) to the beginning of the sensitive data.
         * </p>
         * 
         * @param startColumn
         *        The number of characters, with spaces and starting from 1, from the beginning of the first line that
         *        contains the sensitive data (start) to the beginning of the sensitive data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startColumn(Long startColumn);
    }

    static final class BuilderImpl implements Builder {
        private Long end;

        private Long start;

        private Long startColumn;

        private BuilderImpl() {
        }

        private BuilderImpl(Range model) {
            end(model.end);
            start(model.start);
            startColumn(model.startColumn);
        }

        public final Long getEnd() {
            return end;
        }

        @Override
        public final Builder end(Long end) {
            this.end = end;
            return this;
        }

        public final void setEnd(Long end) {
            this.end = end;
        }

        public final Long getStart() {
            return start;
        }

        @Override
        public final Builder start(Long start) {
            this.start = start;
            return this;
        }

        public final void setStart(Long start) {
            this.start = start;
        }

        public final Long getStartColumn() {
            return startColumn;
        }

        @Override
        public final Builder startColumn(Long startColumn) {
            this.startColumn = startColumn;
            return this;
        }

        public final void setStartColumn(Long startColumn) {
            this.startColumn = startColumn;
        }

        @Override
        public Range build() {
            return new Range(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
