/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.macie2.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListFindingsFiltersResponse extends Macie2Response implements
        ToCopyableBuilder<ListFindingsFiltersResponse.Builder, ListFindingsFiltersResponse> {
    private static final SdkField<List<FindingsFilterListItem>> FINDINGS_FILTER_LIST_ITEMS_FIELD = SdkField
            .<List<FindingsFilterListItem>> builder(MarshallingType.LIST)
            .memberName("findingsFilterListItems")
            .getter(getter(ListFindingsFiltersResponse::findingsFilterListItems))
            .setter(setter(Builder::findingsFilterListItems))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("findingsFilterListItems").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<FindingsFilterListItem> builder(MarshallingType.SDK_POJO)
                                            .constructor(FindingsFilterListItem::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListFindingsFiltersResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            FINDINGS_FILTER_LIST_ITEMS_FIELD, NEXT_TOKEN_FIELD));

    private final List<FindingsFilterListItem> findingsFilterListItems;

    private final String nextToken;

    private ListFindingsFiltersResponse(BuilderImpl builder) {
        super(builder);
        this.findingsFilterListItems = builder.findingsFilterListItems;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the FindingsFilterListItems property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasFindingsFilterListItems() {
        return findingsFilterListItems != null && !(findingsFilterListItems instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of objects, one for each filter that's associated with the account.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFindingsFilterListItems} method.
     * </p>
     * 
     * @return An array of objects, one for each filter that's associated with the account.
     */
    public final List<FindingsFilterListItem> findingsFilterListItems() {
        return findingsFilterListItems;
    }

    /**
     * <p>
     * The string to use in a subsequent request to get the next page of results in a paginated response. This value is
     * null if there are no additional pages.
     * </p>
     * 
     * @return The string to use in a subsequent request to get the next page of results in a paginated response. This
     *         value is null if there are no additional pages.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasFindingsFilterListItems() ? findingsFilterListItems() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListFindingsFiltersResponse)) {
            return false;
        }
        ListFindingsFiltersResponse other = (ListFindingsFiltersResponse) obj;
        return hasFindingsFilterListItems() == other.hasFindingsFilterListItems()
                && Objects.equals(findingsFilterListItems(), other.findingsFilterListItems())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListFindingsFiltersResponse")
                .add("FindingsFilterListItems", hasFindingsFilterListItems() ? findingsFilterListItems() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "findingsFilterListItems":
            return Optional.ofNullable(clazz.cast(findingsFilterListItems()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListFindingsFiltersResponse, T> g) {
        return obj -> g.apply((ListFindingsFiltersResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Macie2Response.Builder, SdkPojo, CopyableBuilder<Builder, ListFindingsFiltersResponse> {
        /**
         * <p>
         * An array of objects, one for each filter that's associated with the account.
         * </p>
         * 
         * @param findingsFilterListItems
         *        An array of objects, one for each filter that's associated with the account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder findingsFilterListItems(Collection<FindingsFilterListItem> findingsFilterListItems);

        /**
         * <p>
         * An array of objects, one for each filter that's associated with the account.
         * </p>
         * 
         * @param findingsFilterListItems
         *        An array of objects, one for each filter that's associated with the account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder findingsFilterListItems(FindingsFilterListItem... findingsFilterListItems);

        /**
         * <p>
         * An array of objects, one for each filter that's associated with the account.
         * </p>
         * This is a convenience that creates an instance of the {@link List<FindingsFilterListItem>.Builder} avoiding
         * the need to create one manually via {@link List<FindingsFilterListItem>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<FindingsFilterListItem>.Builder#build()} is called
         * immediately and its result is passed to {@link #findingsFilterListItems(List<FindingsFilterListItem>)}.
         * 
         * @param findingsFilterListItems
         *        a consumer that will call methods on {@link List<FindingsFilterListItem>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #findingsFilterListItems(List<FindingsFilterListItem>)
         */
        Builder findingsFilterListItems(Consumer<FindingsFilterListItem.Builder>... findingsFilterListItems);

        /**
         * <p>
         * The string to use in a subsequent request to get the next page of results in a paginated response. This value
         * is null if there are no additional pages.
         * </p>
         * 
         * @param nextToken
         *        The string to use in a subsequent request to get the next page of results in a paginated response.
         *        This value is null if there are no additional pages.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends Macie2Response.BuilderImpl implements Builder {
        private List<FindingsFilterListItem> findingsFilterListItems = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListFindingsFiltersResponse model) {
            super(model);
            findingsFilterListItems(model.findingsFilterListItems);
            nextToken(model.nextToken);
        }

        public final List<FindingsFilterListItem.Builder> getFindingsFilterListItems() {
            List<FindingsFilterListItem.Builder> result = ___listOfFindingsFilterListItemCopier
                    .copyToBuilder(this.findingsFilterListItems);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFindingsFilterListItems(Collection<FindingsFilterListItem.BuilderImpl> findingsFilterListItems) {
            this.findingsFilterListItems = ___listOfFindingsFilterListItemCopier.copyFromBuilder(findingsFilterListItems);
        }

        @Override
        @Transient
        public final Builder findingsFilterListItems(Collection<FindingsFilterListItem> findingsFilterListItems) {
            this.findingsFilterListItems = ___listOfFindingsFilterListItemCopier.copy(findingsFilterListItems);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder findingsFilterListItems(FindingsFilterListItem... findingsFilterListItems) {
            findingsFilterListItems(Arrays.asList(findingsFilterListItems));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder findingsFilterListItems(Consumer<FindingsFilterListItem.Builder>... findingsFilterListItems) {
            findingsFilterListItems(Stream.of(findingsFilterListItems)
                    .map(c -> FindingsFilterListItem.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        @Transient
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListFindingsFiltersResponse build() {
            return new ListFindingsFiltersResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
